#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"

#define	ZERO(x)	hasvalue(x,0)		/* test if value is 0 */
#define	ONE(x)	hasvalue(x,1)		/* test if value is 1 */
#define	MINUSONE(x)	hasvalue(x,-1)	/* test if value is -1 */


char ltst_ops[]		/* right side is zero */
{ TEQ_OP, TNE_OP, TGT_OP, TGE_OP, TLT_OP, TLE_OP };

char rtst_ops[]		/* left side is zero */
{ TEQ_OP, TNE_OP, TLE_OP, TLT_OP, TGE_OP, TGT_OP };

consteval(op,type,left,right)
{
/*
 * optimize evaluation of an expression with one or more constant
 * terms. mostly useful for efficient subscript calculations.
 * sequences checked for are:
 * constant op constant ==> constant
 * expr (+-) zero ==> expr
 * zero + expr ==> expr
 * zero - expr ==> -expr
 * expr (/ *) one ==> expr 
 * constant * (constant (+-) expr)
 */
register char *l, *r;
register char *result;

result = l = r = 0;
if (CONSTEXPR(left))
	l = left;
if (CONSTEXPR(right))
	{
	r = right;
	if (op == DIV_OP && ZERO(r))
		ERR("division by zero",E_ZDIV);
	}
if (l && r)
	{
	switch(type)
		{
	case CHARACTER:
		result = l->s_slen;
		move(result,l->s_string,sym_string);
		move(r->s_slen,r->s_string,sym_string+result);
		sym_slen = result + r->s_slen;
		senter();
		result = cur_sym;
		break;
	case INT2:
	case LOG1:
	case LOG2:
		result = eval(op,type,l->s_int+0.0,r->s_int+0.0);
		break;
	case INT4:
		result = eval(op,type,qload(l->s_qint),qload(r->s_qint));
		break;
	case REAL4:
	case REAL8:
		result = eval(op,type,l->s_float,r->s_float);
		break;
		}
	if(result)
		return(result);
	}
if(r)
	{		/* right side is constant, left is not */
	switch(op)
		{
	case EQ_OP:
	case NE_OP:
	case LE_OP:
	case LT_OP:
	case GT_OP:
	case GE_OP:
		if(ZERO(r))
			return(unary(ltst_ops[op-REL_OPS],left));
		break;
	case SUB_OP:
		op = ADD_OP;
		right = r = unary(NEG_OP,r);	/* l-r ==> l+(-r) */
	case ADD_OP:
		if(dtest(left,ADD_OP))
			return(assoc(op,right,left));
	case MUL_OP:
		right = left; l = left = r; r = 0;	/* const on left */
		break;
	case DIV_OP:
		if(ONE(r))
			return(left);
		if (MINUSONE(r))
			return(unary(NEG_OP,left));
		break;
		}
	}
if(l)
	{		/* left side is a constant, right is not */
	switch(op)
		{
	case CHK_OP:
		if (intvalue(l) < 0)
			badsc();
		break;
	case EQ_OP:
	case NE_OP:
	case LE_OP:
	case LT_OP:
	case GT_OP:
	case GE_OP:
		if(ZERO(l))
			return(unary(rtst_ops[op-REL_OPS],right));
		break;
	case ADD_OP:
		if (ZERO(l))
			return(right);
		if(dtest(right,ADD_OP))		/* const + (const + expr) */
			return(assoc(op,left,right));
		break;
	case SUB_OP:
		if(ZERO(l))
			return(unary(NEG_OP,right));
		break;
	case MUL_OP:
		if(ZERO(l))
			return(fconst(0.0,type));
		if(ONE(l))
			return(right);
		if(dtest(right,ADD_OP))
			return(distrib(op,left,right));
		if(dtest(right,MUL_OP))
			return(assoc(op,left,right));
		if (MINUSONE(l))
			return(unary(NEG_OP,right));
		}
	}
return(mnode(op,type,left,right));
}

eval(op,type,left,right) double left, right;
{
register int k;
static double result;

switch(op)
	{
case CHK_OP:
	if (left < 0 || left >= right)
		badsc();
	result = left;
	break;
case ADD_OP:
	result = left+right;
	break;
case SUB_OP:
	result = left-right;
	break;
case DIV_OP:
	result = left/right;
	break;
case MUL_OP:
	result = left*right;
	break;
case GT_OP:
	result = left > right;
	break;
case GE_OP:
	result = left >= right;
	break;
case EQ_OP:
	result = left == right;
	break;
case NE_OP:
	result = left != right;
	break;
case LT_OP:
	result = left < right;
	break;
case LE_OP:
	result = left <= right;
	break;
case AND_OP:
	result = (left != 0) && (right != 0);
	break;
case OR_OP:
	result = (left != 0) || (right != 0);
	break;
default:
	return(FAIL);		/* for exp etc. */
	}
return(fconst(result,type));
}

intvalue(s) char *s;
{
/*
 * return the value of an integer constant symbol table
 * entry. check it too.
 */
register char *p;
register int i;

p = s;
if (!constant(p))
	SERR("constant required",E_CONST);
switch(p->s_type)
	{
default:
	SERR("integer required",E_INT);
case INT2:
	i = p->s_int;
	break;
case INT4:
	i = qload(p->s_qint);		/* convert to integer */
	}
return(i);
}

double fetch(s) char *s;
{
/*
 * return the value of a symbol table entry as a floating
 * point number.
 */
register char *p;
register int i;

p = s;
if (!constant(p))
	SERR("constant required",E_CONST);
switch(p->s_type)
	{
default:
	return(p->s_int+0.0);
case INT4:
	return(qload(p->s_qint));		/* convert to integer */
case REAL4:
case REAL8:
	return(p->s_float);
case CMPLX8:
case CMPLX16:
	return(fetch(p->s_real));		/* return real part */
	}
}
