/*			Copyright 1977 by Bill Webb.	 		*/
/*			Copyright 1979 by Bill Webb.	 		*/
/* following debug enables compiler internal checks */
/* #define	debug	1 */
/*
 *	variable/constant types/modes
 */
#define	NOTYPE	0		/* no type present */
#define	INT2	1
#define	INT4	2
#define	REAL4	3
#define	REAL8	4
#define	LOG1	5
#define	LOG2	6
#define	CMPLX8	7
#define	CMPLX16	8
#define	STRING	9
#define	CHARACTER	STRING
#define	MAXTYPE	(STRING+1)		/* maximum type in expressions */
#define	LABEL	10
#define	PARAMETER	11		/* parameter variable */
#define	SPTYPE	12			/* special type code base */

/* macro definitions for frequently used tests */
#define	testc(c)	(*inptr == (c) && ++inptr)
#define	optc(c)		(*inptr == (c))
#define	ZERO(x)	hasvalue(x,0)		/* test if value is 0 */

struct proto
{
char *p_name;		/* statement header string */
int p_type;		/* stmt type */
} stmts[];

char *argp;		/* current argument */
int line;		/* current line */
int stmt;		/* current stmt type */
int isn;		/* current isn # */
int lastisn;		/* previous isn */
#define	MAXCHAR	128		/* maximum number of characters */
char chtype[MAXCHAR];		/* character types table */
#define	chartype(c)	chtype[c]
#define	IMPSIZE	('z'-'a'+1)	/* implicit table size */
char imptab[IMPSIZE];	/* implicit mode table */
char implen[IMPSIZE];	/* implicit length table */
char *inptr;		/* input line pointer */
char *outptr;		/* output line pointer for compress */
#define	MAXBUFF	(72 + 19*66)	/* maximum input line length */
char inbuff[MAXBUFF];	/* statemet input buffer */
#define	CONT_COLUMN	(inbuff+5)	/* column 6 */
#define	LAST_COLUMN	72		/* last column of a line */
#define	MAXLINE	256
char savebuff[MAXLINE];	/* saved input line */
int goterr;		/* flag to indicate error present */
#define	FAIL	0
#define	OK	1
/* chartype classification of characters */
int comma;
#define	NULL	0
int goteof;		/* if alread read eof */
char typelens[];
char alttypes[];		/* alternate types for optional lengths */
char *typenames[];
int intmode;			/* default integer mode */
char *symbeg, *symlast, *symend;
char *textbeg, *textlast;
char *savetext;		/* last textlast value for errors */
#define	textend	symbeg
int fn_sym;			/* function symbol offset */
struct proto types[];		/* symbol types */
char *locnames[];
#define	NAMESIZE	6
char label[NAMESIZE];	/* current label string */
int listcnt;		/* number of elements found in lists */
char *treep;		/* current stmt tree */
int opmax;
char *stmtchain;		/* first statment chain */
int do_range;		/* first nested do loop */
int extend;		/* flag extensions */
int iflevel;			/* level of block if in effect */
int dolevel;			/* level of do loop nesting */
char *textmax;
int tmpdes;		/* temp file descriptor */
int tempcnt;		/* temp var cnt */
char progname[8];	/* name of program */
int progtype;		/* type of program. one of: */
#define	MAIN		0	/* main program */
#define	SUBROUTINE	1	/* subroutine */
#define	FUNCTION	2	/* function */
#define	ENTRY		3
#define	BLOCK		4
int eject;		/* page eject flag */
int aflg;		/* statistics print flag */
int dflg;		/* debug mode (user) */
int tflg;		/* two word integer mode */
int lflg;		/* listing control flag */
int cflg;		/* print code generation */
int pflg;		/* print tree flag */
int prflg;		/* profile flag */
int mflg;		/* print map */
int eflg;		/* if extended input line */
int dclflg;		/* force declarations */
int qflg;		/* special debug mode */
int seqflg;		/* generate sequence info */
int sflg;		/* generate local symbol table */
int aflg;		/* statistics print flag */
int hflg;		/* give headings */
int srcline;		/* line number of current stmt */
int abflg;		/* abort compiler on error */
int laststmt;		/* last statement type */
int slflg;		/* sequence with src line #'s */
int chkflg;		/* check subscripts flag */
int wflg;		/* suppress warnings */
int nflg;		/* no object generation */
int iflg;		/* inhibit link on any error */
int acflg;		/* provide better C interface */
int maxorder;		/* maximum order type found yet */
int condcomp;		/* conditional compilation (if (.false.) then ...) */
int warncnt;
int errcnt;		/* number of errors found */
char version[];		/* version number of compiler */
int rc;			/* return code on normal exit */
