#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "char.h"
/*			Copyright 1977 by Bill Webb.	 		*/

int printed;			/* line printed flag */
#define	NL	'\n'	/* end of line */
#define	EOF	-1
int savedes -1;		/* saved input file descriptor */
int savelnr;		/* saved line number */

readstmt()
{
/*
 * read one line and return it in "inbuff".
 * the lookahead line will be in "savebuff".
 */
register int c;
register char *p, *q;

p = inbuff;
mainloop:			/* copy saved record into buffer */
srcline = line;			/* copy line number */
q = savebuff;
while (*p++ = *q++) ;		/* copy saved buffer */
--p;

loop:			/* read next line and check if continuation */
if (readline(savebuff,MAXLINE) == EOF)
	{
	if (inbuff[0] == 0)
		return(FAIL);
	else
		return(OK);
	}
q = savebuff;
c = *q;
/*
 * allow line to begin with a "d".
 * if in dflg mode the line is compiled (d ==> blank)
 * if not line is ignored (d ==> c)
 */
if (c == 'd' || c == 'D')
	{
	if (dflg)		/* include debug stmts */
		*q = ' ';
	else
		*q = 'c';	/* make into comment */
	c = *q;			/* pick it up again */
	}
/*
 * a comment line is a line beginning with either "c" or "*".
 * see later section for blanks lines (also ignored as comments).
 */
if (c == STAR || c == 'c' || c== 'C' || c == COMCHAR || c == '/')	/* ignore comments here */
	goto loop;		/* ignore line, get another */
/*
 * test if the line is a continuation:
 * column 6 is neither "0" or " ".
 */
c = 0;
do
	++c;
while (*q++ == ' ');
if (q[-1] == 0)
	goto loop;		/* if completely blank ignore */
if (q[-1] == TAB)
	c = 7;
if (c == 6 || q[-1] == '&')		/* non-blank column 6 or its '&' */
	if (q[-1] =='0')
		q[-1] = ' ';		/* treat '0' in col 6 as ' ' */
	else
		{			/* got a legit continuation col */
		if (p == inbuff)	/* no statement yet */
			ERR("invalid continuation",E_CONT);
		while (*p++ = *q++)		/* copy rest of line */
			if (p >= inbuff+MAXBUFF)
				ERR("too many continuations",E_BIGCONT);
		--p;
		goto loop;		/* read another line */
		}
if (inbuff[0] == 0)
	goto mainloop;			/* first line */
return(OK);
}

readline(buff,length) char *buff;
{
/*
 * read a line into "buff", no longer than "length".
 */
register char *p, *maxbuff;
register int c;
extern int fin[];

loop:				/* come here if eof on #include */
print();
savebuff[0] = 0;		/* clear buffer */
if (goteof)
	return(EOF);
p = buff;
++line;
maxbuff = p + length - 1;
while ((c = getchar()&0177) && c!=NL)
	{
	if (p >= maxbuff)
		{
		while ((c = getchar()&0177) && c!=NL)
			; /* flush out the line */
		p[-1] = NULL;
		ERROR("line too long",E_LINE);
		}
	else
		*p++ = c;
	}
if (c && p == buff)
	*p++ = ' ';		/* insure we print blank lines */
*p = 0;
if (c == 0)
	{
	if (savedes >= 0)
		{
		close(fin[0]);		/* close include file */
		fin[0] = savedes;
		savedes = -1;
		line = savelnr;
		goto loop;		/* continue reading */
		}
	++goteof;
	return(EOF);
	}
printed = 0;
if (!eflg)
	buff[LAST_COLUMN] = 0;		/* remove anything past 72 */
if (buff[0] == '#')
	{
	include(buff);
	goto loop;
	}
return(p-buff);
}


print()
{
/*
 * print input line if we are listing.
 */
if (!lflg || printed || savebuff[0]==0)
	return;
++printed;
if(eject)
	putchar(014);
eject = 0;
if (isn == lastisn)
	printf("\t");
else
	printf("%5d\t",lastisn = isn);
printf("  %s",savebuff);
printf("\n");
}

include(buff) char *buff;
{
/*
 * accept line of the form: #include "filename"
 * and cause that file to be read as input until an
 * eof. use seek to "unread" any pending input characters.
 */
register char *p;
register char *q;
extern fin[];

p = "#include \"";
q = buff;
while (*p)
	if(*p++ != *q++)
		ERROR("bad include syntax",E_INCLUDE);
p = q;		/* remember where we are in buffer */
while (*p && *p != '"')
	++p;
*p = 0;
savedes = fin[0];
savelnr = line;
xseek(fin[0],-fin[1],1);		/* unread the main file */
if (fopen(q,fin) < 0)
	ERROR1("can't include %s",E_NOINCL,q);
}
