#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "stmt.h"
#include "char.h"

/*			Copyright 1977 by Bill Webb.	 		*/

/*
 * those statments and routtnes that require the "stmt" header are here
 * as "exec.c" cannot include the "stmt" header as it pushes the number of
 * defines over the limit.
 */
int thenstmt {THEN_STMT};	/* kludge around define problem */

ifstmt()
{
register char *s;

expect("(");
s = exprtree();
expect(")");
if (*inptr == 0)
	{
	WARNING("'then' missing in 'if'",E_NOTHEN);
	append(inptr,"then");
	}
if (chartype(*inptr) == DIGIT)
	aif(s);
else
	{
	lif(s);
	stmt = LIF_STMT;	/* remember the type */
	}
}

ifcheck()
{
if (stmt <= END_STMT || stmt==LIF_STMT || stmt==DO_STMT)
	ERR("not allowed in if statement",E_IF);
}

enddochk()
{
/*
 * insure legal statment to end a do.
 */
switch(stmt)
	{
default:
	if(stmt > END_STMT)
		break;
case DO_STMT:
case BIF_STMT:
case ENDIF_STMT:
case ELSEIF_STMT:
case GOTO_STMT:
case IF_STMT:
	NOTE("illegal 'do' termination statement",E_DOEND);
	}
}

deadend()
{
/*
 * indicate if we have a "dead end".
 * e.g. a statement that cannot be reached by any means.
 */
return(!label[0] && (laststmt == GOTO_STMT || laststmt == RETURN_STMT ||
	laststmt == STOP_STMT));
}
