#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "tree.h"
#include "ops.h"
#include "sym.h"

int treecnt;		/* number of bytes in buffer (even) */
#define	TREEMAX	512
char treebuff[TREEMAX];
char *treeptr;

#define	TEXT_INCR	1024	/* text space increment */
#define	BADNODE(x)	(x && (x < textbeg || x > symlast))

char *node(op,left,right)
{
/*
 * allocate a node on the tree with appropriate fields.
 */
register char *t, *s;

#ifdef	debug
if (BADNODE(left) || BADNODE(right))
	ERROR2("bad node %o %o",E_NODE,left,right);
#endif
t = textlast;
s = t + NODESIZE;
if (s >= textend)
	textexpand();
textlast = s;
t->t_op = op;
t->t_type = NOTYPE;
t->t_left = left;
t->t_right = right;
return(t);
}

mnode(op,type,left,right)
{
register char *t;
register char *s;

#ifdef	debug
if (BADNODE(left) || BADNODE(right))
	ERROR2("bad node %o %o",E_NODE,left,right);
#endif
t = textlast;
s = t + NODESIZE;
if (s >= textend)
	textexpand();
textlast = s;
t->t_op = op;
t->t_type = type;
t->t_left = left;
t->t_right = right;
return(t);
}

treeprint(tree) struct node *tree;
{
/*
 * print the expression tree "tree".
 */
register struct node *t;
register int op;
static tlevel;

t = tree;
if (t == NULL)
	return;
if (INSYM(t))
	{
	prsym(t);
	return;
	}
++tlevel;
switch(op = t->t_op)
	{
case SYM_OP:
	prsym(t->t_sym);
	printf("@");
	printf("%d",t->t_offset);
	break;
case COMMA_OP:
	printf(" , ");
	treeprint(t->t_left);
	if(t->t_right != NULL)
		treeprint(t->t_right);
	break;
default:
	if (op < opmax)
		printf("(%s ",opnames[op]);
	else
		printf("(op %d ",op);
	treeprint(t->t_left);
	printf(" ");
	treeprint(t->t_right);
	printf(")");
	}
if (--tlevel == 0)
	printf("\n");
}

textexpand()
{
ERR("statement too complex",E_TOOCMPLX);
}

getconst(flag)
{
/*
 * get a constant (possibly a constant expression).
 * flag indicates if a full expression is allowed, or
 * just an item.
 * textlast is manipulated so that no tree space is allocated.
 */
register char *t;
register char *s;
register int c;

s = textlast;
if (flag)
	t = expr(RIGHT);
else
	t = item(RIGHT);
textlast = s;
if (!INSYM(t))
	if (t->t_op == STR_OP)
		t = t->t_left;		/* pick up the string itself */
if (!INSYM(t))
	ERR("expression not allowed",E_NOEXPR);
s = t;
if (! (s->s_class == CONST || (flag &&  s->s_loc == PARAM)))
	ERR("constant required",E_CONST);
move((s->s_len&0377),s,&symbol);
return(cur_sym = s);
}

writetree()
{
/*
 * output the current tree to temporary file.
 * store tree root and length at the start of
 * the tree.
 */
register int l;
register int *p;
register int k;
struct { char *charp; };

l = textlast-textbeg;
treesize = treesize + l;
p = textbeg-WRITEHDR;
p[0] = l;
p[1] = treep;
p[2] = slflg ? srcline : isn;
l =+ WRITEHDR;
if (l >= TREEMAX)
	{
	treeflush();		/* flush out the tree */
	if(write(tmpdes,p,l) < 0)
		ERROR("tmp file write error",E_TEMP);
	}
else
	{
	if (treecnt+l >= TREEMAX)
		{
		k = TREEMAX-treecnt;	/* amount of space left */
		fastmove(k,p,treebuff+treecnt);
		treecnt = TREEMAX;
		treeflush();
		p.charp =+ k;
		l =- k;
		fastmove(l,p,treebuff);
		treecnt = l;
		}
	else
		{
		fastmove(l,p,treebuff+treecnt);
		treecnt =+ l;
		}
	}
}

treeflush()
{
if(treecnt > 0)
	{
	if(write(tmpdes,treebuff,treecnt) < 0)
		ERROR("tmp file write error",E_TEMP);
	}
treecnt = 0;
treeptr = treebuff;
}

readtree(buff,n) char *buff;
{
/*
 * read into "buff" "n" bytes from temporary file.
 */
register char *p;

p = buff;		/* point to the buffer */
while (n > treecnt)
	{
	fastmove(treecnt,treeptr,p);
	p =+ treecnt;
	n =- treecnt;
	treecnt = read(tmpdes,treebuff,TREEMAX);
	if(treecnt <= 0)
		ERROR("reading past end tmp",E_ENDTMP);
	treeptr = treebuff;
	}
fastmove(n,treeptr,p);
treeptr =+ n;
treecnt =- n;
}

fastmove(length,from,to) int *from, *to;
{
register int l;
register int *f, *t;
if (l = length)
	{
	l =>> 1;
	f = from; t = to;
	do
		*t++ = *f++;
	while (--l);
	}
}
