#
/*			Copyright 1977 by Bill Webb.	 		*/

#define linker	"/bin/ld"
#define	fc	"/usr/fort/fc"

#define MAXV	256		/* maximum # of parameters */
#define	MAXC	512	/* maximum number of chars in parameters */

int fcc, linkc;
int cntfc;		/* number of source files for fc */
int oflg;		/* 1 if in update mode */
int debug;
char *fcv[MAXV];
char *linkv[MAXV];
char buffer[MAXC];
char *buffp;
char *pgname;
char status[2];
int nolink;

main(argc,argv)
char *argv[];
{
register char *argp;
register char *p;
int j;
char *objp;
char c;
int id;
int i;
int s;		/* status */

pgname = *argv++;
debug = equal(pgname,"test");
buffp = buffer;
--argc;

if(argc <= 0)
	exit(0);		/* nothing to do */

linkv[++linkc] = "/lib/frt77.o";		/* header file */
for (i=0; i<argc; ++i)
	{
	argp = argv[i];
	p = argp;
	while (*p)
		++p;		/* scan to end of name */
	if (equal(p-2,".c"))
		err("try cc %s",argp);
	if(equal(p-2,".f") || equal(p-4,".ftn"))
		{
		objp = objname(argp);
		if (!oflg || !obj_new(argp,objp))
			{
			++cntfc;
			fcv[++fcc] = argp;
			}
		linkv[++linkc] = objp;
		continue;
		}
	if(*argp == '-')
		{
		switch(c = argp[1])
			{
		case '-':		/* upper case sw flag */
			fcv[++fcc] = ++argp;
			switch(argp[1])
				{
			case 'n':
				++nolink;	/* implies -c */
				}
			continue;
		case 'o':
			++oflg;		/* only those needing it */
			continue;
		case 'p':		/* pre-processor */
			linkv[1] = "/lib/mfrt77.o";	/* header */
			fcv[++fcc] = argp;
			continue;
		case 'c':
			++nolink;
			continue;

		case 'l':		/* lower case l */
			if (!(argp[2] >= '0' && argp[2] <= '9'))
				{
				linkv[++linkc] = argp;
				continue;
				}
		case 'L':
			if(argp[2] == 0)
				argp = "-L1";
			fcv[++fcc] = argp;
			continue;

		case 'h':
		case 'H':
			execl("/bin/help","help","fc",0);
			execl("/usr/bin/help","help","fc",0);
			err("sorry, no help available.");

		case 'N':
			++nolink;
		default:
			if(c >= 'A' && c <= 'Z')
				{
				fcv[++fcc] = argp;
				}
			else
				linkv[++linkc] = argp;
			}
		continue;
		}
	if(equal(p-2,".o"))
		for (j=1; j<=linkc; ++j)
			if(equal(argp,linkv[j]))
				goto loop;
	linkv[++linkc] = argp;		/* by default */
	if(nolink)
		err("-c and %s??",argp);
loop:	;
	}

if (fcc > 0 && cntfc == 0)
	warn("nothing to compile");
if(fcc > 0 && cntfc)
	{
	fcv[0] = "fc";
	for (i=0; i<fcc; ++i)
		{
		if(*(p = fcv[i]) == '-')
			while (*p)
				if(*p >= 'A' && *p <= 'Z')
					*p++ = *p - 'A' + 'a';
				else
					++p;
		}
	if((id = fork())==0)
		{		/* child */
		exec(fc,fcv);
		err("no %s",fc);
		}
	if(id == -1)
		err("try again.");
	wait(&status);
	if(status[0]!=0)
		{
		s = status[0] & 0177;	/* mask off dump bit */
		if(s <= 3 || s == 9)
			exit(1);
		else
			err("fatal error in %s",fc);
		}
	if(status[1]!=0)
		exit(1);
	}
else
	if(nolink)
		err("nothing to do!");
if(linkc == 0 || nolink)
	exit(0);

linkv[0] = "ld";
linkv[++linkc] = "/lib/libf77.a";
linkv[++linkc] = "-lc";
linkv[++linkc] = "-l";
exec(linker,linkv);
err("no %s",linker);
}

equal(s1,s2)
char *s1, *s2;
{
while (*s1)
	if(*s1++ != *s2++)
		return(0);
return(*s2 == 0);
}


warn(s,d1,d2)
{
extern errno;

printf("%s: ",pgname);
printf(s,d1,d2);
if(errno > 0)
	perror("");
putchar('\n');
}

err(s,d1,d2)
{
warn(s,d1,d2);
exit(1);
}


putchar(c)
{
write(2,&c,1);
}

objname(name) char *name;
{
register char *p;
register char *n;

p = buffp;
for (n=name; *n; )
	{
	*p = *n++;
	if (*p++ == '/')
		p = buffp;
	}
if (p[-2] == '.')
	p =- 1;
else
	p =- 3;
*p++ = 'o';
*p++ = 0;
n = buffp;
buffp = p;
return(n);
}

exec(prog,pars) char *prog; char **pars;
{
register char **p;

if (debug)
	{
	printf("%s",prog);
	for (p = pars; *p; ++p)
		printf(" %s",*p);
	printf("\n");
	}
execv(prog,pars);
}

#

#define horder 0
#define lorder 1


struct stat
{
char minor, major;
int inumber;
int flags;
char nlinks;
char uid;
char gid;
char size0;
int size1;
int addr[8];
int actime[2];
char *modtime[2];
} file_stat, obj_stat;

obj_new(name,obj)
char *name;
char *obj;
{
register char *p;


if(stat(obj,&obj_stat) < 0)
	return(0);

if(stat(name,&file_stat) < 0)
	return(0);

#ifdef	debug
pstat(name,&file_stat);
pstat(obj,&obj_stat);
#endif

if(file_stat.modtime[horder] < obj_stat.modtime[horder])
	return(1);
if(file_stat.modtime[horder] > obj_stat.modtime[horder])
	return(0);
if(file_stat.modtime[lorder] < obj_stat.modtime[lorder])
	return(1);
return(0);
}

#ifdef	debug
pstat(name,stat)
struct stat *stat;
{
printf("file %s ==> %o %o\n",name,stat->modtime[0],
	stat->modtime[1]);
}
#endif
