#
#include "/usr/include/stdio.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "fdb.h"

int attn();
double getv();
char **atcmd;
int needexpr;		/* if cmd needs an expression */
#define	SIGATTN	2
int status;
#define	YES	1
#define	NO	0
int objaddr;
int cmd;		/* last cmd */
int gotvalue;
int type;
int trace;
char *file "a.out";
int statb[18];			/* buffer for stat */
int sysfudge;			/* fudge factor for pwb/unix core files */

main(argc,argv) char **argv;
{
register char *argp;
register int i;
static cnt;
char *corefile;

corefile = "core";
if (stat("/etc/pwb",&statb) >= 0)
	sysfudge = 768;			/* fudge it for pwb */
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 'p':
			++pflg;
			break;
		case 'd':
			++dflg;
			break;
		case 't':
			++trace;
			break;
		case 'U':
			sysfudge = 512;
			break;
		case 'P':
			sysfudge = 768;
			break;
		case 'x':
			++xflg;
			break;
			}
		}
	else
		{
		switch(++cnt)
			{
		case 1:
			file = argp;
			break;
		case 2:
			corefile = argp;
			break;
			}
		}
	}
setout();
init(corefile);
++inited;

for (;;)
	{
	setexit();
	signal(2,&attn);
	cmds();
	}
}

looksubr(sname,how) char *sname;
{
register char *s;

for (SCANSUBR(s))
	{
	if (equal(s->f_name,sname))
		return(s);
	}
if (how == CREATE)
	{
	s = zalloc(SUBRSIZE);
	copy(s->f_name,sname);
	s->f_next = subrs;
	subrs = s;
	return(s);
	}
return(0);
}


findsubr(addr)
{
register char *s;
register char *p;
register int diff;

p = 0; diff = 32767;
for (SCANSUBR(s))
	{
	if (addr >= s->f_text && addr-s->f_text < diff)
		{
		diff = addr-s->f_text;
		p = s;
		}
	}
return(p);
}

zalloc(n)
{
register char *p;

p = alloc(n);
clear(p,n);
return(p);
}

cvtint(ptr) char *ptr;
{
register int n,c;

n = 0;
while (c = *ptr++)
	{
	c =- '0';
	if (c < 0 || c >= 10)
		return(0);
	n = n * 10 + c;
	}
return(n);
}

cmds()
{
register int l,n,w;

for (;;)
	{
	flush();
	write(2,"+",1);
	if ((l = readline(line,stdin)) < 0)
		break;
	line[l]=0;
	onecmd(line);
	}

exit(0);
}

onecmd(buff) char *buff;
{
register int l,n,w;
atcmd = 0;
inptr = buff;
if (*inptr)
	{
	cmd = *inptr++;
	if (cmd >= 'a' && cmd <= 'z')
		while (*inptr >= 'a' && *inptr <= 'z')
			++inptr;
	}
do
	{
	gotvalue = 0;
	type = 0;
	loc = 0;
	switch(cmd)
		{
	case 'r':
	case '!':
		needexpr = NO;
		break;
	default:
		needexpr = YES;
		}
	if (needexpr && *inptr)
		{
		if (*inptr && *inptr != ',')
			{
			++gotvalue;
			switch(cmd)
				{
			case 'b':
			case 'x':
			case 'a':
			case 'l':
				expr(&arg,LHS);		/* get numeric value */
				if (arg.a_type != STMT)
					err("ISN required");
				objaddr = arg.a_value;
				break;
			default:
				expr(&arg,AHS);
				objaddr = arg.a_value;
				type = arg.a_mode;
				if (arg.a_type == VARIABLE)
					loc = arg.a_ptr->v_loc;
				}
			}
		}
	if (*inptr == ';')
		{
		++inptr;
		n = number(10);
		}
	else
		n = 1;
	do
		docmd(cmd,objaddr);
	while (--n > 0);
	if (*inptr)
		expect(",");
	}
while (needexpr && *inptr);
}

err(fmt,d1,d2,d3)
{
printf(fmt,d1,d2,d3);
printf("\n");
flush();
if (inited)
	reset();
exit(1);
}

warn(fmt,d1,d2,d3)
{
printf(fmt,d1,d2,d3);
printf("\n");
}

getaddr()
{
return(expr());
}

docmd(icmd,n)
{
register char *w;

switch(icmd)
	{
case '?':
	decode(n);
	break;
case 'p':
	switch(arg.a_type)
		{
	case STMT:
		uncomp(n);
		break;
	case VARIABLE:
		loc = arg.a_ptr->v_loc;
		printvar(n);
		arg.a_value =+ typelen(arg.a_mode);
		break;
	case EXPR:
		printm(arg.a_value,arg.a_mode);
		printf("\n");
		break;
		}
	break;
case '/':
	w = fetch(n);
	objaddr =+ 2;
	printf("%d (%o)\n",w,w);
	break;
case '!':
	if (runing)
		err("?");
	unixcmd();
	break;
case 'e':
case 'q':
	exit(0);
	break;
case 'r':
	run();
	where();
	break;
case 'c':
	chkrun();
	if (steping)
		remstep();
	go();
	where();
	break;
case 's':
	chkrun();
	if (!steping)
		setstep();
	if (!gotvalue)
		n = 1;
	stepcnt = n;
	do
		go();
	while (--stepcnt > 0);
	where();
	break;
case '=':
	printf(" %d (%o)\n",n,n);
	break;
case 'b':		/* set break point */
	setbpt(n,0);
	break;
case 'a':
	if (atcmd == 0)
		atcmd = atlist();
	setbpt(n,atcmd);
	break;
case 'x':
	rembpt(n);
	break;
case 'l':
	listbpts(n);
	break;
case '$':
	tracebk();
	break;
case 'd':
	dumpvars();
	break;
case 'm':
	modify(n);
	break;
default:
	err("invalid command");
	}
}

printv(argp,mode) char *argp;
{
/*
 * print out the value of the item pointed to by "argp".
 * of type "mode".
 */
double d;
d = getv(argp,mode);
printm(d,mode);
}

double getv(argp,mode) char *argp;
{
struct { int INTP; };
struct { float FLOATP; };
struct { double DOUBLEP; };
struct { long LONGP; };
double d;

switch(mode)
	{
case INT:
case LOGICAL:
	d = argp->INTP;
	break;
case LONG:
	d = argp->LONGP;
	break;
case FLOAT:
	d = argp->FLOATP;
	break;
case DOUBLE:
	d = argp->DOUBLEP;
	break;
case LOGICAL1:
	d = *argp;
	break;
	}
}


printm(d,mode) double d;
{
switch(mode)
	{
case INT:
case LONG:
	printf("%.0f ",d);
	break;
case FLOAT:
case DOUBLE:
	printf("%.5f",d);
	break;
case LOGICAL1:
case LOGICAL:
	printf(d != 0 ? ".true. " : ".false. ");
	break;
default:
	err("invalid mode %c (%o)",mode,mode);
	}
}

readline(buff,buf) char *buff; int *buf;
{
register char *p;
register int c;

for (p = buff; (c = getc(buf)) > 0; )
	{
	if (c == '\n')
		{
		*p = 0;
		return(p-buff);
		}
	*p++ = c;
	}
return(-1);
}

findvar(addr)
{
register char *s, *v;

for (SCANSUBR(s))
	for (SCANVAR(s,v))
		if (v->v_addr == addr)
			return(v);
return(0);
}

attn()
{
err("?");
}

printvar(n)
{
if (type == 0)
	type = 'i';
if (loc == 'p')
	{
	printf("=");
	n = fetch(n);
	}
prvalue(n,type,0);
printf("\n");
}

dumpvars()
{
register char *s;
register char *v;
register int i;

for (SCANSUBR(s))
	for (SCANVAR(s,v))
		{
		printf("%s:%.6s %6o %c %d %c ",s->f_name,
			v->v_name,v->v_addr,v->v_mode,v->v_nsubs,v->v_loc);
		for (i=0; i<v->v_nsubs; ++i)
			printf(" %d:%d",v->v_subs[i].lwb,v->v_subs[i].upb);
		printf("\n");
		}
}

chkrun()
{
if (!runing)
	err("not running");
}

modify(n)
{
register int *p;
double d;
float f;
register int v;
int m;

m = arg.a_mode;
expect("=");
expr(&arg,RHS);
d = getrhs(&arg);
switch(m)
	{
case INT:
	v = d;
	store(n,v);
	break;
case FLOAT:
	f = d;
	p = &f;
	store(n,*p++);
	store(n+2,*p++);
	break;
case DOUBLE:
	p = &d;
	store(n,*p++);
	store(n+2,*p++);
	store(n+4,*p++);
	store(n+6,*p++);
	break;
	}
}

unixcmd()
{
if (fork() == 0)
	{
	closeall();
	execl("/bin/sh","sh","-c",line+1,0);
	warn("no /bin/sh");
	exit(1);
	}
signal(SIGATTN,1);
while (wait(&status) != -1)
	;
signal(SIGATTN,&attn);
inptr = endstr(inptr);
}

atlist()
{
char atbuff[80];
register int l;
register int *p, *lastp;

while ((l = readline(atbuff,stdin)) > 0)
	{
	p = zalloc(l+1+2);
	copy(p+1,atbuff);
	if (lastp)
		*lastp = p;
	else
		atcmd = p;
	lastp = p;
	}
return(atcmd);
}
