#
/*			Copyright 1979 by Bill Webb.	 		*/

#define	SYMSIZE		12
#define	UNDEFINED	0
#define	GLOBAL		040
#define	ABS		01
#define	TEXT		02
#define	DATA		03
#define	BSS		04
#define	GABS		041
#define	GTEXT		042
#define	GDATA		043
#define	GBSS		044

int hdr[8];		/* a.out file header */
#define	progtype	hdr[0]
#define	textsize	hdr[1]
#define	datasize	hdr[2]
#define	bsssize		hdr[3]
int symdes;		/* file des for it */
char *symtab;		/* symbol table ptr */
char *symend;		/* symbol table end ptr */

struct symbol
{
char s_name[8];		/* name of symbol */
int s_type;		/* type of symbol */
char *s_addr;		/* its address/value */
};


struct subr
{
char *f_next;		/* next one on chain */
char f_name[8];
char *f_text;
char *f_data;
char *f_bss;
int e_text;
int e_data;
int e_bss;
int f_maxisn;
char **f_isns;
char *f_vars;		/* variables in this routine */
} *subrs;

struct arg {
char a_type;		/* SYMBOL, CONST */
char a_mode;		/* INT, REAL etc. */
char *a_ptr;		/* pointer to symbol table entry */
double a_value;		/* its value */
char *a_subr;		/* subroutine its in */
} arg;
#define ARGSIZE (sizeof arg1)

struct node {
char t_op;
char t_mode;
char *t_left;
char *t_right;
} *treep;
#define	NODESIZE	(sizeof *treep)

struct var
{
char *v_next;		/* link to next one */
char v_mode;		/* its mode */
char v_loc;		/* its location (memory, parameter etc.) */
char v_nsubs;		/* number of subscripts */
char *v_name;		/* its name */
char *v_addr;		/* its address */
int v_size;		/* size (of string) */
} *vptr;
#define	VARSIZE	(sizeof *vptr)

struct subsc
{
int lwb, upb;
};

#define	MAXSUBS	7
struct sbvar
{
struct var v_var;
struct subsc v_subs[MAXSUBS];
};

struct stmtno
{
char *n_next;
char *n_name;
char *n_addr;
};

#define	CONSTANT	0
#define	EXPR	CONSTANT
#define	VARIABLE	1
#define	SUBROUTINE	2
#define	STMT		3	/* statment */

char name[8];
#define	OK	1
#define	YES	1
#define	NO	0
#define	LOOKUP	0
#define	CREATE	1
#define	SUBRSIZE	(sizeof *subrs)
#define	SCANSYM(s)	 s=symtab; s<symend; s=+ SYMSIZE
#define	SCANSUBR(s)	s=subrs; s; s=s->f_next
#define	SCANVAR(s,v)	v=s->f_vars; v; v=v->v_next

char *file;
int pflg;
int xflg;		/* misc flag for debugging */
char line[256];
char *inptr;
int inited;

double getrhs();	/* get a value */
double getv();
#define	RHS	0
#define	LHS	1
#define	AHS	2	/* any */
struct subr *cursubr;	/* current subroutine */
#define	NULL	0
int isn, lisn;
int isnoff;		/* offset to NOP in isn and lisn */
int bisn, blisn;
#define	MAXTREE	1024
char treespace[MAXTREE];
char *treefree;		/* next free element ptr */

char *subrptr;		/* ptr to subroutine */
int isnvalue;		/* value of isn located */
int runing;		/* if runing the program */
#define	ISN	1
#define	BISN	2
#define	LISN	3
#define	BLISN	4
int seq;		/* address of seq_ */
int curisn;		/* current isn */
int curprog;		/* current program */
int steping;		/* if in single step mode */
int stepcnt;		/* number of statements to step */
#define	NOP	0240
#define	BPT	03
struct { char lo, hi; };
int type;
int errstop;		/* error intercept */
int debug;		/* stop intercept */
int errnum;		/* the error code address */
int loc;		/* location of variable */
int dflg;
int coredes;

/* type codes used by the runtime */
#define	INT	'i'
#define	FLOAT	'f'
#define	DOUBLE	'd'
#define	INT4	'q'
#define	LONG	INT4
#define	LOGICAL1 'b'
#define	LOGICAL	'l'
#define	STRING	's'
