#include "fdb.h"
#include "ops.h"
#include "tree.h"

ptree(tp) char *tp;
{

if (!ptree1(tp))
	ptree2(tp);
}

ptree2(tp) char *tp;
{
register char *t;
register char *s;

t = tp;
if (t == 0)
	return(OK);
switch(t->t_op)
	{
case STR_OP:
	pstr(t);
	return(OK);
case COMMA_OP:
	ptree(t->t_left);
	if (t->t_right)
		{
		printf(",");
		ptree(t->t_right);
		}
	return(OK);
case LEAF_OP:
	prarg(t->t_left,t->t_mode,t->t_right);
	return(OK);
	}
if (t->t_right)
	{
	printf("(");
	ptree(t->t_left);
	prop(t->t_op);
	ptree(t->t_right);
	printf(")");
	}
else
	{
	printf("(");
	prop(t->t_op);
	ptree(t->t_left);
	printf(")");
	}
return(NO);
}

ptree1(tp) char *tp;
{
register char *t;
register char *s;

t = tp;
if (t == 0)
	return(OK);
if (xflg)
	return(NO);
switch(t->t_op)
	{
case SBV_OP:
	prsubsc(t->t_left);
	return(OK);

case SRET_OP:
	printf("return");
	return(OK);
case TR_OP:
	return(ptree(t->t_left));	/* I/O Transfer op */
	return(OK);
case CALL_OP:
	prop(t->t_op);
	ptree(t->t_left);
	printf("(");
	ptree(t->t_right);
	printf(")");
	return(OK);
case FORMAT_OP:
	printf("format");
	prfmt(t->t_left,t->t_right);
	return(OK);
case MOV_OP:
	ptree(t->t_left);
	prop(t->t_op);
	ptree(t->t_right);
	return(OK);
case RIF_OP:
case IF_OP:
	printf("if (");
	if (t->t_op == IF_OP)
		printf(".not.");
	ptree(t->t_left);
	printf(")");
	ptree(t->t_right);
	return(OK);
case TLE_OP:
case TGE_OP:
case TEQ_OP:
case TNE_OP:
case TLT_OP:
case TGT_OP:
	ptree(t->t_left);
	prop(t->t_op);
	printf("0");
	return(OK);
case CVT_OP:
	switch(t->t_mode)
		{
	case 'f':
		s = "float";
		break;
	case 'd':
		s = "double";
		break;
	case 'i':
	case 'q':
		s = "int";
		break;
	default:
		s = 0;
		}
	if (s)
		{
		printf("%s(",s);
		ptree(t->t_left);
		printf(")");
		return(OK);
		}
	}
return(NO);
}

prsubsc(tp) char *tp;
{
register char *s;
register char *t;
struct arg targ;
register int n;

t = tp;
s = t->t_right;
if (s->t_op != LEAF_OP)
	err("expecting LEAF");
if (!locate(s->t_left,&targ,s->t_mode))
	{
	ptree(s);
	printf("(");
	ptree(t->t_left);
	printf(")");
	}
else
	{
	if (targ.a_subr != cursubr)
		printf("%s:",targ.a_subr->f_name);
	printf("%s",targ.a_ptr->v_name);
	n = targ.a_value;
	++n;
	printf("(");
	if (n)
		printf("%d+",n);
	ptree(t->t_left);
	printf(")");
	}
}

prop(op)
{
register char *s;

s = nops[op];
if (s == 0)
	s = ops[op];
printf(" %s ",s);
}

prfmt(addr,n)
{
register int i;
int w;

for (i=0; i<n; i =+ 2)
	{
	w = fetch(addr);
	addr =+ 2;
	printf("%c%c",w.lo,w.hi);
	}
}

prdo()
{
register char *p, *s, *t;

p = pop();
t = pop();
s = pop();
printf("\tdo ");
ptree(p->t_right);
ptree(t);
printf(" count=");
ptree(s->t_right);
printf("\n");
}


prarg(argp,mode,len)
{
register char *s;
register int c;
struct arg targ;

if (locate(argp,&targ,mode))
	return(prtarg(&targ));
s = objlook(argp);
if (s)
	{
	c = s->s_name[1];
	if (c >= '0' && c <= '9')
		printf("#");
	printf("%.7s ",s->s_name+1);
	}
else
	{
	if (argp < hdr[1])
		prvalue(argp,mode,len);
	else
		printf("*%o* ",argp);
	}
}

prvalue(argp,mode,len)
{
double d;
float f;
int w;

switch(mode)
	{
default:
	printf("mode = %c",mode);
case 0:
	printf("*%o* ",argp);
	break;
case LOGICAL:
case 'i':
	w = fetch(argp);
	printv(&w,mode);
	break;
case 'f':
	nfetch(argp,&f,2);
	printv(&f,mode);
	break;
case 'd':
	nfetch(argp,&d,4);
	printv(&d,mode);
	break;
case 's':
	printf("'");
	while (len > 0)
		{
		w = fetch(argp);
		argp =+ 2;
		len =- 2;
		putch(w.lo);
		if (len >= 0)
			putch(w.hi);
		}
	printf("'");
	}
}

locate(addr,argp,mode) struct arg *argp;
char *addr;
{
/*
 * scan thru the routines and fill in the argument "argp"
 * to reflect what we have found.
 */
register char *s, *v;
register int len;
int n;

if ((s = srchsubr(addr)) == 0)
	return(NO);
argp->a_subr = s;
if (addr < textsize)
	{
	if (mode)
		return(NO);		/* assume its a constant */
	if ((n = srchisn(s)) == 0)
		return(NO);
	argp->a_type = STMT;
	argp->a_value = n;
	argp->a_mode = 0;
	return(YES);
	}
if ((v = srchvar(s,addr,mode)) == 0)
	return(NO);
argp->a_type = VARIABLE;
argp->a_ptr = v;
if (v->v_mode == 's')
	len = v->v_size;
else
	len = typelen(v->v_mode);
argp->a_value = (addr-v->v_addr)/len;
argp->a_mode = v->v_mode;
return(OK);
}

srchsubr(addr) char *addr;
{
/*
 * locate a subroutine that "addr" fits into.
 */
register char *s;

for (SCANSUBR(s))
	{
	if (addr >= s->f_text && addr < s->e_text)
		return(s);
	if (addr >= s->f_data && addr < s->e_data)
		return(s);
	if (addr >= s->f_bss && addr < s->e_bss)
		return(s);
	}
return(NO);
}

srchvar(sp,addr,mode) char *sp, *addr;
{
/*
 * search thru subroutine "sp" for the variable "closest to"
 * the address "addr".
 */
register char *v;
register int n, diff;
char *vsave;

diff = 32767;
for (SCANVAR(sp,v))
	{
	if (addr == v->v_addr)
		return(v);
	if (mode == v->v_mode && v->v_nsubs)
		{
		n = addr-v->v_addr;
		if (n < 0)
			n = -n;
		if (n < diff)
			{
			vsave = v;
			diff = n;
			}
		}
	}
if (vsave)
	return(vsave);
return(NO);
}

prtarg(argp) struct arg *argp;
{
register int n;
register struct arg *a;

a = argp;
if (a->a_subr != cursubr)
	printf("%s:",a->a_subr->f_name);
switch(a->a_type)
	{
case VARIABLE:
	printf("%s",a->a_ptr->v_name);
	n = a->a_value;
	if (n)
		printf("(%d)",n+1);
	break;
case STMT:
	n = a->a_value;
	printf("%d",n);
	break;
default:
	printf("prtarg ?? %o",a);
	break;
	}
}

srchisn(sp,addr) char *sp;
{
register char *s;
register int i;

s = sp;
for (i=1; i<s->f_maxisn; ++i)
	if (addr == s->f_isns[i])
		return(i);
return(0);
}
