#
/*			Copyright 1979 by Bill Webb.	 		*/

int errcode;		/* error code */
int attn();
#define	SIGATTN	2
#include "fdb.h"

int pid, status;
extern errno;
int signo;
#define	SYSFUDGE	512	/* 512 for Unix; 768 for PWB */
int sysfudge SYSFUDGE;
int trace 0;
int argc;
#define	MAXARG	64
char *argv[MAXARG];
char program[64];

#define	flag	2
#define	flagaddr	2
#define	sigbpt	5
#define	sigsys	12

#define	ruser	1
#define	riuser	2
#define	wuser	4
#define	ruregs	3
#define	wuregs	6
#define	settrc	0
#define	contin	7
#define	pexit	8

char *pgm;
int statb[18];
struct reg
{
char *r_name;
char *r_off;
char *r_value;
};

struct reg pc
{ "pc", -2, 0 };

struct reg r4
{ "r4", -10, 0 };
struct reg r0
{ "r0", -3, 0 };

struct reg ps
{ "ps", -1, 0 };

char *signals[]
{
"",
"hangup",
"interrupt",
"quit",
"illegal instruction",
"trace/bpt",
"iot",
"emt",
"floating exception",
"killed",
"bus error",
"memory fault",
"bad system call",
"",
"",
""
};

run()
{
extern _exectrap;

steping = 0; stepcnt = 0;
if (coredes > 0)
	{
	close(coredes);
	coredes = 0;
	}
copy(program,file);
if(stat(program,statb) < 0)
	{
	copy(program,"/bin/");
	append(program,file);
	if(stat(program,statb) < 0)
		{
		copy(program,"/usr/bin/");
		append(program,file);
		if(stat(program,statb) < 0)
			err("%s: %s not found",pgm,file);
		}
	}
argv[0] = program;
argc = 1;
parlist();
argv[argc] = 0;
if( (pid=fork()) == 0)
	{
	closeall();
	_exectrap++;
	ptrace(settrc, 0, 0, 0);
	argv[argc] = 0;
	execv(program,argv);
	err("no %s",file);
	}

++runing;
if (bpwait() != sigbpt)
	badret();
ps.r_value =& ~ 020;		/* kill trace bit */
putbpts();			/* store break points */
go();
}



bpwait()
{
register int w;
if(pid == -1)
	err("try again");

signal(SIGATTN,1);
while ((w = wait(&status)) != pid && w != -1)
	;
signal(SIGATTN,&attn);

if(w == -1)
	err("wait error");

if( (status & 0377) != 0177)
	{
	if(signo = status & 0177)
		printf("%s\n",signals[signo]);
	runing=0;
	err("program terminated");
	}
signo = status >> 8;
getreg(&pc);
getreg(&ps);
if(trace)
	printf("%s at %o (%o)\n",signals[signo],
		pc.r_value,ps.r_value);
return(signo);
}

getreg(rp)
struct reg *rp;
{
register struct reg *p;

p = rp;
p->r_value = ptrace(ruregs, pid, 2 * (512+p->r_off), 0);
return(p->r_value);
}

putreg(rp)
struct reg *rp;
{
register struct reg *p;

p = rp;
ptrace(wuregs, pid, 2 * (512+p->r_off), p->r_value);
}


get(addr)
{
register int i;
i=ptrace(riuser, pid, addr, 0);
if(trace>1)
	printf("get(%o)=>%o\n",addr,i);
return(i);
}

put(addr,info)
{
if(trace)
	printf("put(%o,%o)\n",addr,info);
if(ptrace(wuser, pid, addr, info) == -1 && errno )
	err("can't put(%o,%o)",addr,info);
}


go()
{
register int n;

if(trace)
	printf("go to %o (%o)\n",pc.r_value,ps.r_value);
putreg(&ps);
putreg(&pc);
ptrace(contin, pid, 0, 0);
bpwait();
if(signo != sigbpt)
	badret();
n = pc.r_value-2;
if (n == bisn+isnoff || n == blisn+isnoff)
	gotbpt();
if (n == errstop)
	{
	printf("runtime error %d\n",errcode=fetch(errnum));
	ferr(errcode);
	where();
	reset();
	}
if (n == debug)
	{
	printf("exiting ");
	where();
	reset();
	}
}

badret()
{
printf("%s at %o ",signals[signo],pc.r_value);
where();
reset();
}

gotbpt()
{
register int n;

n = getreg(&r4)-2;
if (pc.r_value == blisn+isnoff+2)
	n =- 2;
if (atcheck(n))
	return;
printf("bpt:  ");
where();
reset();
}

where()
{
location(fetch(seq));
printf("\n");
}

location(pos)
{
register int w;
register int n;
register char *s;

w = pos;
curisn = n = fetch(w);
printf("isn %d",n);
curprog = fetch(w+2);
if ((n = fetch(w+4)) == 0)
	printf(" in main");
else
	{
	s = objlook(curprog =- 4);
	if (s)
		printf(" in %s",s->s_name+1);
	}
return(n);
}

setstep()
{
if (fetch(isn+isnoff) != NOP || fetch(lisn+isnoff) != NOP)
	err("can't step");
++steping;
store(isn+isnoff,BPT);
store(lisn+isnoff,BPT);
}

remstep()
{
if (fetch(isn+isnoff) != BPT || fetch(lisn+isnoff) != BPT)
	err("can't remstep");
store(isn+isnoff,NOP);
store(lisn+isnoff,NOP);
steping = 0;
}

tracebk()
{
register int w;
register int cnt;
register int n;

cnt = 25;
for (w=fetch(seq); w && --cnt > 0; )
	{
	n = location(w);
	plist(fetch(w+10));		/* print parameter list */
	printf("\n");
	w = n;
	}
}

plist(r5)
{
register int n;
register int i;
register char *p;

if (r5 == 0)
	return;
n = fetch(r5);
r5 =+ 2;
if (n < 0 || n > 12)
	return;
printf("(");
for (i=1; i<=n; ++i)
	{
	p = fetch(r5);
	prarg(p,0);
	r5 =+ 2;
	if (i != n)
		printf(",");
	}
printf(")");
}

parlist()
{
register char *p;
register int c;

for (p=inptr; c = *p++; )
	{
	if (c == ' ')
		continue;
	argv[argc++] = p-1;
	while ((c = *p++) && c != ' ')
		;
	if (c == 0)
		break;
	p[-1] = 0;
	}
inptr = p-1;
}
