#include "fields.h"

compile()
{
register int c;
register int l;
struct field *p;
int i;

while (((c = (*getch)()) == '-'  || c == '+') && getch == getfile)
	{
	inbuff[0] = c;
	fgets(inbuff+1,(sizeof inbuff)-1,prog);
	l = strlen(inbuff);
	inbuff[--l] = 0;
	if (c == '-')
		doswitch(inbuff);
	else
		getoffset(inbuff+1);
	}
ungetch(c);
out = outbuff;
while ((c = (*getch)()) > 0)
	{
	*out++ = c;
	if (c == '\\')
		{
		c = (*getch)();
		switch(c)
			{
		case 'n':
			c = '\n';
			break;
		case 't':
			c = '\t';
			break;
		case 'b':
			c = '\b';
			break;
		case '\\':
			c = '\\';
			break;
		default:
			if ('0' <= c && c <= '7')
				c = getint(010,0);
			break;
			}
		out[-1] = c;
		}
	else if (c == '\n')
		--out;
	else if (c == '%')
		{
		c = (*getch)();
		if (c != '%')
			getfmt(c);	/* get format item */
		}
	}
*out++ = '\n';
if (out > outbuff)		/* in case last field suppressed */
	{
	field.size = 0;
	field.type = NONE;
	storefield(YES);
	}
if (reclen > MAXLINE)
	err("record length > %d",MAXLINE);
reclen = field.addr;
if (tflg)
	printf("record length %d\n",reclen);
if (reclen == 0)
	err("no fields defined");
fixcnd(&ecnd);
fixcnd(&lcnd);
fixcnd(&icnd);
/* build initial table of field names */
fields = (struct field **) calloc(nfields,sizeof (struct field *) + 1);
for (p=first,i=0; p != (struct field *) NULL; p = p->next)
	{
	fields[i++] = p;
	p->out_next = p->next;
	}
out_build();		/* build output list */
}

getfmt(c) register int c;
{
register int flag;
register int i;
int f2;
int count;

	flag = 1;		/* assume not suppressed */
	if (c == '*')
		{
		flag = 0;
		--out;		/* remove the % */
		c = (*getch)();
		}
	if (c == '{')		/* pick up the repeat count */
		{
		count = getint(10,NO);
		c = (*getch)();
		if (c != '}')
			err("left brace expected; got %c",c);
		}
	else
		{
		count = 1;	/* assume count of 1 */
		ungetch(c);	/* and put character back */
		}
	getint(10,flag);
	c = (*getch)();
	if (c == '.')
		{
		if (flag)
			*out++ = c;
		f2 = getint(10,flag);
		c = (*getch)();
		}
	if (c == '@')
		{
		field.offset = getint(10,0);
		c = (*getch)();
		}
	else
		field.offset = 0;
	if (flag)
		*out++ = c;
	if (c == 'l')
		{
		c = (*getch)() & ~ 040;		/* convert to upper */
		out[-1] = c;
		}
	else if (c == 'c')
		{
		c = (*getch)();
		out[-1] = c;
		c &= 077;
		}
	field.sfmt[0] = '%';	/* build scanf format */
	field.sfmt[1] = c;
	field.sfmt[2] = 0;
	switch(c)
		{
	case 'u'&077:
	case 'd'&077:
	case 'o'&077:
	case 'x'&077:
		field.type = CHAR;
		field.size = sizeof (char);
		field.sfmt[1] |= 0140;		/* insure printable */
		break;
	case 'u':
	case 'd':
	case 'o':
	case 'x':
		field.type = INT;
		field.size = sizeof (int);
		break;
	case 'D':
	case 'O':
	case 'X':
		field.type = LONG;
		field.size = sizeof (long);
		break;
	case 'r':			/* rad 50 conversion */
		field.type = RAD50;
		field.size = sizeof (int);
		field.sfmt[1] = 'd';		/* insure scanf ok */
		if (flag)
			out[-1] = 's';
		break;
	case 'm':			/* unix (ls -l stype) mode conversion */
		field.type = MODE;
		field.size = sizeof (int);
		field.sfmt[1] = 'd';		/* insure scanf ok */
		if (flag)
			out[-1] = 's';
		break;
	case 't':			/* time conversion */
		field.type = TIME;
		field.size = sizeof (long);
		field.sfmt[1] = 'D';		/* insure scanf ok */
		if (flag)
			out[-1] = 's';
		break;
	case 's':
		field.type = STRING;
		field.size = abs(f2);
		break;
	case 'g':
	case 'f':
	case 'e':
		field.type = FLOAT;
		field.size = sizeof (float);
		break;
	case 'G':
	case 'E':
	case 'F':
		field.type = DOUBLE;
		field.size = sizeof (double);
		if (flag)
			out[-1] = c | 040;	/* insure lower case */
		break;
	default:
		err("invalid field.type %c",c);
		}
	field.expand = "";
	c = (*getch)();
	if (c == '[')
		{
		register char *p;
		for (p=ex_buff; (c = (*getch)()) != ']'; )
			{
			if (c == 0 || c == EOF)
				err("matching ] missing");
			*p++ = c;
			}
		*p = 0;
		field.expand = strsave(ex_buff);
		}
	else
		ungetch(c);
	for (i=0; i<count; ++i)
		{
		if (aflg || flag)
			storefield(i == 0);
		field.addr += field.size;
		++nfields;
		}
}

storefield(flag)
{
/* 
 * flag == YES indicates field must be saved;
 *	   NO  indicates field already saved.
 */
register struct field *fld;

*out++ = 0;
if (flag)
	field.outstr = strsave(outbuff);
out = outbuff;
fld = (struct field *) calloc(1,sizeof (struct field));
move(sizeof (struct field),&field,fld);
if (first)
	last->next = fld;
else
	first = fld;
last = fld;
if (tflg)
	printf("field %d type %s @ %d len %d '%s'\n",
		nfields,types[field.type],field.addr,field.size,field.outstr);
}

getint(base,echo)
{
register int c;
register int n;
register int sign = 0;

c = (*getch)();
if (c == '-')
	{
	if (echo)
		*out++ = c;
	sign++;
	}
else
	ungetch(c);
for (n=0; '0' <= (c = (*getch)()) && c <= '9'; )
	{
	if (echo)
		*out++ = c;
	c -= '0';
	if (c > base)
		err("invalid octal digit");
	n = n * base + c;
	}
ungetch(c);
if (sign)
	n = -n;
return(n);
}

