#include "fields.h"

update(file) FILE *file;
{
FILE *uopen();
register int l;
register int c;
register int i;
char *p;
int chgflg;
static helpflg;
long saveoffset;
long nr;

loop:

chgflg = 0;
NR = nr =  ((offset-fileoffset)/reclen)+origin;
printf("record %D offset %D", nr, offset);
if (fileoffset)
	printf(" relative %D",offset-fileoffset);
printf("\n");
printfields();
flush();

while (write(2,"@ ",2),fgets(inbuff,sizeof inbuff,stdin))
	{
	saveoffset = offset;
	l = strlen(inbuff);
	inbuff[--l] = 0;
	inptr = inbuff;
	c = *inptr;
	if ((c != '!' && c != '$') && (p = any(inptr,"=")))
		{
		chgflg |= scanfield(p);
		continue;
		}
	switch(c)
		{
	default:
		if (chgflg)
			{
		chg:
			printf("write?\n");
			if (helpflg++ == 0)
				printf("For help enter 'help'\n");
			chgflg = 0;
			continue;
			}
		if (isdigit(c))
			{
			pscanf(&inptr,"%D",&offset);
			offset -= origin;
			offset *= reclen;
			if (offset < 0)
				{
				printf("records start at %d\n",origin);
				continue;
				}
			offset += fileoffset;
		newrec:
			fseek(file,offset,0);
			if (fread(outbuff,reclen,1,file) == NULL)
				{
				printf("EOF\n");
				clear(outbuff,reclen);
				}
			goto loop;
			}
		printf("invalid command %s\n",inptr);
		continue;
	case '!':
		system(inbuff+1);
		break;
	case 0:
		if (chgflg)
			goto chg;
		return;			/* next input line */
	case 'w':
		chgflg = 0;
		if (outfile == NULL && (outfile = uopen(curfile)) == NULL)
			{
			warn("can't re-open %s for output",curfile);
			continue;
			}
		fseek(outfile,offset,0);
		fwrite(outbuff,1,reclen,outfile);
		fflush(outfile);
		if (ferror(outfile))
			warn("cannot write %s",curfile);
		return;
	case '$':
		++inptr;
		i = cvtint(&inptr);
		c = *inptr;
		if (c == '+' || c == '-')
			++inptr;
		if (*inptr == '=')
			{
			++inptr;
			chgfield(i,c);
			++chgflg;
			}
		else
			printf("= expected\n");
	/* fall thru and print new record */
	case 'p':
		printfield();
		continue;
	case 'h':
		system("help fields");
		break;
	case 'q':
		exit(0);
		break;
	case '-':
		doswitch(inptr);
		if (offset != saveoffset)
			goto newrec;
		break;
	case '+':
		getoffset(inptr+1);
		goto newrec;
		}
	}
exit(0);
}


chgfield(n,flg)
{
register struct field *p;
register int i;

for (i=1, p=first; p; p = p->next,++i)
	{
	if (i == n)
		{
		modfield(p,flg);
		return;
		}
	}
printf("field $%d not found\n",n);
}

struct field *findfield(ptr,n) char *ptr;
{
/*
 * given a name of length "n", locate the record that 
 * corresponds to it.
 */
register char *q, *p;

for (p=first; p; p = p->next)
	{
	q = p->outstr;
	while (*q == ' ' || *q == '\t' || *q == '\n')
		++q;		/* ignore blanks etc. */
	if (strncmp(inptr,q,n) == 0 && q[n] == '=')
		return(p);
	}
return(NULL);
}

scanfield(ptr) char *ptr;
{
/*
 * call with "ptr" pointing to an "="
 * and "inptr" pointing to a name before the "="
 */
register struct field *p;
char *s;
int n;
int flg;

s = ptr;
flg = ptr[-1];			/* either + or - or something else */
if (flg == '+' || flg == '-')
	--s;			/* end of pattern */
n = s-inptr;			/* length of pattern to check */
if (n <= 0)
	{
	printf("variable not found before =\n");
	return(0);
	}
if ((p = findfield(inptr,n)) != (struct field *) NULL)
	{
	inptr = ptr+1;	/* past the = sign */
	modfield(p,flg);
	printfield();
	return(1);	/* changed it */
	}
printf("field %.*s not found\n",n,inptr);
return(0);
}

#define ASSIGN(type,f) if (flg == '+') * (type *)q += f; else if (flg == '-') * (type *)q -= f; else * (type *)q = f;
#define	DELIM(c) ((c) == 0 || (c) == ',')

modfield(p,flg) register struct field *p;
{
/*
 * modify the field pointed to by "p" with the value
 * pointed to by "inptr".
 * allow more than one value, separated by commas.
 */
register char *q;
long l;
double f;
float s;
int ival;

for (; p; p = p->next)
	{
	if (*inptr == ',')
		{ ++inptr; continue; }		/* don't change null fields */
	if (p->addr >= 0)
		q = outbuff + p->addr;
	else
		q = (char *) &NR;
	switch(p->type)
		{
	case CHAR:
	case INT:
	case MODE:
	case RAD50:
		if (pscanf(&inptr,p->sfmt,&ival) != 1 || ! DELIM(*inptr))
			{
			printf("bad value for %s format '%s'\n",p->sfmt,inptr);
			return;
			}
		if (p->type == CHAR)
			{
			ASSIGN(char,ival);
			}
		else
			{
			ASSIGN(int,ival);
			}
		break;
	case TIME:
	case LONG:
		if (pscanf(&inptr,p->sfmt,&l) != 1 || ! DELIM(*inptr))
			{
			printf("bad value for %s format '%s'\n",p->sfmt,inptr);
			return;
			}
		ASSIGN(long,l);
		break;
	case DOUBLE:
		if (pscanf(&inptr,p->sfmt,&f) != 1 || ! DELIM(*inptr))
			{
			printf("bad value for %s format '%s'\n",p->sfmt,inptr);
			return;
			}
		ASSIGN(double,f);
		break;
	case FLOAT:
		if (pscanf(&inptr,p->sfmt,&s) != 1 || ! DELIM(*inptr))
			{
			printf("bad value for %s format '%s'\n",p->sfmt,inptr);
			return;
			}
		ASSIGN(float,s);
		break;
	case STRING:
		if (flg != '=')
			printf("%c= not supported for strings\n",flg);
		strxcpy(q,p->size);
		if (!DELIM(*inptr))
			printf("bad value for s format\n",inptr);
		if (xflg)
			untrim(q,p->size);
		break;
	case NONE:
		printf("cannot change null field\n");
		return;
	default:
		err("bad field type %d",p->type);
		}
	if (*inptr != ',')
		return;
	++inptr;		/* ignore the "," */
	}
}

btrim(string,length) register char *string; register int length;
{
register char *p;

for (p=string+length; p > string && *--p == ' ' ;)
	*p = 0;
}

untrim(string,length) register char *string; register int length;
{
register char *p;

for (p=string+length; p > string ;)
	if (*string++ == 0)
		string[-1] = ' ';
}

