#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
#include "fmthold.h"

struct hold *h_push();

hold_start(n,y,x)	/* hold "n" at line "y" posn "x" */
struct hold *n;
{
/*
 * start up a text hold by saving current buff_3 and related 
 * information. 
 * y is start line, x is start position.
 */
 
register struct hold *h;
register int l;
register char *p;
 
h = n;
if(cur_hold)
	{
	ccerr("attempt to nest %s inside %s",h->h_name,cur_hold->h_name);
	return;
	}
if(h->h_cnt)
	{
	switch(h->h_purge)
		{
	case NOPURGE:
		h_clear(h);		/* remove old definition */
		break;
	case PURGE:
		break;			/* add to this definition */
	case FIG_PURGE:
		h = h_push(h);		/* push previous figure */
		break;
		}
	}
cur_hold = h;
h->h_x = x; h->h_x = y;
l = ptr_3 - buff_3;
if ((p = alloc(l)) == NULL)
	nospace(h->h_name);
hs.hs_ptr3 = ptr_3;
hs.hs_ptr = p;
move(l,buff_3,p);
set(buff_3,MAXBUFF,NTB);
hs.hs_len = l;
 
hs.hs_v = sw_v;
sw_v = OFF;
hs.hs_ncap = sw_ncap;
sw_ncap = sw_cap;
ptr_1 = buff_1;
len = 0;
buff_1[0] = 0;
 
hs.hs_spacing = spacing;
spacing = 1;
hs.hs_np = sw_np; hs.hs_nl = sw_nl;
sw_np = sw_nl = ON;
set(buff_3,l,NTB);
hs.hs_ileft = i_left;
hs.hs_iright = i_right;
hs.hs_hleft = h_left;
hs.hs_hright = h_right;
i_left = i_right = h_left = h_right = 0;
 
ptr_calc();
SETPTRS;
if (x)
	ptr_3 += x-1;
}

 
 
end_hold()
{
 
/*
 * terminate the current hold definition. 
 */
 
register struct hold *h;
 
h = cur_hold;
 
move(hs.hs_len,hs.hs_ptr,buff_3);
free(hs.hs_ptr);
ptr_3 = hs.hs_ptr3;
spacing = hs.hs_spacing;
sw_nl = hs.hs_nl; sw_np = hs.hs_np;
sw_v = hs.hs_v;
sw_ncap = hs.hs_ncap && sw_cap;
i_left = hs.hs_ileft;
i_right = hs.hs_iright;
h_left = hs.hs_hleft;
h_right = hs.hs_hright;
cur_hold = 0;
ptr_calc();
line_calc();
if (h == &l_footer || h == &r_footer)
	h->h_x = line_max - h->h_cnt;	/* go to the effective end of page */
}


hold_out(h)
struct hold *h;
{
/*
 * dump out the contents of hold "h" to the output routine. 
 */

register struct text *p;
 
if(h->h_cnt == 0)
	return;
to_line(h->h_x);
p = h->h_start;
do
	{
	fmt_put(p->t_text,p->t_len);
	++cnt_line;
	}
while (p = p->t_next);
if(h->h_purge)
	{
	h_clear(h);
	if (h->h_purge == FIG_PURGE)
		h_pop(h);
	}
}
 
put_hold()
{
/* 
 * routine to output the contents of buff_3 into a text
 * hold. 
 */

register struct hold *h;
register struct text *s;
register int l;
 
l = ptr_3 - buff_3;
h = cur_hold;
if(h->h_cnt == h->h_max)
	{
	err("more than %d lines in %s",h->h_max,h->h_name);
	end_hold();
	return(FAIL);
	}
++h->h_cnt;
if ((s = (struct text *) alloc(l + TSIZE)) == (struct text *) NULL)
	nospace(h->h_name);
s->t_len = l;
s->t_next = 0;
move(l,buff_3,s->t_text);
if(h->h_last)
	(h->h_last)->t_next = s;
else
	h->h_start = s;
h->h_last = s;
return(OK);
}
 
h_clear(h)
struct hold *h;
{
/*
 * free any text chains in the given hold. 
 */
register struct text *p;
register struct text *t;
 
t = h->h_start;
while (t)
    {
    p = t->t_next;
    free(t);
    t = p;
    }
h->h_start = 0;
h->h_last = 0;
h->h_cnt = 0;
line_calc();
}
 

fig_test()
{
/*
 * routine to test if a figure can now be printed. 
 * requirements are that it must be h_x lines down
 * from the top of the page and must end h_y lines
 * up from the bottom. 
 */

if(figure.h_x <= cnt_line &&
	figure.h_y < eff_max - cnt_line - figure.h_cnt)
	hold_out(&figure);
}

hold_init()
{
/*
 * initialize the various text holds.
 */
register int i;

figure.h_name = "figure";
l_footer.h_name = "left footer";
r_footer.h_name = "right footer";
l_title.h_name = "left title";
r_title.h_name = "right title";
sub_title.h_name = "subtitle";
footnote.h_name = "footnote";
 
for (i=0; i<MAXHOLD; ++i)
	{
	holds[i]->h_max = 10;
	holds[i]->h_num = i;
	}
footnote.h_purge = PURGE;
figure.h_purge = FIG_PURGE;		/* purge after print */
footnote.h_max = 25;		/* largest footnote size */
figure.h_max = 50;		/* largest figure size */
}

struct hold *h_push(h) struct hold *h;
{
/*
 * get space for a new figure hold structure.
 * make a copy of the current structure into it.
 *
 */
register struct hold *f, *p, *q;

if ((f = (struct hold *) alloc(HOLDSIZE)) == (struct hold *) NULL)
	nospace(h->h_name);
move(HOLDSIZE,h,f);
f->h_link = f->h_start = f->h_last = (struct hold *) NULL; /* kill various pointers */
f->h_cnt = 0;
/*
 * scan down the chain til we hit the last figure
 */
for (p = h; q = p->h_link; p = q)
	;
p->h_link = f;
return(f);
}

h_pop(h) struct hold *h;
{
/*
 * if more holds on the chain pop them into place.
 */
register struct hold *f;

if (f = h->h_link)
	move(HOLDSIZE,f,h);
}
