/*
 * holdsave is used to save various FMT variables while a hold
 * is being defined. these values are restored at the end of
 * the old definition.
 */
struct holdsave
{
char *hs_ptr;		/* pointer to text */
int hs_len;		/* length of text */
char hs_v;		/* if in control card mode */
char hs_ncap;		/* save sw_ncap */
char hs_nl;		/* saved sw_nl */
char hs_np;		/* saved sw_np */
char *hs_ptr3;		/* current ptr_3 */
int hs_ileft;		/* saved left, right indent */
int hs_iright;
int hs_hleft;		/* saved left, right hanging indent */
int hs_hright;
int hs_spacing;		/* previous spacing value */
} hs;
 
/* 
 * a text hold allows one to suspend output to the main stream in order
 * to stash away a title, footnote, etc into memory.
 */

struct hold 
{
int h_x;		/* start line */
int h_y;		/* print position (or last line) */
struct text *h_start;	/* start of text string */
struct text *h_last;	/* end of text string */
int h_cnt;		/* current number of lines in hold */
int h_max;		/* maximum number of lines allowed */
char h_purge;		/* purge text after printing */
char *h_name;		/* name of current hold */
int h_num;		/* hold number */
struct hold *h_link;	/* link to next in (figure) chain */
} *cur_hold;

#define MAXHOLD 7

struct hold figure, l_footer, r_footer, l_title, r_title, 
    sub_title, footnote; 
 
struct hold *holds[MAXHOLD];
 
#define	NOPURGE	0		/* don't purge ... replace */
#define	PURGE	1		/* purge after print (footnote) */
#define	FIG_PURGE	2	/* purge and create new holds (figure) */

#define	HOLDSIZE	sizeof (struct hold)
