#
#include <stdio.h>

#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
struct macro *libsrch();
#include "fmtmac.h"
#define	ARMAGIC	0177545

#define	LIBMAX	8
#define	alllibs	l=libs; l<libs+libcnt; ++l

struct lib
{
int l_dev;		/* device number */
int l_inode;		/* inode number */
FILE *l_file;		/* file pointer */
} libs[LIBMAX];
int libcnt;		/* number of libraries in use */
long liblen;

library()
{
/*
 * fmt library function ... specify macro libraries.
 */

char libname[32];

struct stat
{
int s_dev;		/* device number */
int s_inode;
int s_flags;
char s_nlinks;
char s_uid;
char s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb;

register struct lib *l;
register FILE *i;

if(fn_str(libname,sizeof libname)<0)
	{
	err("library: bad library name");
	return;
	}
if(stat(libname,&statb) < 0)
	{
	err("library: %s not found",libname);
	return;
	}
for(alllibs)
	if(statb.s_inode==l->l_inode && statb.s_dev==l->l_dev)
		return;		/* already using it */
if((i = fopen(libname,"r")) == (FILE *) NULL)
	{
	err("library: %s not found",libname);
	return;
	}
if(getw(i)!=ARMAGIC)
	{
	fclose(i);
	err("library: %s not library",libname);
	return;
	}
l->l_file = i;
l->l_inode = statb.s_inode;
l->l_dev = statb.s_dev;
++libcnt;
/*NOSTRICT*/
v_lib = libsrch;
}

struct macro *libsrch(name)
char *name;
{
register struct lib *l;
register struct macro *m;
long s;
char buff[128];

struct ar
{
char a_name[14];
int a_time[2];
char a_uid;
char a_gid;
int a_mode;
long a_size;
} ar;
char aname[1+sizeof ar.a_name];

for (alllibs)
	{
	fseek(l->l_file,2l,0);
	while (fread(l->l_file,&ar,sizeof ar) == sizeof ar)
		{
		move(sizeof ar.a_name,ar.a_name,aname);
		aname[sizeof ar.a_name] = 0;
		if(equal(name,aname))
			goto found;
		s = ar.a_size;
		if(s&1)
			++s;
		fseek(l->l_file,s,1);	/* seek past the end of text */
		}
	}
return(0);

found:

liblen = ar.a_size;
m = mac_create(name,T_MACRO," ",1);
while (libread(l->l_file,buff))
	mac_append(m,buff,length(buff));
return(m);
}

libread(inbuff,buff)
FILE *inbuff;
char *buff;
{
register char *p;
register int c;

p = buff;

while (liblen-- > 0 && ( c = getc(inbuff)) > 0)
	{
	if(c == '\n')
		{
		*p++ = ' ';
		*p = 0;
		return(p-buff);
		}
	else
		*p++ = c;
	}
return(0);
}
