#
/*
 * FS Version 5.0
 */
#define OFF	0
#define ON	1
#define EMPTY	2

#define IMASK	060000
#define IDIR	040000
#define IFILE	000000
#define MAGIC   0123456
#define VERBOSE	(!terse)
#define CPLEN 4096
#define DIRLEN  sizeof(pdir)

#define WTM 0
#define FSF 1
#define BSF 2
#define FSR 3
#define BSR 4
#define REW 5
#define OFL 6

#define OLDTDATE0 05456	/* To accommodate old FS Tapes */
#define OLDTDATE1 0120157

#define SAVE	1
#define LIST	2
#define RESTORE	3
#define STOP	4
#define INIT	5
#define REWIND	6
#define UNIX	7
#define PRESERVE 8
#define HELP	9
#define EXTRACT	10
#define CHDIR	11
#define LPLIST	12
#define SLIST	13
#define SORTLIST 14
#define SET	15

#define PEX 0
#define PER 1
#define PFX 2
#define PFR 3

char *cmds[]
	{"save","list","restore","stop","init","rewind","unix",
	"preserve","help","extract","chdir",
	"lplist","slist","sortlist","setdate",0};

char	trouble[]	"Trouble. Retry\n";
char	failed[]	"Failed 5 tape positioning attempts. Your baby\n";
char	*labelname	" Label/directory: ";
char    labl[16];
char	*tapename	"/dev/rmt?";
char	*argpp[32];
char	**argp;
char	*dirname;
int	dir;
int	tape;
int	argc;
char	argl[160];
char	lastch;
int	terse;
int	filecnt;
int	tapeless 1;
int	labeled;
int	needir  1;
int	ateot;
int     update 1;
char	*cpbuf;
int	tapeposn;
int	oldtdate[2];	/* Old Tapes */
int	sigallwd;
int	reset();
int	sttycth();
int	sig2;
int	sig3;
int	tpshcth();
int	dirdat[2];
int	dirinum[2];
char	*dbuf;
char	*corend;
char	*timename;
int	subing;
int	orig;
int	added;
int	freshstart 1;
int	dsw;
int	skipobjs;
int	based;
int	basedtime[2];
int	dotminmaj;
int	nomount;
int	sizelimit;
char	subdat[58];
char	*exstring;
int	subtab[12][2];

struct	{
	int  minmaj;
	int  inumber;
	int  flags;
	char links;
	char uid;
	char gid;
	char size0;
	int  size1;
	int  addr[8];
	int  actime[2];
	int  modtime[2];
	} stats;

struct	nmstr {
	int c_mrecnt;
	char c_name[];
	};

struct ldirstr	{
	int	d_magic;
	int	d_no;
	char	d_name[58];
	char	d_ids[2];
	int	d_sdate[2];
	int	d_vers;
	int	d_mdate[2];
	int	d_flags;
	int	d_size[2];
	};

struct cdirstr	{
	int	c_magic;
	int	c_no;
	char	c_ids[2];
	int	c_sdate[2];
	int	c_vers;
	int	c_mdate[2];
	int	c_flags;
	int	c_size[2];
	struct	nmstr *c_nmloc;
	char	*c_next;
	};

struct	ldirstr pdir;
struct  cdirstr *gdir;
struct  cdirstr *dbufptr;

main(argcc,argv)						/* main */
char **argv;
{
	char cppbuf[CPLEN];
	register command;
	cpbuf = cppbuf;

	setexit();
	if(freshstart) startup(argcc,argv);
	buffer(EMPTY);

	for(;;) {
		signal(2,sig2);
		signal(3,sig3);
		terse = dsw = skipobjs = nomount = sizelimit = subing = 0;
		update = 1;
		write(1,"= ",2);
		if((argc = getline()) == 0) continue;
		command = cmd();
		chkargs();
		switch(command) {

			case	SAVE:
				if(argc < 2 || tapeless) break;
				if(argc==2)argp[2]=argp[1];
				if(stat(argp[1],&stats)<0) error(PER,argp[1]);
				save(OFF,argp[1],argp[2]);
				dumpdir();
				break;

			case	PRESERVE:
				if(tapeless) break;
				preserve();
				break;

			case	RESTORE:
				if(argc < 2 || tapeless) break;
				if(argc==2) argp[2]=argp[1];
				locate(argp[1]);
				restore(OFF,argp[1],argp[2]);
				break;

			case    EXTRACT:
				if(tapeless) break;
				extract();
				break;

			case	LIST:
				if(needir) tapesearch(0,0);
				buffer(ON);
				list();
				buffer(OFF);
				break;

			default:
				write(1,"Invalid command\n",16);
				break;

			case	STOP:
				if(!tapeless) {
					if(needir) unlink(dirname);
					else dumpdir();
				}
				exit();

			case	INIT:
				init();
				break;

			case	REWIND:
				rew();
				break;

			case	CHDIR:
				if(chdir(argp[1])!=0) perror("chdir");
				else printf("Changed to: %s\n",argp[1]);
				break;

			case	HELP:
				if(fork()) {
					signal(2,1);
					signal(3,1);
					while(wait() >= 0);
				}  else  {
					execl("/bin/help","help","fs",0);
					printf("No /bin/help");
					exit();
				}
				break;

			case	UNIX:
				signal(2,1);
				signal(3,1);
				if(fork()) while(wait()>=0);
				else {
					close(dir);
					if(!tapeless) close(tape);
					execl("/bin/sh","sh",0);
					exit();
				}
				break;

			case	LPLIST:
				if(needir) tapesearch(0,0);
				lplist();
				break;

			case	SLIST:
				if(needir) tapesearch(0,0);
			case	SORTLIST:
				slist();
				break;

			case	SET:
				setdate();
				break;

		}
	}
}

startup(argcc,argv)						/* startup */
char **argv;
{
	register id, len, fildes;
	int goodir, goodtape;
	int statr;
	struct ldirstr tdir;

	freshstart = 0;
	if((sig2 = signal(2,reset)) != 0) signal(2,sig2);
	else {
		sig2 = reset;
		sigallwd++;
	}
	if((sig3 = signal(3,0)) != 0) signal(3,sig3);
	argv++;
	if(**argv == '-') (*argv)++;
	tapename[8] = **argv;
	argv++;
	--argcc;
	while(--argcc > 0) {
		if(eq(*argv,"-d")) {
			dirname = argv[1];
			argv++;
			--argcc;
		}  else  if(eq(*argv,"-b")) {
				timename = argv[1];
				argv++;
				--argcc;
				if((fildes = open(timename,2)) < 0) error(PEX,timename);
				read(fildes,basedtime,4);
				close (fildes);
				based++;
		}  else  dirname = *argv;
		argv++;
	}

	if((dbuf = dbufptr = gdir = sbrk(4096)) < 0) error(PEX,"sbrk");
	corend = sbrk(0);
	goodtape=0;
	if(tapename[8]!='n') {
		tapeless=0;
		if((tape=open(tapename,2)) < 0) error(PEX,tapename);
		rew();
		if((len=read(tape,&pdir,DIRLEN))!=0){
			if(len<0)error(PEX,tapename);
			if(len!=DIRLEN || pdir.d_magic != MAGIC) {
				write(1,"Not FS tape. Overwrite? ",24);
				if(!getline() || argp[0][0] != 'y') exit();
				rew();
				wtm(3);
				rew();
			} else {
				goodtape=1;
				if(keywd(labelname,pdir.d_name)) {
					labeled=1;
					cp(pdir.d_name+18,labl);
					if(!dirname) dirname = labl;
				}
			}
		}
	}

	oldtdate[0] = OLDTDATE0;	/* Old Tapes */
	oldtdate[1] = OLDTDATE1;
	if(!tapeless && !goodtape && !dirname) {
		printf("Tape empty\n");
		askdname();
	}
	if(!dirname) dirname="fs.dir";

	goodir=0;
	if(stat(dirname,&stats) >= 0)
		if((dir=open(dirname,2))>=0)
			if((len=read(dir,&tdir,DIRLEN))==DIRLEN)
				if(tdir.c_magic==MAGIC)
					goodir=1;
				else ask();
			else	if(len>0)ask();
				else;
		else error(PEX,dirname);
	else dir=creat(dirname,0666);
	close(dir);
	if((dir=open(dirname,2))<0) error(PEX,dirname);
	stat(dirname,&stats);
	dirdat[0]=stats.modtime[0];
	dirdat[1]=stats.modtime[1];
	dirinum[0] = stats.inumber;
	dirinum[1] = stats.minmaj;

	if(!tapeless) {
		if(goodtape && goodir)
			if(dpcmp(tdir.d_sdate,pdir.d_sdate) ||  dpcmp(tdir.d_mdate,pdir.d_mdate)) {
				wrongdir:
				write(1,"Directory file not for this tape. Overwrite? ",45);
				badir:
				if(getch()!='y') exit();
				while(getch()!='\n');
				close(dir);
				close(creat(dirname,0666));
				dir=open(dirname,2);
				goto finish;
			} else	{
				if(!count()) {
					write(1," Overwrite? ",12);
					goto badir;
				}
				goto finish;
			}
		if(!goodtape) {
			if(goodir)goto wrongdir;
			else goto finish;
		}
	} else if(!count()) error(PFX,"\n");
	finish:
	rew();
	orig = filecnt;
	if(!goodtape && !tapeless) label();
}

ask()								/* ask */
{
	register char c;
	write(1,"Not directory file. Overwrite? ",31);
	c=getch();
	if(c != '\n') while(getch()!='\n');
	if(c!='y') exit();
	if((dir=creat(dirname,0666))<0)error(PEX,dirname);
	filecnt = 0;
}

count()                                                         /* count */
{
	register len;

	signal(2,1);
	seek(dir,0,0);
	filecnt = gdir = 0;

	while((len=read(dir,&pdir,DIRLEN)) > 0) {
		if(pdir.d_magic != MAGIC) {
			printf("Can't find MAGIC, file number %d",filecnt+1);
			signal(2,sig2);
			return(0);
		}
		chkcore();
		putdir();
	}
	if(len < 0) error(PEX,dirname);
	if(len > 0) {
		printf("Directory file not multiple of DIRLEN");
		signal(2,sig2);
		return(0);
	}
	printf("%d files\n",filecnt);
	needir = 0;
	signal(2,sig2);
	return(1);
}

getline()							/* getline */
{
	register char *line, **ptr, i;

	line = argl;
	argp = argpp;
	lastch = 0;
	for(i=0;i<32;)argp[i++]=0;
	ptr=argp;

	while((*line++ = getch())!='\n');
	if(line > argl+1) if(!(*(line =- 2))) *line = '\n';
	if(*argl == '\n') return(0);
	line=argl;
	do {
		*ptr++ =line;
		while(*line!=0 && *line !='\n')line++;
	} while(*line++!='\n');
	*--line=0;
	return(ptr - argp);
}

getch()								/* getch */
{
	char c;

	do {
		if(read(0,&c,1) <= 0) exit();
		if(c == '\\') {
			if(read(0,&c,1) <= 0) exit();
			if(c == '\n') c = ' ';
		}
	} while(c==' ' && lastch==0);
	if(c==' ')c=0;
	return(lastch=c);
}

cmd()								/* cmd */
{
	char **c;

	c=cmds;
	while(*c) if(keywd(argp[0],*c++))return(c-cmds);
	return(0);
}

keywd(ar,cm)							/* keywd */
{
	register char *a, *c;

	a = ar;
	c = cm;

	while(*a++ == *c && *c++);

	return(!*--a);
}

chkargs()							/* chkargs */
{
	while(argc > 1 && argp[1][0] == '-') {
		if(keywd(argp[1],"-ask")) dsw++;
		else if(keywd(argp[1],"-objects")) skipobjs++;
		else if(keywd(argp[1],"-terse")) terse++;
		else if(keywd(argp[1],"-update")) update = 0;
		else if(keywd(argp[1],"-mount")) nomount++;
		else if(keywd(argp[1],"-long")) update = 0;
		else if(keywd(argp[1],"-sub")) setsub();
		else if(argp[1][1] == '+') getsize(argp[1]);
		else if(argp[1][1] == '-') getsize(argp[1]);
		argp++;
		--argc;
	}
}

list()								/* list */
{
	register char *pattern;
	int tvec[2], i, nulint[2];
	register size, t;
	char tba[16];
	char tbb[16];
	extern ldivr;

	if(filecnt == 0) return;
	tba[0] = tbb[0] = nulint[0] = nulint[1] = 0;
	time(tvec);
	i = 1;
	if(VERBOSE && argc == 1)
		printf(" No.   Name                          Vers  Size  Date Saved       Last Modified\n");
	do	{
		gdir = dbuf;
		pattern=argp[i++];
		for(t= -1; ++t<filecnt;gdir = gdir->c_next) {
			if(pattern && !match((gdir->c_nmloc)->c_name,pattern))continue;
			if(update && (gdir->c_nmloc)->c_mrecnt != gdir->c_no) continue;
			if(VERBOSE){
				size=ldiv(gdir->c_size[0],gdir->c_size[1],512);
				if(ldivr)size++;
				if(dpcmp(gdir->c_sdate,oldtdate)<0 || dpcmp(gdir->c_sdate,tvec)>0)	/* Old Tapes */
					tba[0]=0;
				else cctime(ctime(gdir->c_sdate),tba);
				if(!t && labeled)
					cctime(ctime(dirdat),tbb);
				else cctime(ctime(gdir->c_mdate),tbb);
				printf("%4d %-32.32s %3d %4d  %15.15s  %s\n",
					t,(gdir->c_nmloc)->c_name,gdir->c_vers,size,tba,tbb);
			} else printf("%4d %s(%d)\n",t,(gdir->c_nmloc)->c_name,gdir->c_vers);
		}
	} while(i < argc);
}

cctime(cline,tline)						/* cctime */
char *cline, *tline;
{
	register char *tc, *tl;
	tc=cline;
	tl=tline;
	tc =+ 8;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =- 5;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =+ 5;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =+ 7;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl = 0;
	return(tline);
}

save(up,tosave,saveas)						/* save */
char *tosave, *saveas;
{
	int tvec[2], tt, sign;
	extern ldivr;
	register fildes, t, size;
	if(stats.inumber == dirinum[0] && stats.minmaj == dirinum[1]) {
		if(VERBOSE) printf("%s: FS directory\n",tosave);
		return;
	}
	if((stats.flags&IMASK)==IDIR) {
		if(VERBOSE) printf("%s: directory\n",tosave);
		return;
	}
	if((stats.flags&IMASK)!=IFILE) {
		if(VERBOSE) printf("%s: not a file\n",tosave);
		return;
	}
	if(sizelimit) {
		if(sizelimit > 0) sign = 1;
		else sign = -1;
		size = ldiv(stats.size0,stats.size1,512);
		if(ldivr) size++;
		size =* sign;
		if(size > sizelimit) {
			if(VERBOSE) printf("%s: size\n",tosave);
			return;
		}
	}
	if((fildes=open(tosave,0))<0) {
		perror(tosave);
		return;
	}
	if(read(fildes,&tt,2) == 0) {
		if(VERBOSE) printf("%s: zero length\n",tosave);
		close(fildes);
		return;
	}
	seek(fildes,0,0);
	if(skipobjs) {
		if(tt == 0407 || tt == 0410 || tt == 0411 || tt == 01) {
			if(VERBOSE) printf("%s: object\n",tosave);
			close(fildes);
			return;
		}
	}
	chkcore();
	collect:
	pdir.d_vers = getvers(saveas);
	if((based && dpcmp(basedtime,stats.modtime) > 0) ||
		(up && pdir.d_vers > 1 && dpcmp(gdir->c_mdate,stats.modtime) >= 0 )) {
			if(VERBOSE) printf("Not updated: %s\n",tosave);
			close(fildes);
			return;
	}
	if(dsw && !dswask(tosave)) return;
	cp(saveas,pdir.d_name);
	pdir.d_magic=MAGIC;
	pdir.d_no=filecnt;
	pdir.d_ids[0] = stats.uid;
	pdir.d_ids[1] = stats.gid;
	pdir.d_mdate[0]=stats.modtime[0];
	pdir.d_mdate[1]=stats.modtime[1];
	pdir.d_flags=stats.flags;
	pdir.d_size[0]=stats.size0;
	pdir.d_size[1]=stats.size1;
	time(tvec);
	pdir.d_sdate[0]=tvec[0];
	pdir.d_sdate[1]=tvec[1];
	posn(pdir.d_no);
	if(!ateot) {
		t = read(tape,cpbuf,CPLEN);
		bsr(1);
		if(t > 0) {
			if((*cpbuf).d_magic != MAGIC) error(PFR,trouble);
			tapeposn = (*cpbuf).d_no;
			tapesearch(0,0);
			goto collect;
		}
	}
	if(write(tape,&pdir,DIRLEN)<DIRLEN) error(PEX,tapename);
	dsc2tp(fildes,tosave);
	putdir();
	added++;
	if(VERBOSE) {
		printf("Saved: ");
		if(tosave == saveas) printf("%s(%d)\n",tosave,pdir.d_vers);
		else printf("%-32.32s as %s(%d)\n",tosave,saveas,pdir.d_vers);
	}
}

restore(up,restor,restoras)					/* restor */
char *restor, *restoras;
{
	register fildes, size, sign;
	int l, fsferr;
	extern ldivr;
	int tvec[2], ugid;
	struct {
		char lobyte;
		char hibyte;
		};

	fsferr = 0;
	if(gdir->c_no == 0 && labeled) return;
	if(sizelimit) {
		if(sizelimit > 0) sign = 1;
		else sign = -1;
		size = ldiv(gdir->c_size[0],gdir->c_size[1],512);
		if(ldivr) size++;
		size =* sign;
		if(size > sizelimit) {
			if(VERBOSE) printf("%s: size\n",restor);
			return;
		}
	}
	if(based && dpcmp(basedtime,gdir->c_mdate) > 0) goto nosave;
	if(up && stat(restoras,&stats) >= 0)
		if(up && dpcmp(gdir->c_mdate,stats.modtime) <= 0) {
			nosave:
			if(VERBOSE)printf("Not extracted: %s\n",(gdir->c_nmloc)->c_name);
			return;
		}
	if(dsw && !dswask(restor,gdir->c_vers)) return;
	again:
	posn(gdir->c_no);
	if((l=read(tape,&pdir,DIRLEN))!=DIRLEN)error(PEX,tapename);
	if(dpcmp(gdir->c_mdate,pdir.d_mdate) || dpcmp(gdir->c_sdate,pdir.d_sdate)) {
		if(gdir->c_no != pdir.d_no) {
			if(fsferr++ > 4) {
				rew();
				error(PFR,failed);
			}
			bsf(5);
			l=read(tape,&pdir,DIRLEN);
			bsr(1);
			if(l != DIRLEN || pdir.d_magic != MAGIC) {
				rew();
				error(PFR,trouble);
			}
			tapeposn=pdir.d_no;
			goto again;
		} else error(PFR,"Directory not for this tape\n");
	}
	if((fildes=creat(restoras,gdir->c_flags))<0){
		bsr(1);
		perror(restoras);
		return;
	}
	if(dpcmp(gdir->c_sdate,oldtdate) > 0 && dpcmp(gdir->c_sdate,tvec) <= 0) {
		ugid.lobyte = gdir->c_ids[0];
		ugid.hibyte = gdir->c_ids[1];
		chown(restoras,ugid);
	}
	tp2dsc(fildes,restoras);
	mdate(restoras,gdir->c_mdate);
	if(VERBOSE) {
		printf("Restored: %s(%d)",(gdir->c_nmloc)->c_name,gdir->c_vers);;
		if(restor != restoras) printf(" as %s",restoras);
		printf("\n");
	}
	return;
}

dsc2tp(in,name)							/* dsc2tp */
{
	register len, i;
	signal(2,1);
	while((len=read(in,cpbuf,CPLEN))>0){
		if(len != CPLEN)
			if(len < 32) {
				for(i = len; i < 32; i++) cpbuf[i] = 0;
				len = 32;
			} else if(len&1) cpbuf[len++] = 0;
		if(write(tape,cpbuf,len)!=len){
			rew();
			close(in);
			error(PER,tapename);
		}
	}
	close(in);
	if(len<0) error(PER,name);
	weot();
	signal(2,sig2);
}

tp2dsc(out,name)						/* tp2dsc */
{
	register len;
	int tot[2];
	signal(2,1);
	tot[0] = tot[1] = 0;
	while((len=read(tape,cpbuf,CPLEN))>0){
		if(len != CPLEN)
			if(len != 32)
				if(gdir->c_size[1]&1) --len;
				else;
			else if((len = gdir->c_size[1]&31) == 0) len = 32;
		if(write(out,cpbuf,len)!=len){
			close(out);
			error(PER,name);
		}
		dpadd(tot,len);
	}
	close(out);
	if(len < 0) error(PER,tapename);
	tapeposn++;
	if(dpcmp(tot,gdir->c_size)<0)
		error(PFR,"Failed to read anticipated byte count\n");
	signal(2,sig2);
}

locate(nam)							/* locate */
{
	register char *n;
	register i;
	register struct cdirstr *cd;
	char *t;
	int versno;

	n=nam;
	versno=0;
	while(*n != '(' && *n++);
	if(*--n) {
		*++n = 0;
		t = ++n;
		while(*n != ')' && *n) {
			versno =* 10;
			versno =+ *n++ - '0';
		}
		if(!*n) error(PFR,"Version Syntax: %s(%s\n",nam,t);
	}
	n=nam;
	cd = dbuf;
	if(needir && !versno) tapesearch(0,0);
	for(i=filecnt;i;--i) {
		if(eq((cd->c_nmloc)->c_name,n))
			if(!versno) {
				i=(cd->c_nmloc)->c_mrecnt;
				while(cd->c_no != i) cd = cd->c_next;
				return(gdir = cd);
			} else if(cd->c_vers == versno) return(gdir = cd);
		cd = cd->c_next;
	}
	if(needir) tapesearch(nam,versno);
	else error(PFR,"%s not on tape\n",n);
}

error(n,arg1,arg2,arg3,arg4)					/* error */
{
	int vec[3];

	if(n==PEX || n==PER) {
		perror(arg1);
		if(arg1 == tapename) {
			gtty(tape,vec);
			printf("%o %o %o\n",vec[0],vec[1],vec[2]);
			buffer(OFF);
		}
		if(n==PEX) exit();
		reset();
	}
	buffer(EMPTY);
	printf(arg1,arg2,arg3,arg4);
	if(n==PFX) exit();
	reset();
}

getvers(nam)							/* getvers */
char *nam;
{
	register i;
	register struct cdirstr *cd;

	cd = dbuf;
	for(i=filecnt;i && !eq((cd->c_nmloc)->c_name,nam);--i) cd = cd->c_next;
	if(!i) {
		gdir = 0;
		return(1);
	}

	i = (cd->c_nmloc)->c_mrecnt;

	while(cd->c_no != i) cd = cd->c_next;
	gdir = cd;
	return(cd->c_vers + 1);
}

tapesearch(nm,ver)						/* tapesearch */
{
	register len, fsferr;
	register struct cdirstr *gd;

	fsferr = 0;
	gdir = 0;
	if(sigallwd) signal(2,tpshcth);
	if(!ver) write(1,"Directory update - ",19);
	posn(filecnt);
	retry:
	while((len=read(tape,&pdir,DIRLEN)) > 0) {
		if(len!=DIRLEN) {
			rew();
			error(PFR,"Expected DIRLEN, got %d bytes\n",len);
		}
		if(pdir.d_magic!=MAGIC)
			error(PFX,"Missing magic, filecnt=%d\n",filecnt);
		if(pdir.d_no != filecnt) {
			if(fsferr++ > 4) {
				rew();
				error(PFR,failed);
			}
			bsf(5);
			len=read(tape,&pdir,DIRLEN);
			bsr(1);
			if(len != DIRLEN || pdir.d_magic != MAGIC) {
				rew();
				filecnt=0;
				error(PFR,trouble);
			}
			filecnt=tapeposn=pdir.d_no;
			goto retry;
		}
		gd = dbufptr;
		chkcore();
		putdir();
		if(ver && eq(nm,pdir.d_name) && pdir.d_vers == ver) {
			bsr(1);
			gdir = gd;
			signal(2,sig2);
			return;
		}
		fsf(1);
	}
	if(len<0) {
		rew();
		error(PER,tapename);
	}
	tapeposn++;
	needir = 0;
	printf("%d files\n",filecnt);
	if(ver) error(PFR,"%s not on tape\n",nm);
	dumpdir();
	signal(2,sig2);
}

tpshcth()							/* tpshcth */
{
	rew();
	ateot = 0;
	filecnt = 0;
	reset();
}

chkcore()							/* chkcore */
{
	register t;
	struct { char c; };

	if(corend - &(dbufptr->c) < 80) {
		if(((t = sbrk(256)) == -1) && ((t = sbrk(128)) == -1)) {
			needir = 0;
			dumpdir();
			error(PFR,"Out of memory, file maximum reached\n");
		}
		corend = sbrk(0);
	}
}

putdir()							/* putdir */
{
	register int *w, *p, t;

	w = &dbufptr->c_magic;
	p = &pdir;
	*w++ = *p++;	/* copy magic */
	*w = *p;	/* copy file number */
	w = dbufptr->c_ids;
	p = pdir.d_ids;
	for(t = 0; t++ < 9;) *w++ = *p++;
	getname();
	filecnt++;
}

cp(a,b)								/* cp */
{
	register char *aa, *bb;
	aa=a;
	bb=b;
	while(*bb++ = *aa++);
}

posn(file)							/* posn */
{
	if(file==0) {
		rew();
		return;
	}
	if(file==tapeposn) return;
	if(file>tapeposn) fsf(file-tapeposn);
	if(file<<1 > tapeposn)
		bsf(tapeposn-file);
	else {
		rew();
		fsf(file);
	}
}

rew()								/* rew */
{
	dostty(REW,1);
	tapeposn=0;
}

fsf(n)								/* fsf */
{
	dostty(FSF,n);
	tapeposn =+ n;
}

bsf(n)								/* bsf */
{
	dostty(BSF,n+1);
	dostty(FSR,1);
	tapeposn =- n;
}

wtm(n)								/* wtm */
{
	dostty(WTM,n);
	tapeposn =+ n;
}

weot()								/* weot */
{
	dostty(WTM,3);
	dostty(BSF,2);
	tapeposn++;
	ateot++;
}

bsr(n)								/* bsr */
{
	dostty(BSR,n);
}

dostty(fn,n)							/* dostty */
{
	int arg[3];
	int oldsig;

	if(sigallwd) oldsig = signal(2,sttycth);
	else oldsig = sig2;
	arg[0]=fn;
	arg[1]=n;
	if(!tapeless && stty(tape,arg) < 0) {
		gtty(tape,arg);
		printf("%o %o %o\n",arg[0],arg[1],arg[2]);
		buffer(OFF);
		signal(2,oldsig);
		error(PER,"stty");
	}
	ateot = 0;
	signal(2,oldsig);
}

sttycth()
{
	rew();
	error(PFR,"Stty interrupted\n");
}

init()								/* init */
{
	register char c;

	write(1,"Type 'y' to erase tape ",24);
	c=getch();
	if(c != '\n') while(getch() != '\n');
	if(c!='y')return;
	needir = filecnt = orig = 0;
	close(dir);
	unlink(dirname);
	askdname();
	close(creat(dirname,0666));
	dir=open(dirname,2);
	gdir = dbufptr = dbuf;
	stat(dirname,&stats);
	dirinum[0] = stats.inumber;
	dirinum[1] = stats.minmaj;
	rew();
	wtm(3);
	rew();
	label();
}

eq(ar,cm)							/* eq */
{
	register char *a, *c;

	a = ar;
	c = cm;

	while(*a++ == *c && *c++);

	return((c != cm) && (!*--a && !*--c));
}

buffer(n)							/* buffer */
{
	extern int fout;
	if(n == ON) fout=dup(1);
	else {
		if(fout <= 1) return;
		if(n == OFF) {
			flush();
			close(fout);
		} else {
			close(fout);
			flush();
		}
		fout=1;
	}
	flush();
}


lplist()							/* lplist */
{
	int pip[2], oldone;
	extern int fout;

	pipe(pip);
	if(fork()) {
		fout=pip[1];
		close(pip[0]);
		list();
		flush();
		close(fout);
		fout=1;
		flush();
	} else	{
		close(0);
		dup(pip[0]);
		close(pip[0]);
		close(pip[1]);
		signal(2,1);
		signal(3,1);
		if(!tapeless) close(tape);
		close(dir);
		execl("/bin/lpr","lpr",0);
	}
}

slist()								/* slist */
{
	int pip[2], oldone;
	extern int fout;

	printf("Sorting - ");
	pipe(pip);
	if(fork()) {
		fout=pip[1];
		close(pip[0]);
		list();
		flush();
		close(fout);
		fout=1;
		flush();
		while(wait()>=0);
		printf("Sorted list sent to lpr\n");
		if(!fork()) {
			signal(2,1);
			signal(3,1);
			if(!tapeless) close(tape);
			close(dir);
			execl("/bin/lpr","lpr","-r","fs.sort",0);
			printf("Couldn't exec lpr\n");
			exit();
		}
	} else	{
		close(0);
		dup(pip[0]);
		close(pip[0]);
		close(pip[1]);
		if(!tapeless) close(tape);
		close(dir);
		signal(2,1);
		signal(3,1);
		execl("/bin/sort","sort","-u","+0.4","-0.36","-o","fs.sort",0);
		exit();
	}
}

setdate()							/* setdate */
{
	register file;
	register char *tname;

	if(argc > 1) tname = argp[1];
	else tname = timename;
	if(tname == 0) error(PFR,"No time-file name\n");
	if((file = creat(tname,0666)) < 0) error(PER,tname);
	time(basedtime);
	write(file,basedtime,4);
	close(file);
}

match(s, p)							/* match */
char *s, *p;
{
	if (*s=='.' && *p!='.')
		return(0);
	return(amatch(s, p));
}

amatch(as, ap)							/* amatch */
char *as, *ap;
{
	register char *s, *p;
	register scc;
	int c, cc, ok, lc;

	s = as;
	p = ap;
	if (scc = *s++)
		if ((scc =& 0177) == 0)
			scc = 0200;
	switch (c = *p++) {

	case '[':
		ok = 0;
		lc = 077777;
		while (cc = *p++) {
			if (cc==']') {
				if (ok)
					return(amatch(s, p));
				else
					return(0);
			} else if (cc=='-') {
				if (lc<=scc && scc<=(c = *p++))
					ok++;
			} else
				if (scc == (lc=cc))
					ok++;
		}
		return(0);

	default:
		if (c!=scc)
			return(0);

	case '?':
		if (scc)
			return(amatch(s, p));
		return(0);

	case '*':
		return(umatch(--s, p));

	case '\0':
		return(!scc);
	}
}

umatch(s, p)							/* umatch */
char *s, *p;
{
	if(*p==0)
		return(1);
	while(*s)
		if (amatch(s++,p))
			return(1);
	return(0);
}

label()								/* label */
{
	int tvec[2];

	gdir = needir = 0;
	signal(2,1);
	signal(3,1);
	labeled++;
	cp(labelname,pdir.d_name);
	cp(dirname,pdir.d_name+18);
	pdir.d_no = pdir.d_size[0] = pdir.d_size[1] = 0;
	pdir.d_vers = 1;
	pdir.d_magic = MAGIC;
	time(tvec);
	pdir.d_sdate[0]=tvec[0];
	pdir.d_sdate[1]=tvec[1];
	dirdat[0]=tvec[0];
	dirdat[1]=tvec[1];
	if(write(tape,&pdir,DIRLEN) != DIRLEN) error(PEX,tapename);
	weot();
	chkcore();
	putdir();
}

askdname()							/* askdname */
{
	if(argc <= 1) {
		printf("Enter label/directory name. Suggested format: fs.NAME\n");
		while((argc = getline()) == 0);
		if(keywd(argp[0],"stop")) exit();
	}
	else argp[0] = argp[1];
	cp(argp[0],labl);
	dirname=labl;
}

getname()							/*getname */
{
	register int t;
	register char *n, *o;

	if(gdir || ((dbufptr->c_vers > 1) && findup(pdir.d_name))) {
		dbufptr->c_nmloc = gdir->c_nmloc;
		(dbufptr->c_nmloc)->c_mrecnt = dbufptr->c_no;
		dbufptr = dbufptr->c_next = dbufptr + 1;
		gdir = 0;
		return;
	}

	dbufptr->c_nmloc = dbufptr + 1;
	n = (dbufptr->c_nmloc)->c_name;
	o = pdir.d_name;
	while(*n++ = *o++);
	(dbufptr->c_nmloc)->c_mrecnt = dbufptr->c_no;
	dbufptr = dbufptr->c_next = n + (n&1);
}

dumpdir()							/* dumpdir */
{
	register int *p, *l, t;
	int i;
	char *pp, *ll;

	gdir = dbuf;
	for(p=0;p < orig;p++) gdir = gdir->c_next;
	for(i=orig;i < filecnt;i++) {
		p = &gdir->c_magic;
		l = &pdir;

		*l++ = *p++;
		*l = *p;

		p = gdir->c_ids;
		l = pdir.d_ids;
		for(t=0;t++ < 9;) *l++ = *p++;

		pp = (gdir->c_nmloc)->c_name;
		ll = pdir.d_name;
		while(*ll++ = *pp++);

		gdir = gdir->c_next;
		if(write(dir,&pdir,DIRLEN) < DIRLEN) error(PER,dirname);
	}
	orig = filecnt;
	gdir = 0;
}
extract()							/* extract */
{
	register int t, f, mth;
	int all;
	char *new, newpath[58];

	mth = 0;
	if(argc == 1) all = 1;
	else all = 0;
	if(needir) tapesearch(0,0);
	gdir = dbuf;
	for(f=0;f < filecnt;f++) {
		for(t = argc; t > 1 || (all && t-- == 1);)
			if(all || match((gdir->c_nmloc)->c_name,exstring=argp[--t]))
				if(update && (gdir->c_nmloc)->c_mrecnt != gdir->c_no) continue;
				else {
					if(subing) new = makesub((gdir->c_nmloc)->c_name,newpath);
					else new = (gdir->c_nmloc)->c_name;
					restore(update,(gdir->c_nmloc)->c_name,new);
					mth++;
				}
		gdir = gdir->c_next;
	}
	if(!mth) printf("No match\n");
}

expand(as)							/* expand */
char *as;
{
	register char *s, *cs, *dirf;
	char pathname[128];

	s = cs = as;
	while(*cs != '*' && *cs != '?' && *cs != '[')
		if(!*cs++) {
			if(!rfp(as,as)) printf("No match\n");
			return;
		}
	while(cs != s && *--cs != '/');

	dirf = pathname;
	if(*cs == '/')
		do *dirf++ = *s++;
		while(s < cs);
	else *dirf++ = '.';
	*dirf++ = 0;
	if(!rfp(pathname,as)) printf("No match\n");
}

rfp(pathname,pattern)						/* rfp */
char *pathname, *pattern;
{
	int mth, fildes;
	register char *p, *s, *q;
	char newpath[58];
	char *new, *oldp;
	struct {
		int ino;
		char name[16];
	} entry;

	p = pathname;
	if(pattern && match(p,pattern)) pattern = 0;
	if(stat(p,&stats)<0) return(0);
	if((stats.flags&IMASK)!=IDIR) {
		if(needir) tapesearch(0,0);
		if(subing) new = makesub(p,newpath);
		else new = p;
		save(update,p,new);
		return(1);
	}

	if(nomount) {
		if(dotminmaj != stats.minmaj) {
			if(VERBOSE) printf("%s: mounted\n",p);
			return(0);
		}
	}
	if((fildes = open(p,0))<0) return(0);
	if(*p=='.' && !*++p) pathname = p+1;
	if(*p=='/' && !*++p) pathname = p;
	while(*p++);
	--p;
	oldp = p;
	*p++ = '/';
	mth = 0;
	while ((read(fildes,&entry,16))==16) {
		if(!entry.ino || entry.name[0] == '.') continue;
		s = p;
		q = entry.name;
		entry.name[14] = 0;
		while(*s++ = *q++);
		if(!pattern || match(pathname,pattern)) mth=rfp(pathname,0);
	}
	*oldp = 0;
	close(fildes);
	return(mth);
}

preserve()						/* preserve */
{
	register t;

	added = 0;
	if(argc == 1) {
		argp[1] = "*";
		argc++;
	}

	if(nomount) {
		stat(".",&stats);
		dotminmaj = stats.minmaj;
	}
	for(t = argc; t >1;) expand(exstring=argp[--t]);

	printf("%d added, now %d files\n",added,filecnt);
	dumpdir();
}

findup(nam)							/* findup */
char *nam;
{
	register i;
	register struct cdirstr *cd;

	cd = dbuf;

	for(i=filecnt;i;--i)
		if(eq(nam,(cd->c_nmloc)->c_name)) return(gdir = cd);
		else cd = cd->c_next;

	return(0);
}

dswask(na)							/* dswask */
{
	register char c;

	printf("%s  ",na);
	c = getch();
	if(c != '\n') while(getch() != '\n');
	if(c == 'y') return(1);
	return(0);
}

getsize(szz)							/* getsize */
char *szz;
{
	register char *sz;
	register sign;

	sizelimit = 0;
	sz = szz;

	sz++;
	if(*sz++ == '+') sign = 1;
	else sign = -1;

	while(*sz) sizelimit = sizelimit * 10 + *sz++ - '0';

	sizelimit =* sign;
}

setsub()							/* setsub */
{
	register char *a, *sb;
	register t;
	int sti;

	if(argc < 4) error(PFR,"Arg cnt\n");
	for(t = 0;t < 12;) subtab[t++][0] = 0;
	argp++;
	--argc;
	subing++;
	a = argp[1];
	sb = subdat;

	if(*a == '|') a++;
	while((*sb = *a++) && *sb != '|') sb++;
	if(*sb == '|') *sb = 0;
	sti = 0;
	for(t = 2; t < argc; t++) {
		a = argp[t];
		if(*a++ != '|') continue;
		sb = argp[t];
		while((*sb = *a++) && *sb != '|') sb++;
		if(*sb == 0) error(PFR,"Syntax\n");
		subtab[sti][0] = argp[t];
		subtab[sti++][1] = sb - argp[t];
		while(*sb++ = *a++);
	}
}

makesub(matched,new)					/* makesub */
char *matched, *new;
{
	register t;
	register char *a, *n;

	for(t = 0;t < 12; t++) if(exstring == subtab[t][0]) goto go;
	return(matched);

	go:
	a = subdat;
	n = new;
	while(*n = *a++) n++;

	a = matched + subtab[t][1];

	while(*n++ = *a++);

	if(*new == 0) error(PFR,"Very funny\n");
	return(new);
}
