/* blank parser much like how awk handles white space sep fields */


#include <stdio.h>
#include <ctype.h>
#define NL '\n'
#define EOS '\0'
#define TAB '\t'
#define BLK ' '
#define NO 0
#define YES 1


#ifdef TEST
main() {
	int nf, i;
	char buf[256], *bptrs[50];
	while ( fgets(buf,256,stdin) != NULL){
		nf = bparse (buf, 256, bptrs, 50);
		if (nf < 0){
			printf("missing terminator\n");
			nf *= -1;
		}
		printf("nf=%d\n",nf);
		for (i=0; i<nf; i++)
			printf("%s\n",bptrs[i]);
		printf("\n");
	}
}
#endif

int bparse(bp, bufsiz, bptrs, fldsiz)
register char *bp; 
char *bptrs[];
int bufsiz, fldsiz;
{
	register int nf=0, inword=NO;
	char *endbuf;

	endbuf = bp + bufsiz;			/* save addr of buf end */

	while (*bp) {
		switch (*bp) {
			case BLK: 
			case TAB:
				*bp = EOS;
				inword = NO;
				break;
			default:
				if (inword)
					break;
				bptrs[nf] = bp;
				if (++nf > fldsiz) 
					err("bparse:%d=too many flds",nf);
				inword = YES;
				break;
		} /* switch */


		if (++bp > endbuf)
			err("bparse:line toobig");
	} /* while */

	bptrs[nf+1]=NULL;	/* set last+1 pointer to null */
	return (nf);		/* return number of flds */
}
