/* parse on an arbitrary character field sep much like awk does */

#include <stdio.h>
#include <ctype.h>
#define EOS '\0'

#ifdef TEST
#define NF 10
#define BSIZ 20
char buf[BSIZ], *split[NF];
main() {
	int nf, i, k, splitnf;
	int cparse();
	while ( getln(buf,BSIZ,stdin) != EOF){
		splitnf = cparse (buf, BSIZ, split, '=', NF);
		printf("n split fields=%d\n",splitnf);
		for(i=0; i<splitnf; i++)
			printf("%s\n",split[i]);
		printf("\n");
	}
}
#endif

int cparse(str, strsiz, split, sep, maxsep)
register char *str, sep;
char *split[];
int strsiz, maxsep;
{

	int nf=0, white=1;
	register char *endbuf=str+strsiz;
	char *c;

	for(c=str; *str; ++str){
		if(str >= endbuf)
			err("cparse:no eos");
		if(white && !(isspace(*str)))
			--white;
		if (*str == sep) {
			*str++ = EOS;
			split[nf++] = c;
			if(nf >= maxsep)
				err("cparse:>%d fields", maxsep);
			c = str--;
		}
	}

	if (white)
		return(0);

	split[nf++] = c;
	split[nf] = NULL;	/* be nice, set last str ptr=null */
	return (nf);		/* return number of flds */
}
