/*	synopsis: nf = glnstr(buf, bufsiz, bptr, nbptrs)
purpose:take a null terminated or newline terminated string and parse it.
ptrs into each str in buf is returned in bptr[0]..bptr[nf-1].
quotes delimit strs. REMEMBER! buf after glnstr is NOT the same buf as
after fgets. nf<0 if missing quote and nf=0 for null lines
*/


#include <stdio.h>
#include <ctype.h>
#define NL '\n'
#define EOS '\0'
#define TAB '\t'
#define BLK ' '
#define NO 0
#define YES 1
#define QUOTE ('"')


#ifdef TEST
main() {
	int nf, i;
	char buf[256], *bptrs[50];
	while ( fgets(buf,256,stdin) != NULL){
		nf = glnstr (buf, 256, bptrs, 5);
		if (nf < 0){
			printf("missing terminator\n");
			nf *= -1;
		}
		printf("nf=%d\n",nf);
		for (i=0; i<nf; i++)
			printf("%s\n",bptrs[i]);
		printf("\n");
	}
}
#endif

int glnstr(bp, bufsiz, bptrs, fldsiz)
register char *bp; 
char *bptrs[];
int bufsiz, fldsiz;
{
	register int nf=0, inword=NO;
	int qflag=NO;
	char *start="", *c, *endbuf;

	endbuf = bp + bufsiz;			/* save addr of buf end */

	while (*bp != NL) {
		switch (*bp) {
			case EOS:
			case BLK: 
			case TAB: *bp = EOS;
				  inword = NO;
				  break;

			case QUOTE: /* ripple chars left */

				if ( !(inword) ) {
					start = bp;
					qflag = YES;
				}

		left:
				for(c=bp; *++bp != QUOTE; c++){  

						/* matching quote ? */
					*c = *bp;
					if (*c == NL){ 
						if (nf == 0){
							bptrs[nf]=start;
							++nf;
						}
						else
							*bp = EOS;
						return ( -(nf) );
					}
				}



				while(!(isspace(*++bp))){
					if ( *bp == QUOTE)
						goto left;
					*c++ = *bp;
				}
					
				--bp;
				*c = *bp = EOS;
				bp = c;


			default:
				if (inword)
					break;
				bptrs[nf] = (qflag) ? start : bp;
				if (++nf > fldsiz) 
					err("glnstr:%d=too many flds",nf);
				inword = YES;
				qflag = NO;
				break;
		} /* switch */


		if (++bp >= endbuf)
			err("glnstr:line toobig");
	} /* while */

	*bp = EOS;		/* change newline to EOS */
	bptrs[nf+1] = NULL;	/* null nf + 1 to be nice */
	return (nf);		/* return number of flds */
}
