#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

findsymbol(name)
char *name;
{
register struct symbol *s;

s = &symbols[hash(name)];
while (s->s_name[0] != 0)
	{
	if (eqsym(s->s_name,name))
		return(s);
	if (++s >= &symbols[MAXSYMBOLS])
		s = &symbols[0];
	}
if(!defining)
	return(0);

/* allocate table entry for the symbol */

if(s_first == 0)
	s_first = s;		/* first entry on list */
else
	s_last->s_next = s;	/* latest entry on list */
s_last = s;
if (++nsymbols >= MAXSYMBOLS-1)
	err("more than %d symbols");
cpsym(name,s->s_name); /* copy the name */
s->s_addr = 0;
s->s_flags = UNDEFINED;
s->s_psect=cur_psect;
return(s);
}

prundef()
{
register struct symbol *s;
register int cnt;

cnt=0;

for(allsymbols)
	if (s->s_flags == UNDEFINED)
		{
		if (cnt++ == 0)
			printf("Undefined Symbols:\n");
		printf("%-8.8s",s->s_name);
		if (cnt&7)
			putchar(' ');
		else
			putchar('\n');
		}
if(cnt&7)
	putchar('\n');
if (cnt > 4)
	printf("%d undefined.\n",cnt);
errcnt = cnt;
flush();
}



do_globl(name,flags,value)
char *name;
int flags;
int value;
{
register struct symbol *s;

s = findsymbol(name);
flags =| cur_rflag;
if (flags&RELOC) value =+ cur_reloc;
if (s->s_flags&DEFINED) /* previously */
	{
	if (flags&DEFINED) /* oops, possible error */
		{
		if(s->s_psect!=cur_psect || s->s_addr !=value)
			warn("'%.8s' is multiply defined",s->s_name);
		else
			; /* same, allow it */
		}
	else ; /* reference to old definition */
	}
else	/* undefined before */
	{
	if (flags&DEFINED)
		{	/* now defined for first time */
		s->s_flags = flags ;
		s->s_addr = value;
		s->s_psect = cur_psect;
		}
	else
		; /* still undefined */
	}

if(scan>1 || (scan && (flags&DEFINED)))
	/* if full scan or symbol just defined */
	prsym(s);
return(s);
}


prsym(sp)
struct symbol *sp;
{
register struct symbol *s;

s = sp;

printf("%-8.8s ",s->s_name);
if (s->s_flags&DEFINED)
	printf("%6o",s->s_addr);
else
	printf("******");
if (s->s_flags&RELOC)
	printf("-r");
else
	printf("  ");
if(debflg>1)
	printf(" <%-8.8s>",(s->s_psect)->p_name);
if (++pos & 3 )
	putchar(' ');
else
	putchar('\n');
}

dumpsym(msg)
char *msg;
{
register struct symbol *s;

if(nsymbols==0)
	return;
printf(msg);
pos = 0;

for(allsymbols)
	prsym(s);

printf("\n%d symbols.\n",nsymbols);
}


outsymtab()
{
int n;
register struct symbol *s;
char name[8];
/*
 * dump symbol table to file 
 */

pflush();	/* empty the buffer */
out.p_offset = 020+aa_out.a_tsize+aa_out.a_dsize;
for(allsymbols)
	{
	if(s->s_flags==UNDEFINED)
		n = UUNDEF;
	else
		switch((s->s_psect)->p_flags&(DEFINED|RELOC|BSS|ACCESS))
		{
		case ABS|DEFINED:
			if(!aflg)
				goto next;
			n = UABS;
			break;
	
		case REL|DEFINED|BSS:
			n = UBSS;
			break;
	
		case REL|DEFINED|SHR:
			n = UTEXT;
			break;
	
		case REL|DEFINED:
			n = UDATA;
			break;
	
		default:
			printf("undefined type %o\n",s->s_flags);
		n = 0;
		}
	putsym(s->s_name);	/* translate & output name */
	putwd(n);
	putwd(s->s_addr);
	aa_out.a_ssize =+ 8 + sizeof n + sizeof s->s_addr;
next:
	;
	}
pflush();
seek(out.fildes,0,0);
write(out.fildes,&aa_out,sizeof aa_out);
}


putsym(sname)
char *sname;
{
register char c;
register char *p;
register int i;

p = sname;
i = 8;
do
	{
	c = *p++;
	if(c == '$')
		c = '_';
	putch(c);
	}
while (--i);
}

hash(name)
int *name;
{
register int *n;
register int i,j;
extern ldivr;

n = name;
i = *n++ + *n++;
j = *n++ + *n++;
i = (i*j+i+j+1) % (MAXSYMBOLS-1);
if(i < 0)
	i = -i;
return(i);
}
