#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define MAXMAP 256

struct symbol *umap[MAXMAP];
struct a_obj u;			/* unix object header */
struct psect *utext, *udata, *ubss;
int data_reloc, bss_reloc;
int text_reloc;
int s_count;

struct sym
{
char u_name[8];
int u_flags;
char *u_addr;
} sym;

unixobj()
{

defining = 1;		/* must enter automatically */
gettxt(&u,sizeof u);
if(u.a_rflags!=0)
	err("no rld info");
if(u.a_ssize==0)
	err("no symtab");
utext = do_psect("..text..",SHR|CON|REL,u.a_tsize);
utext->p_flags =& ~BSS;
udata = do_psect("..data..",CON|REL,u.a_dsize);
udata->p_flags =& ~BSS;
ubss = do_psect("..bss...",CON|REL,u.a_bsize);
text_reloc = 0;
data_reloc = u.a_tsize;
bss_reloc = u.a_tsize+u.a_dsize;

gseek(u.a_tsize+u.a_dsize);		/* seek to symbol table */
gseek(u.a_tsize+u.a_dsize);		/* seek to symbol table */
unixsym();			/* process symbol table */
}


unixsym()
{
int i;
struct psect *p;
register struct symbol *s;

s_count = u.a_ssize/ sizeof sym;
if(s_count > MAXMAP)
	err("more than %d symbols in unix obj",MAXMAP);
if(debflg>1)
	printf("%d unix symbols\n",s_count);
for (i=0; i<s_count; ++i)
	{
	gettxt(&sym, sizeof sym);
	if(debflg>1)
		printf("%.8s %o %o\n",sym.u_name,sym.u_flags,sym.u_addr);
	switch(sym.u_flags)
		{
	case UUNDEF:
		if(sym.u_addr!=0)
			{		/* common block */
			p = do_psect(sym.u_name,OVR|REL,sym.u_addr);
			s = do_globl(sym.u_name,DEFINED|REL,0);
			break;
			}
		s = do_globl(sym.u_name,UNDEFINED,0);
		break;

	case UABS:
		s = do_globl(sym.u_name,DEFINED,sym.u_addr);

	case UTEXT:
		cur_psect = utext;
		s = do_globl(sym.u_name,DEFINED | REL,sym.u_addr);
		break;

	case UDATA:
		cur_psect = udata;
		s = do_globl(sym.u_name,DEFINED|REL,sym.u_addr-data_reloc);
		break;

	case UBSS:
		s = do_globl(sym.u_name,DEFINED|REL,sym.u_addr-bss_reloc);
		break;
	default:
		s = 0;
		break;
		}
	umap[i] = s==0 ? -1 : s - &symbols[0];
	}

}



urld1(textp,rldp,length)
int *textp, rldp;
int length;
{
/*
 * pass1 routine to relocate text to current psect origins. 
 * most relocation is done in pass2. 
 */

register int *t, *r;
int n;
int i;

t = textp;
r = rldp;

for (i=0; i< length>>1; ++i)
	{
	switch(*r & 016)
		{
	case 02:		/* text relocation */
		*t =- text_reloc;
		break;

	case 04:		/* data relocation */
		*t =- data_reloc;
		break;

	case 06:		/* bss relocation */
		*t =- bss_reloc;
		break;

	case 010:
		if(pass==1)
			{
			n = umap[(*r>>4) & 07777];
			if(n < 0)
				err("rld to non-globl");
			*r = (*r & 017) | ( n << 4);
			}
		else
			{
			n = (symbols[(*r>>4) & 07777]).s_addr;
			*t =+ n;
			}
		break;
		}

	if(*r & 01)
		*t =+ cur_reloc;
	if(debflg > 1 && *r)
		printf("rld %o ==> %o\n",*r,*t);
	++t;
	++r;
	}
}


/*
 * routine to examine a unix obj and indicate if
 * it is to be included in the object module. 
 * this is done by going through the unix symbol table 
 * looking each globl defined entry up in the linker
 * symbol table. 
 */
ulibrary()
{
register struct symbol *s;
int i;

defining = 0;		/* inside library */
gettxt(&u,sizeof u);
if(u.a_rflags!=0)
	err("no rld info");
if(u.a_ssize==0)
	err("no symtab");
gseek(u.a_tsize+u.a_dsize);		/* seek to symbol table */
gseek(u.a_tsize+u.a_dsize);		/* seek to symbol table */


s_count = u.a_ssize/ sizeof sym;

for (i=0; i<s_count; ++i)
	{
	gettxt(&sym, sizeof sym);
	switch(sym.u_flags)
		{
	case UABS:	/* globl abs */
	case UTEXT:
	case UDATA:
	case UBSS:
		if(findsymbol(sym.u_name)!=0)
			{	/* seek to end of the file */
			gseek((s_count - ++i)*sizeof sym);
			return(1);		/* got one */
		}
			}
	}
gseek(0);	/* arrange to know we are at the end of the file */
return(0);
}
