#include "lisp.h"
/*		Copyright 1976 by Bill Webb.	 	 */


/*
 * Standard lisp forms that are subrs.
 * all form arguments are eval'd before being 
 * passed. arguments are passed in a vector.
 * "cnt" = number of arguments actually passwd.
 * "args" = vector of arguments.
 * element n = n'th argument.
 */

struct { int INTEG; };
#define	C__R(a,b) a(cnt,args) struct cons *args[]; { return(ARG1 -> b); }

C__R(_caar,car->car)
C__R(_cadr,cdr->car)
C__R(_cdar,car->cdr)
C__R(_cddr,cdr->cdr)

C__R(_caaar,car->car->car)
C__R(_caadr,cdr->car->car)
C__R(_cadar,car->cdr->car)
C__R(_caddr,cdr->cdr->car)
C__R(_cdaar,car->car->cdr)
C__R(_cdadr,cdr->car->cdr)
C__R(_cddar,car->cdr->cdr)
C__R(_cdddr,cdr->cdr->cdr)

C__R(_caaaar,car->car->car->car)
C__R(_caaadr,cdr->car->car->car)
C__R(_caadar,car->cdr->car->car)
C__R(_caaddr,cdr->cdr->car->car)
C__R(_cadaar,car->car->cdr->car)
C__R(_cadadr,cdr->car->cdr->car)
C__R(_caddar,car->cdr->cdr->car)
C__R(_cadddr,cdr->cdr->cdr->car)

C__R(_cdaaar,car->car->car->cdr)
C__R(_cdaadr,cdr->car->car->cdr)
C__R(_cdadar,car->cdr->car->cdr)
C__R(_cdaddr,cdr->cdr->car->cdr)
C__R(_cddaar,car->car->cdr->cdr)
C__R(_cddadr,cdr->car->cdr->cdr)
C__R(_cdddar,car->cdr->cdr->cdr)
C__R(_cddddr,cdr->cdr->cdr->cdr)

SUBR(_eq)					/* _eq */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;
return(BOOL(EQATOM(a,b)));
}

SUBR(_neq)					/* _neq	 */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;
return(BOOL(!EQATOM(a,b)));
}

SUBR(_equal)					/* _equal */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;

return(BOOL(EQUAL(a,b)));
}


SUBR(_oblist)					/* _oblist */
{
return(copylist(oblist));
}

SUBR(_unix)					/* _unix */
{
int status;
register pid;

CHKLIT(ARG1);
if((pid = fork()) == 0)
	{
	execl("/bin/sh","sh","-c",ARG1->pname,0);
	printf("no sh\n");
	exit(1);
	}
signal(2,1);
while (wait(&status) != pid)
	;
setsigs();
return(nil);
}

SUBR(_atom)					/* _atom */
{
return(ATOMP(ARG1) ? t : nil);
}

SUBR(_not)					/* _not	 */
{
return(ARG1 == nil ? t : nil);
}

SUBR(_nump)					/* _nump */
{
return(NUMP(ARG1) ? t : nil);
}

SUBR(_listp)					/* _listp */
{
return(ARG1->type == CONSTYPE ? t : nil);
}

SUBR(_undefp)					/* _undefp */
{
register struct cons *p;
p = ARG1;
if(ATOMP(p) && p->car == undef)
	{
	if(cnt > 1)
		p->car = ARG2;
	return(t);
	}
return(nil);
}

SUBR(_tailp)					/* _tailp */
{
register struct cons *s1, *s2;

s1 = ARG1;
s2 = ARG2;
while (s2 != nil)
	{
	if(s1 == s2)
		return(t);
	s2 = s2->cdr;
	}
return(nil);
}



SUBR(_exit)					/* _exit */
{
exit();
}

SUBR(_rplaca)					/* _rplaca */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;
CHKNOTNUM(a);
a->car = b;
return(a);
}

SUBR(_rplacd)					/* _rplacd */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;
CHKNOTNUM(a);
a->cdr = b;
return(a);
}


SUBR(_print)					/* _print */
{
register int i;

i = cnt > 2 ? integer(ARG3) : NORMAL;
return(print(ARG1,i));
}

SUBR(_terpri)					/* _terpri */
{
return(terpri());
}

SUBR(_prin1)					/* _prin1 */
{
register struct cons *p;
register int i;

p = ARG1;
i = cnt > 2 ? integer(ARG3) : NORMAL;
prin(p,i,MAXINT);
if(!(i & NOSPACE))
	putchar(' ');
return(p);
}


SUBR(_cons)					/* _cons */
{
return(cons(ARG1,ARG2));
}

SUBR(_eval)					/* _eval */
{
return(eval(ARG1));
}

SUBR(_list)					/* _list */
{
register struct cons *p;

p = nil;
while (cnt > 0)
	p = cons(args[--cnt],p);
return(p);
}

SUBR(_car)					/* _car	 */
{
return(ARG1->car);
}

SUBR(_cdr)					/* _cdr	 */
{
return(ARG1->cdr);
}

SUBR(_terread)					/* _terread */
{
return(terread());
}

SUBR(_read)					/* _read */
{
return(rd());
}

SUBR(_mkatom)					/* _mkatom */
{
register struct cons *s;
register char *q, *p;

p = buffer;
while (--cnt >= 0)
	{
	s = *args++;
	if(!ATOMP(s))
		error("not atomic");
	q = s->pname;
	while (*q)
		*p++ = *q++;
	}
*p++ = 0;
return(makeatom(undef,nil,buffer));
}


SUBR(_unionq)					/* _unionq */
{
register struct cons *p, *s;

s = nil;
SCANLIST(ARG1,p)
	{
	if(!memq(p->car,s))
		s = cons(p->car,s);
	}
SCANLIST(ARG2,p)
	{
	if(!memq(p->car,s))
		s = cons(p->car,s);
	}
return(drev(s));
}

SUBR(_union)					/* _union */
{
register struct cons *p, *s;

s = nil;
SCANLIST(ARG1,p)
	{
	if(!member(p->car,s))
		s = cons(p->car,s);
	}
SCANLIST(ARG2,p)
	{
	if(!memq(p->car,s))
		s = cons(p->car,s);
	}
return(drev(s));
}


SUBR(_member)					/* _member */
{
register struct cons *p;
if( !(p = member(ARG1,ARG2)) )
	p = cnt > 2 ? ARG3 : nil;
return(p);
}

SUBR(_memq)					/* _memq */
{
register struct cons *p;
if( !(p = memq(ARG1,ARG2)) )
	p = cnt > 2 ? ARG3 : nil;
return(p);
}


SUBR(_dreverse)					/* _dreverse */
{
return(drev(ARG1));
}

SUBR(_nconc)					/* _nconc */
{
register struct cons *p;
register int i;

p = nil;
for (i=0; i<cnt; ++i)
	p = nconc(p,*args++);
return(p);
}


SUBR(_info)					/* _info */
{
register int l;
extern ldivr;

printf("info: %l cons cell%s %l atom%s %l number%s\n",
	cons_cnt,pl(cons_cnt), atom_cnt,pl(atom_cnt), num_cnt,pl(num_cnt));
l = ldiv(0,memnext-membottom,2048);
if(ldivr)
	++l;
printf("memory used: %d k words.\n",l);
return(nil);
}

SUBR(_reverse)					/* _reverse */
{
register struct cons *p, *q;

q = nil;
SCANLIST(ARG1,p)
	q = cons(p->car,q);
return(q);
}

SUBR(_copy)					/* _copy */
{
register struct cons *p;

p = ARG1;
if(ATOMP(p))
	return(newatom(p->car,p->cdr,p->pname));
return(copylist(p));
}

SUBR(_explode)					/* _explode */
{
register struct cons *p, *q;
register char *s;
char name[2];
struct cons c;

q = &c;
q->cdr = nil;

p = ARG1;
CHKATOM(p);
name[1] = 0;
for (s = p->pname; *s; )
	{
	name[0] = *s++;
	q = q->cdr = cons(makeatom(undef,nil,name),nil);
	}
return(c.cdr);
}

SUBR(_apply)					/* _apply */
{
/*
 * apply arg1 (=fn) to arg2 (= list of arguments for fn).
 */
register int i;
register char **s;
register struct cons *p;

i = 0;
s = evalsp;
SCANLIST(ARG2,p)
	{
	*evalsp++ = p->car;
	++i;
	}
return(apply(ARG1,i,s));
}


SUBR(_apply1)					/* _apply1 */
{
/*
 * apply arg1 (= fn) to arg2 ... argn (= arguments to fn).
 */
return(apply(ARG1,cnt-1,args+1));
}

SUBR(_clear)					/* _clear */
{
init();
reset();
}

SUBR(_progn)					/* _progn */
{
return(args[cnt-1]);
}

SUBR(_gensym)					/* _gensym */
{
register char *p;

p = buffer;
*p++ = 'g';
p = outint(p,++gen_cnt);
*p++ = 0;
return(newatom(undef,nil,buffer));
}

SUBR(_getfn)						/* _getfn */
{
int i;

return(getfn(ARG1,&i));
}

SUBR(_find)						/* _find */
{
int n;
register struct cons *p;

n = (cnt > 2) ? integer(ARG3) : 1;
p = find(ARG1, ARG2, &n);
return( p ? p : nil);
}

SUBR(_nth)						/* _nth	 */
{
register struct cons *p;
register int n;

n = integer(ARG2);
p = ARG1;
return(n <= 0 ? last(p) : nth(p,n));
}

SUBR(_dsubst)						/* _dsubst */
{
register struct cons *p;

SCANLIST(ARG1,p)
	{
	if(EQUAL(p->car,ARG2))
		p->car = ARG3;
	}
return(ARG1);
}

SUBR(_intersect)					/* _intersect */
{
/*
 * return intersection of two lists. 
 */
register struct cons *p, *q, *l;
struct cons c;

l = &c;
l->cdr = nil;
SCANLIST(ARG1,p)
	{
	SCANLIST(ARG2,q)
		if(EQUAL(p->car,q->car))
			{
			l = l->cdr = cons(p->car,nil);
			break;
			}
	}
return(c.cdr);
}

SUBR(_intq)						/* _intq */
{
register struct cons *p, *q, *l;
struct cons c;

l = &c;
l->cdr = nil;
SCANLIST(ARG1,p)
	{
	SCANLIST(ARG2,q)
		if(EQATOM(p->car,q->car))
			{
			l = l->cdr = cons(p->car,nil);
			break;
			}
	}
return(c.cdr);
}
SUBR(_exclude)						/* _exclude */
{
register struct cons *p, *q, *l;
struct cons c;

l = &c;
l->cdr = nil;
SCANLIST(ARG2,p)
	{
	SCANLIST(ARG1,q)
		if((EQUAL(p->car,q->car)))
			goto out;
	l = l->cdr = cons(p->car,nil);
out:
	}
return(c.cdr);
}

SUBR(_exq)						/* _exq	 */
{
register struct cons *p, *q, *l;
struct cons c;

l = &c;
l->cdr = nil;
SCANLIST(ARG2,p)
	{
	SCANLIST(ARG1,q)
		if((EQATOM(p->car,q->car)))
			goto out;
	l = l->cdr = cons(p->car,nil);
out:
	}
return(c.cdr);
}

SUBR(_eqname)						/* _eqname */
{
register struct cons *a, *b;

a = ARG1;
b = ARG2;
return(BOOL( LITATOM(a) && LITATOM(b) && equal(a->pname,b->pname) ));
}

SUBR(_last)						/* _last */
{
return(last(ARG1));
}

SUBR(_address)						/* _address */
{
return(makenumber(ARG1.INTEG + 0.0,INT));
}

SUBR(_prog1)						/* _prog1 */
{
return(ARG1);
}

SUBR(_delete)						/* _delete */
{
register int n;
register struct cons *p, *q;

n = cnt > 2 ? integer(ARG3) : 32767;
q = 0;
SCANLIST(ARG2,p)
	{
	if(EQUAL(p->car,ARG1))
		{
		if(q == 0)
			ARG2 = p->cdr;
		else
			q->cdr = p->cdr;
		if(--n <= 0)
			break;
		}
	else
		q = p;
	}
return(ARG2);
}


SUBR(_delq)						/* _delq */
{
register int n;
register struct cons *p, *q;

n = cnt > 2 ? integer(ARG3) : 32767;
q = 0;
SCANLIST(ARG2,p)
	{
	if(EQATOM(p->car,ARG1))
		{
		if(q == 0)
			ARG2 = p->cdr;
		else
			q->cdr = p->cdr;
		if(--n <= 0)
			break;
		}
	else
		q = p;
	}
return(ARG2);
}


SUBR(_remove)						/* _remove */
{
ARG2 = _copy(1,args+1);
return(_delete(cnt,args));
}

SUBR(_append)					/* _append */
{
register struct cons *p;

p = nil;
while (--cnt >= 0)
	p = nconc(p,copylist(*args++));
return(p);
}

SUBR(_app1)					/* _append1 */
{
register struct cons *p;
register struct cons *q;

p = copylist(ARG1);
q = _list(cnt-1,args+1);
return(nconc(p,q));
}

SUBR(_appstar)					/* _append* */
{
register struct cons *p;

p = nil;
while (--cnt > 0)
	p = nconc(p,copylist(*args++));
p = nconc(p,*args++);
return(p);
}

SUBR(_evlis)					/* _evlis */
{
register int i;

for (i=0; i<cnt; ++i)
	args[i] = eval(args[i]);
return(_list(cnt,args));
}
