#include <stdio.h>
/*			Copyright 1982 by Bill Webb.	 		*/
#include <ctype.h>
#include "data.h"


LINENUMBER lnritem();
LINENUMBER getlnr();
LINENUMBER scanfile();
int gotlnr;

char gen_date[];

edit()
/*
 * read and execute commands from the
 * terminal.
 */
{
	char *c;
	register char *startbuf;

	for(;;) {
		printf(prompt,line);
		flush();
		if (getln(tmpbuf, TSIZ, stdin) == EOF)
			{
			rmtemp();
			exit(0);
			}
		for(startbuf=tmpbuf; isspace(*startbuf); startbuf++)
			;
		c = startbuf;
		lineno = getlnr(&c);
		if (*c == 0)
			{
			if (!gotlnr)
				lineno = line+1;
			c = cmd;
			}
		if (*c == ',')
			Warn("sorry, line ranges not implemented");
		tracef(("line=%D action=%c\n",lineno, *c));
		switch (*c) {
			case 'i':
				insert(lineno);
				break;
			case 'a':
				insert(lineno+1);
				break;
			case '!':
				system(c+1);
				break;
			case 'h':
				if (strncmp(c,"hel",3) == 0)
					{
					sprintf(tmpbuf,"help %s",progname);
					system(tmpbuf);
					}
				else
					headers();
				break;
			case 'l': 
				list();
				break;
			case 'u':
				if (!undo())
				break;
			case 'p': 
				print();
				break;
			case 'q':
				quit();
				break;
			case 'D':
				debug = !debug;
				break;
			case 'd':
				if(!(getrec(lineno,FATAL))) /* getline */
					continue;
				delete();
				break;
			case '=':
				printf("%D\n",lineno);
				break;
			case 'f':
				fcmd();
				break;
			case 'w':
				if (!gotlnr)
					{
					printf("explicit line number requred for w[rite] command\n");
					continue;
					}
				if(!(getrec(lineno,FATAL))) /* getline */
					continue;
				writecmd(c+1);
				break;
			case 'e':
				if(!(getrec(lineno,FATAL))) /* getline */
					continue;
				tracef(("tmpbuf(p)=%s\n",tmpbuf));
				ed_record("/bin/edit","edit");
				break;
			case 'v':
				if (strncmp(c,"ve",2) == 0)
					{
					printf("%s: Version 1.0 %s\n",progname,gen_date);
					break;
					}
				if(!(getrec(lineno,FATAL))) /* getline */
					continue;
				tracef(("tmpbuf(p)=%s\n",tmpbuf));
				ed_record("/bin/vi","vi");
				break;
			case 0:
			case ' ':
				continue;

			default:
				printf("invalid command - for help type 'help'\n");
				break;
		}
	}
}

fcmd()
{
prfile();
printf(" line %D of %D --%D%%--\n",
	lineno,nrecs,nrecs == 0 ? 0L : lineno*100/nrecs);
}

list()
/*
 * print the given record - no expansion
 */
{

	if(!(getrec(lineno,FATAL))) /* getline */
		return;
	fputs(buf,stdout);
}

print()
/*
 * print the given record.
 */
{

	if(!(getrec(lineno,FATAL))) /* getline */
		return;
	exp_rec(buf,outbuf,false);
	if (vflg)
		printf("Record %D\n",line);
	fputs(outbuf,stdout);
}

quit()
{
	rmtemp();
	if(!modflag) {
		printf("No changes made\n");
		if (uflg)
			rmindex();
		exit(0);
	}
	printf("Write the data back? (y/n)?");
	flush();
	if(fgets(tmpbuf,sizeof tmpbuf,stdin) && *tmpbuf == 'y')
		{
		writerecs();
		rmindex();
		if (modfname[0] && unlink(modfname) < 0)
			err("can't unlink %s",modfname);
		}
	exit(0);
}

rmindex()
{
	if(unlink(indexfname))
		err("can't unlink %s",indexfname);
}


undo()
{
if (undo_cmd == NULL || undo_cmd == ' ')
	{ printf("Nothing to undo\n"); return(false); }
line = undo_line;
u_index(undo_pos);
printf("undo: %D%c\n",undo_line,undo_cmd);
undo_cmd = NULL;
return(true);
}

save_undo(cmd)
{
tracef(("save_undo '%c' %D %D\n",cmd == 0 ? ' ' : cmd,line,offset));
undo_cmd = cmd;
undo_line = line;
undo_pos = offset;
}


LINENUMBER getlnr(ptr) char **ptr;
{
	LINENUMBER lineno;

	gotlnr = false;
	lineno = lnritem(ptr,line);
	for (;;)
		{
		switch(*(*ptr)++)
			{
		case '+':
			lineno += lnritem(ptr,(LINENUMBER) 1);
			break;
		case '-':
			lineno -= lnritem(ptr,(LINENUMBER) 1);
			break;
		default:
			--(*ptr);
			return(lineno);
			}
		}
}

LINENUMBER lnritem(ptr,def) char **ptr; LINENUMBER def;
{
	LINENUMBER lineno;
	register int c;

	switch(c = *(*ptr))
		{
	case '?':
	case '/':
		lineno = scanfile(ptr);
		break;
	case '.':
		++(*ptr);
		lineno = line;
		break;
	case '$':
		++(*ptr);
		lineno = nrecs;
		break;
	default:
		if (isdigit(c))
			{
			if (pscanf(ptr,"%D",&lineno) != 1)
				Warn("bad line number");
			}
		else
			return(def);
		break;
		}
gotlnr = true;
return(lineno);
}

/* VARARGS 1 */
Warn(fmt,d1,d2,d3,d4) char *fmt;
{
printf(fmt,d1,d2,d3,d4);
printf("\n");
leave(fmt);
}

LINENUMBER scanfile(ptr) char **ptr;
{
register char *p = *ptr;
char *start = p;
register delim = *p++;
int forwards = delim == '/';
LINENUMBER saveline = line,
	ltemp,
	cnt;
static have_re;

while (*p && (*p != delim || p[-1] == '\\'))
	++p;
if (*p == delim)
	*p++ = 0;
*ptr = p;		/* update the pointer to end of pattern */
p = start+1;
if (*p)
	{
	tracef(("compile pattern '%s'\n",start));
	compile(p);		/* compile the expression */
	have_re = true;
	}
else if (!have_re)
	Warn("No previous pattern");
for (cnt=0; cnt < nrecs; ++cnt)
	{
	if (forwards)
		{
		if (++line > nrecs)
			line = 1;
		}
	else
		{
		if (--line <= 0)
			line = nrecs;
		}
	if((getrec(line,NOTFATAL)))	/* getline */
		{
		tracef(("execute line %D\n",line));
		if (execute(buf))
			{
			ltemp = line;
			line = saveline;
			tracef(("found pattern %s at line %D\n",start,line));

			return(ltemp);
			}
		}
	}
line = saveline;
Warn("Pattern not found");
/* NOTREACHED */
}

#include <stat.h>

writecmd(ptr) register char *ptr;
{
struct stat statb;
register int flag = 0;
register char *how = "w";
register FILE *f;

while (isalpha(*ptr))
	++ptr;
while (isspace(*ptr))
	++ptr;
if (*ptr == '>')
	{
	++ptr;
	if (*ptr != '>')
		Warn(">> is required to append to file");
	how = "a";
	++ptr;
	}
if (*ptr == '!')
	flag = *ptr++;
while (isspace(*ptr))
	++ptr;
if (*how == 'w' && !flag && stat(ptr,&statb) >= 0
		&& (statb.s_flags&IFMT) == 0)
	Warn("file exists; use w! to overwrite or w>> to append");
if ((f = fopen(ptr,how)) == (FILE *) NULL)
	Warn("File '%s' - cannot write",ptr);
fputs(buf,f);
fclose(f);
printf("\"%s\" %d characters\n",ptr,strlen(buf));
}
