#include "data.h"
/*			Copyright 1982 by Bill Webb.	 		*/

char *getr_nonline = "line not in file\n";


char *getrec(number,fatal) 
LINENUMBER number;
/*
 * given line number "number" check for validity and then
 * call getnrec to return the actual line.
 */
{
	POSITION bytes_displ;

	tracef(("entering getrec with number=%D\n",number));

	if (number < 1)
		{
		if (fatal)
			printf("line number < 1\n");
		return(NIL);
		}
	if (number > nrecs)
		{
		if (fatal)
			printf("line number > %D\n",nrecs);
		return(NIL);
		}

	line = number;
	fseek(index, line * sizeof(LINENUMBER), 0);

		/* read byte displ */
	if(!fread((char *)&bytes_displ, sizeof(LINENUMBER), 1, index)) {
		if (fatal)
			printf(getr_nonline);
		return(NIL);
	}
	return(ngetrec(bytes_displ,NOFS));

}

char *ngetrec(bytes_displ,sep) char sep;
/*
 * read the record at "bytes_displ" in the appropriate file.
 * "sep" is sometimes the field separator character.
 */
POSITION bytes_displ;
{
	register FILE *data;
	register char *f;

	tracef(("ngetrec %D sep=%s\n",bytes_displ,outchar(sep)));
					/* seek index for byte displacement */

	offset = bytes_displ;
	if (offset == Deleted)
		{
		printf("Line %D deleted\n",line);
		return(NIL);
		}
	tracef(("bytes displacement of record=%ld\n", bytes_displ));

	if (bytes_displ >= 0)	/* line in the data file */
		{
		data = datafile;
		f = datafname;
		}

	else {	/* line in the modification file */
		open_modfile();
		data = modfile;
		bytes_displ *= -1;	/* make lineno pos for modfile lookup */
		f = modfname;
	}


		/* use byte displ to seek data record */
	tracef(("read file %s offset %D\n",f,bytes_displ));
	fseek(data, bytes_displ, 0);
	if (ferror(data))
		err("%s: seek error",f);

	if (!(fgetrec(buf,bufsiz,data,sep))) {	/* read data record */
		if (ferror(data))
			err("%s: read error",f);
		printf(getr_nonline);
		return(NIL);
	}
	return(buf);
}

char *fgetrec(buf,length,file,sep) char *buf; FILE *file;
/*
 * pick up the next record in file "file", and place into
 * "buff" of length "length".
 * terminate on recsep or "sep", which ever comes first.
 * place a NULL into the buffer after the data record.
 * "sep" is NOFS except for call from "headers".
 */
{
	register int c;
	register int len = length;
	register char *b = buf;

	while ((c = getc(file)) != EOF)
		{
		if (--len <= 0)
			err("record more than %d bytes",length);
		*b++ = c;
		if (c == recsep || c == sep)
			{
			if (aflg && !(c == recsep && (b == buf+1 || b[-2] == fs)))
				continue;	/* for asa type files */
			*b = 0;
			tracef(("got record, length = %d\n",len));
			return(buf);
			}
		}
	if (len == length)
		return(NIL);	/* nothing there */
	*b++ = recsep;
	*b = 0;
	return(buf);
}

char *outchar(sep)
{
static out[10];

switch (sep)
	{
case '\t':
	return("'\\t'");
case '\r':
	return("'\\r'");
case NOFS:
	return("none");
case '\n':
	return("'\\n'");
default:
	if (sep < 040)
		sprintf(out,"'^%c'",sep+'@');
	else
		sprintf(out,"'%c'",sep);
	}
return(out);
}
