#include <stdio.h>
/*			Copyright 1982 by Bill Webb.	 		*/
#include "data.h"
#include <assert.h>
#include <signal.h>

char *usage="usage: %s [-Fx -Tx -Px -m index -hn ... -Hfmt -n] file";

#define	WRITE	2	/* write access mode */

char	indexflag,
	makeflag;

int edit();
int attn();
char *sbrk();

main(argc,argv)
int argc;
char *argv[];
{
	register char *argp;
	int i;

	progname=argv[0];
	setout();
	for(i=1; i < argc; i++) {
		argp = argv[i];
		if (*argp == '-')
			doarg(argp,&i,argc,argv);
		else
			dofile(argp);

	}
	
	if(!datafile)
		err(usage,progname);

	init();

	for (;;)
		{
		signal(SIGINT,attn);
		enter(edit,0);
		}
}

init()
/*
 * initialize:
 * if existing index then open it for use
 * otherwise make appropriate index file.
 */
{
	buf_init();
	if(makeflag) {
		mkindex(datafile, index);
		exit(0);
	}

	if (index) 
		rdindex(datafile,index);
	else
		{	/* make a default index */
		sprintf(indexfname,"%s%s",ind_pfx,basename(datafname));
		if (modtime(datafname) > modtime(indexfname))
			{	/* need to build index */
			tracef(("opening indexfile=%s for write\n", indexfname));

				/* stream for writing line index */
			windex = myopen(windex, indexfname, "w");

				/* make index */
			mkindex(datafile, windex);

				/* flush the index buf: a whole index is needed */
			fflush(windex);
				/* stream for reading line index */
			index = myopen(index, indexfname, "r");
			}
		else
			{
			tracef(("using old index file %s\n",indexfname));
				/* stream for reading line index */
			index = myopen(index, indexfname, "r");
				/* stream for writing line index */
			windex = myopen(windex, indexfname, "a");

			rdindex(datafile,index);
			}

	}
	if (modflag)
		open_modfile();

}

attn()
{
printf("attn...\n");
leave("attn");
}

doarg(argp,iptr,argc,argv) register char *argp; int *iptr; char **argv;
{
	register int i = *iptr;

	tracef(("process arg %s\n",argp));
	++argp;		/* ignore - */
	switch(*argp)
		{
	case 'a':		/* for asa - style files */
		++aflg;
		break;
	case 'u':		/* unlink index file after use */
		++uflg;
		break;
	case 'p':
		progname = strsave(++argp);
		break;
	case 'x':		/* set prefixes */
		ind_pfx = strsave(++argp);
		break;
	case 'y':		/* set modify prefix */
		mod_pfx = strsave(++argp);
		break;
	case 'z':		/* set tempfile prefix */
		tmp_pfx = strsave(++argp);
		break;
	case 'd':
		datafname = strsave(argv[++i]);
		dofile(datafname);
		break;
	case 'f':
		doargfile(argv[++i]);
		break;
	case 'v':		/* verbose */
		++vflg;
		break;
	case 'D':		/* debug flag */
		debug = true;
		break;
	case 'n':		/* use numeric field headers */
		++nflg;
		break;
	case 'H':
		hfmt = strsave(++argp);	/* format for heading */
		break;
	case 'M':
		++mflg;		/* headers must match */
		break;
	case 'l':		/* line length */
		bufsiz = atoi(++argp);
		if (bufsiz < BUFSIZ)
			bufsiz = BUFSIZ;
		break;
	case 'h':		/* specify headers */
		++hflg;
		getheaders(argv[++i]);
		break;

	case 'm':		/* only mk an index */
		makeflag++;
		copy(indexfname,argv[++i]);
		index = myopen(index,indexfname, "w");
		break;

	case 'I':	/* inhibit update in place */
		++Iflg;
		break;

	case 'i':		/* use an extant index */
		indexflag++;
		copy(indexfname,argv[++i]);
		index = myopen(index,indexfname, "r");
		break;

	case 'F':		/* field separator */
		fs = cmdchar(++argp);
		break;
	case 'R':		/* record separator */
		recsep = cmdchar(++argp);
		if(!recsep)
			err("Record separator is null");
		break;
	case 'C':		/* default command */
		cmd = ++argp;
		break;
	case 'P':		/* prompt string */
		prompt = ++argp;
		break;
	default:
		err("invalid switch %s",argp-1);
		break;
		}
	*iptr = i;
	if (i > argc)
		err("insufficient arguments for switch %s",argp-1);
}

dofile(argp) char *argp;
{		 /* data file name */

	datafname = argp;
	datafile=myopen(datafile, datafname, "r");
	readonly = access(datafname,WRITE) == -1;
}

getheaders(ptr) register char *ptr;
/*
 * take the header string and split it up on the current
 * field separator character.
 */
{
register char *q;

while (*ptr)
	{
	q = tmpbuf;
	while (*ptr && (*q = *ptr++) != fs)
		q++;
	*q = 0;
	if (tmpbuf[0])
		header[hcnt++] = strsave(tmpbuf);	/* must be non-null */
	}
}

buf_init()
{
ASSERT(bufsiz * 2 > 0);
if ((buf = sbrk(bufsiz*2)) == (char *) -1)
	err("can't allocate %d bytes buffer space",bufsiz);
outbuf = buf+bufsiz;
}

doargfile(file) char *file;
{
	register FILE *f = myopen((FILE *) NULL,file,"r");
	char *argv[3];
	int l, argc, i;
	register char *p;
	char *b = calloc(BUFSIZ,1);

	if (b == NULL)
		err("couldn't allocate temp buffer");
	for (line=1; fgets(b,BUFSIZ,f); ++line)
		{
		if (l = strlen(b))
			b[--l] = 0;
		if (b[0] != '-')
			err("%s - missing",file);
		argv[0] = file;
		argv[1] = b;
		argc = 2;
		if (p = any(b," "))
			{
			*p++ = 0;
			argv[2] = p;
			++argc;
			}
		i = 1;
		doarg(b,&i,argc,argv);
		}
	fclose(f);
	cfree(b);
}

char *basename(path) register char *path;
{
/*
 * get the base name of a path name, e.g.
 * strip off any leading directories.
 */
register char *p = path;

while (*path)
	if (*path++ == '/')
		p = path;
return(p);
}

int cmdchar(argp) register char *argp;
{
int c = *argp++;
char *p = argp;

if (c == '\\')
	{
	switch(*argp++)
		{
	case 'n':
		c = '\n';
		break;
	case 't':
		c = '\t';
		break;
	case 'r':
		c = '\r';
		break;
	default:
		pscanf(&p,"%o",&c);
		argp = p;
		}
	}
else if (c == '^')
	c = *argp++ & 037;
else if (c == 0)
	--argp;
if (*argp)
	err("single character required");
return(c);
}
