#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	EQU	0

struct symbol *lastsym symbols;
int base 10;		/* numeric conversion base */

struct buf 
{
int fildes;
int nleft;
char *nextp;
char buffer[512];
};

main(argc,argv)
char **argv;
{
register char *argp;

initops();
--argc;
++argv;
while (argc > 0 && *(argp = *argv)=='-')
	{
	--argc;
	++argv;
	while (*argp)
		switch(*argp++)
			{
		case 't':
			++tflg;
			break;
		case 'o':
			++oflg;
			break;
		case 'u':
			++uflg;
			break;
		case 'g':
			++gflg;
			break;
		case 'l':		/* list source */
			++lflg;
			break;
		case 's':		/* symbol table */
			++sflg;
			break;
			}
	}

if(argc > 0)
	{
	close(0);
	argp = *argv++;
	if(open(argp,0) < 0)
		err("can't open %s",argp);
	}
init();
asm();
flush();
}

asm()
{

pass(1);
if(errcnt)
	return;
while (again)
	{
	again = 0;
	pass(++passnum);
	if(errcnt)
		return;
	}
++lastpass;
pass(++passnum);

if(sflg)
	dump();
}

pass(n)
{
extern fin;
gotend = 0;
passnum = n;
objseek(0);
if(tflg)
	printf("pass %d\n",passnum);
flush();
seek(0,0,0);
(&fin)->nleft = 0;
curpc = 0;
linecnt = 0;
lastcnt = 0;
outptr = outbuff;
setexit();
if(linecnt)
	print();
while (readline())
	{
	stmt();
	print();
	}
objend();
}




stmt()
{
register int n;

dot = curpc;
outptr = outbuff;
if(dot > maxdot)
	maxdot = dot;
ptr = line;
while (*ptr >= '0' && *ptr <= '9')
	++ptr;				/* ignore seq field */

switch(ptr[0])
	{
case '*':		/* comment */
	return;

case 0:
	return;		/* null line */

case ' ':
case TAB:
	label[0] = 0;
	break;
default:
	getsym(label);
	break;
	}

if(ignsp() == 0)
	{
	if(label[0])
		dolabel();
	return;
	}
getop();
n = op->o_type;
if(label[0] && n!=EQU)
	dolabel();
(*oprtns[n])(opcode);
}


warn(s,d1)
char *s;
{
++errcnt;
printf("%4d: ",linecnt);
printf(s,d1);
putchar('\n');
}

error(s,d1)
char *s;
{
warn(s,d1);
reset();
}




dolabel()
{
register struct symbol *s;

s = lookup(label);
if(passnum == 1 && s->s_type != UNDEF)
	{
	warn("label %s multiply defined",label);
	}
if(passnum > 1 && s->s_value != dot)
	++again;
s->s_type = LABEL;
s->s_value = dot;
}


init()
{
extern fin;
extern fout;

fin = dup(0);
fout = dup(1);
}
