#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	LIMM	(01000 >> 8)

int (*oprtns[])()
{
&equ,
&dual,
&opr,
&mem,
&ctl,
&sgl,
&acc,
&br,
&jmp,
&arg,
&sta,
&stx,
1,
1,
1,
0};

opr()
{
putbyte(opcode);
}


ctl()
{
register int n;

switch (opcode)
	{
case 1:		/* org */
	curpc = expr();
	if(exprtype)
		{
		curpc = dot;
		error("org address undefined");
		}
	objseek(curpc);
	break;
case 2:
	fcb();
	break;
case 0:
	++gotend;
	break;

case 3:		/* rmb */
	n = expr();
	if(n < 0)
		error("rmb argument < 0");
	prtword(n);
	curpc =+ n ;
	objseek(curpc);
	break;
case 4:		/* fcc */
	fcc();
	break;

case 5:		/* fdb */
	fdb();
	break;
	}
}

br()
{
register int n;

putbyte(opcode);
n = expr()-dot-2;
if(n < -128 || n > 127)
	if(lastpass)
		warn("branch outside range");
putbyte(n);
}

acc()
{
putbyte(opcode+abreg(1));
}


fcb()
{
for (EVER)
	{
	putbyte(expr());
	if(*ptr++ != ',')
		break;
	print();
	}
}

fdb()
{
for (EVER)
	{
	putword(expr());
	if(*ptr++ != ',')
		break;
	print();
	}
}

equ()
{
register struct symbol *s;
register int n;

s = lookup(label);
ignsp();
s->s_value = n = expr();
s->s_type = EXPR;
prtword(n);
}

dual()
{
register int ab;

ab = abreg(1) * 0100;
memarg(ab + opcode);
}



arg()
{
/*
 * argument may be either a or b or memory (dir or ext).
 */
register int n;

if((n = abreg(0)) < 0)
	{
	mem(opcode+040);
	}
else
	putbyte(opcode + n * 020);
}



stx()
{
	outmem(opcode-020);
}

jmp()
{
register int n;

	n = expr();
	if(*ptr++ == ',' && *ptr++ == 'x')
		{
		putbyte(opcode);
		putbyte(n);
		return;
		}
	putbyte(opcode+020);
	putword(n);
}

sta()
{

	opcode =- 020;
	dual();
}



sgl()
{
memarg(opcode);
}



mem(code)
{
/*
 * operand must be in memory (imm, dir, ext or ind).
 */
memarg(opcode);
}

memarg(opbase)
{
register int c;

c = ignsp();
if(c == '#')
	{
	++ptr;
	putbyte(opbase+IMM);
	if(op->o_flags&LIMM)
		putword(expr());
	else
		putbyte(expr());
	return;
	}
outmem(opbase);
}

outmem(opbase)
{
/*
 * process arguments suitable for output to memory.
 * i.e. DIR, EXT, and IND. 
 */
register int n;

n = expr();
if(*ptr++ == ',' && *ptr++ == 'x')
	{
	putbyte(opbase+IND);
	putbyte(n);
	return;
	}
if(op->o_flags&LONG || n < 0 || n > 255)
	{
	again =+ exprtype;		/* remember if was undefined */
	putbyte(opbase+EXT);
	putword(n);
	}
else
	{
	putbyte(opbase+DIR);
	putbyte(n);
	}
}

abreg(flag)
{
/*
 * test for an a or b register specification.
 * if flag is on then it must be found.
 */
register int c;

c = ignsp();
if(c == 'a' || c == 'b')
	{
	++ptr;
	if(delim())
		return(c-'a');
	--ptr;		/* back up to point at the a/b */
	}
if(flag)
	error("invalid register");
return(-1);
}


fcc()
{
register int n;
register int c;

c = ignsp();
if(DIGIT)
	{
	n = integer(10);
	if(*ptr++ != ',')
		error("missing comma");
	while (--n >= 0)
		if (c = *ptr++)
			{
			putuc(c);
			print();
			noprint = gflg;
			}
		else
			error("bad count");
	}
else
	{
	++ptr;
	while ((n = *ptr++) && n!=c)
		{
		putuc(n);
		print();
		noprint = gflg;
		}
	if(n != c)
		error("missing delimeter");
	}
if(!delim())
	error("bad syntax");
++noprint;		/* already printed line */
}

putuc(c)
{
if(uflg && c >= 'a' && c <= 'z')
	c =- 'a' - 'A';
putbyte(c);
}
