#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

putbyte(n)
{
n =& 0377;
++curpc;
prtbyte(n);
if(lastpass)
	objbyte(n);
}

prtbyte(n)
{
if(!lastpass)
	return;
*outptr++ = ' ';
outptr = outcvt(outptr,2,n,16);
}

putword(n)
{
curpc =+ 2;
prtword(n);
if(lastpass)
	{
	objbyte(n.hi);
	objbyte(n.lo);
	}
}

prtword(n)
{
if(!lastpass)
	return;
*outptr++ = ' ';
outptr = outcvt(outptr,4,n,16);
}

print()
{

char addrbuff[16];
outptr = outbuff;
if(lastpass && lflg && !noprint)
	{
	if(linecnt == lastcnt)
		printf("     ");
	else
		printf("%4d ",linecnt);
	if(dot != curpc)
		outcvt(addrbuff,4,dot,16);
	else
		addrbuff[0] = 0;
	printf(" %-4.4s ",addrbuff);
	printf("%-8.8s",outbuff);
	printf("	%.50s\n",line);
	}
lastcnt = linecnt;
dot = curpc;
noprint = 0;
outbuff[0] = 0;
line[0] = 0;
}

outcvt(buff,len,n,b)
{
/*
 * convert "n" into buff with length "len".
 */
register char *p;
register int l;
register char *q;
extern ldivr;

l = len;
q = p = buff+l;
*p = 0;
do
	{
	n = ldiv(0,n,b);
	*--p = "0123456789ABCDEF"[ldivr];
	}
while (--l);
return(q);
}

objseek(n)
{
if(!lastpass)
	return;
objflush();
objaddr = n;
}

objflush()
{
char temp[20];
register int i;

if(lastpass && oflg && objlen > 0)
	{
	printf("S1");
	outcvt(temp,2,objlen+3,16);
	outcvt(temp+2,4,objaddr,16);
	printf(temp);
	for (i=0; i<objlen; ++i)
		{
		outcvt(temp,2,objbuff[i] & 0377,16);
		printf(temp);
		}
	chksum =+ objlen+objaddr.lo+objaddr.hi+3;
	outcvt(temp,2,(~chksum)&0377,16);
	printf("%s\n",temp);
	}
chksum = 0;
objaddr =+ objlen;
objlen = 0;
}

objbyte(n)
{
n =& 0377;
objbuff[objlen] = n;
chksum =+ n;
++objlen;
if(objlen >= MAXOBJ)
	objflush();
}

objend()
{
objflush();
}
