#include "netcs.h"

/*
 * read in the file build from the system name and process the
 * switches given in that file.
 * don't complain about the DEFAULT file if it doesn't exist.
 */
dofile(name) char *name;
{
char filename[32];
register int l;
FILE *f;
char line[128];

sprintf(filename,"%s/%.14s",DIRFILE,name);
if ((f = fopen(filename,"r")) == NULL)
	{
	if (strcmp(name,DEFAULT) == SAME)
		return;	/* don't complaint about default system */
	fprintf(stderr,"%s not a known system; systems are\n",name);
	sprintf(line,"/bin/ls %s",DIRFILE);
	system(line);
	exit(1);
	}
while (fgets(line,sizeof line,f))
	{
	l = strlen(line);
	if (l > 0 && line[--l] == '\n')
		line[l] = 0;
	TTRACEF(("line='%s'\n",line));
	if (line[0] == '-')
		{
		if (doarg(line+1,NULL,0) != 0)
			err("invalid switch in file %s: %s",filename,line);
		}
	else
		err("switch missing in file %s: %s",filename,line);
	}
fclose(f);
}

/*
 * process a switch argument either from the command line or from
 * the file.
 */
doarg(argp,argv,i) char *argp, *argv[]; int i;
{
	switch(*argp++)
		{
	case 'p':		/* MTS style printout */
		++pflg;
		break;
	case 'd':
		++debug;
		break;
	case 'm':
		getmatch(argp);
		break;
	case 'r':		/* use raw mode */
		cflg = 0;
		break;
	case 'c':
		++cflg;
		break;
	case 'a':
		send_attn = save(argp);
		TRACEF(("send_attn='%s'\n",send_attn));
		break;
	case 'e':
		send_eof = save(argp);
		TRACEF(("send_eof='%s'\n",send_eof));
		break;
	case 'l':
		if (*argp)
			{
			line = save(argp);
			argp = endstr(argp);
			}
		else
			line = argv[++i];
		break;
	case 's':
		if (*argp)
			speed = cvtint(&argp);
		else
			speed = atoi(argv[++i]);
		break;
	default:
		err("bad switch %s",argp-1);
		}
return(i);
}

init()
{
int v[3];
register char *p;

sprintf(lockfile,LOCKNAME,endstr(line)-4);
if (mklock(lockfile))
	err("line %s in use",line);
++gotlock;
for (p = " \b\t\n\r"; *p; ++p)
	printable[*p] = YES;		/* set printable characters */
signal(SIGALRM,&timeout);
alarm(CON_TIME);
if ((fdline = open(line,2)) < 0)
	uerr("can't open %s",line);
alarm(0);				/* cancel delay */
in_line = fdopen(fdline,"r");
out_line = fdopen(fdline,"w");
gtty(fdline,v);
v[2] = (cflg ? RARE : RAW) | EVENP | ODDP;
v[0] = cvtspeed(speed);
stty(fdline,v);
v[0] = HZ;	/* 1 second delay = forward */
if (cflg && ioctl(fdline,TIOCITIME,v) < 0)
	printf("no input timer\n");
}

cvtspeed(n)
{
register int s = B300;
switch(n)
	{
case 110: s = B110; break;
case 200: s = B200; break;
case 300: s = B300; break;
case 600: s = B600; break;
case 1200: s = B1200; break;
case 2400: s = B2400; break;
case 4800: s = B4800; break;
case 9600: s = B9600; break;
case 19200: s = EXTA; break;
	}
return((s <<8 ) + s);
}
