#include "netcs.h"

getmatch(argp) char *argp;
/*
 * parse the match string specification.
 */
{
	register char *p;
	register int flag;
	register int cnt;

	flag = 0;
	if (isdigit(*argp))
		{
		cnt = cvtint(&argp);
		if (*argp == '*')
			{
			flag++;
			++argp;
			}
		if (*argp == ';')
			++argp;
		else
			err("bad match format");
		}
	else
		cnt = NMATCH;
	if (p = any(argp,";"))
		*p++ = 0;
	else
		err("no ; found in match string");
	match[mcnt].pattern = save(argp);
	lctran(match[mcnt].pattern);
	match[mcnt].out = save(p);
	match[mcnt].cnt = cnt;
	match[mcnt].flag = flag;
	*p = ';';
	TRACEF(("store match cnt=%d pat='%s' send='%s'\n",match[mcnt].cnt,match[mcnt].pattern,match[mcnt].out));
	++mcnt;
}

testmatch(buff) char *buff;
{
	register int i;
	register char *p;

	lctran(buff);
	for (i=0; i<mcnt; ++i)
		{
		p = match[i].pattern;
		if (findmatch(buff,p))
			{
TRACEF(("found match[%d] = %d;%s;%s\n",i,match[i].cnt,match[i].pattern,match[i].out));
			p = match[i].out;
			if (*p == cmd && scr_cmd(p+1))
				;
			else
				{
				printf("%s\r\n",p);
				flush();
				fputs(p,out_line);
				putc('\r',out_line);
				}
			fflush(out_line);
			if (!match[i].flag)
				delmatch(i--);
			break;
			}
		if (--match[i].cnt == 0)
			delmatch(i--);
		}
}

delmatch(n)
{
register int i;

TRACEF(("delete match[%d] = %d;%s;%s\n",n,match[n].cnt,match[n].pattern,match[n].out));
for (i=n; i<mcnt; i++)
	move(sizeof (struct match),&match[i+1],&match[i]);
--mcnt;
}


findmatch(buff,mptr) register char  *mptr, *buff;
{
while (isspace(*buff))
	++buff;
while (isspace(*mptr))
	++mptr;
while (*mptr && *mptr++ == *buff++)
	;
return(*mptr == 0);
}
