#include "netcs.h"

char *line = "/dev/ttyH";
int speed = 4800;
char cmd = '~';
FILE *in_file = stdin, *out_file = stdout;
int cflg = 1;
char *send_eof = "\4";	/* assume unix */
int echo = NA;

main(argc,argv) char **argv;
{
register char *argp;
register char *p;
register int i;

dofile(DEFAULT);
for (i=1; i<argc; ++i)
	{
	if (*(argp = argv[i]) == '-')
		i = doarg(argp+1,argv,i);
	else
		dofile(argp);
	}
init();
setout();
main_pid = getpid();
if (pipe(pipe1) < 0 || pipe(pipe2) < 0)
	uerr("can't create pipes");
signal(SIGHUP,&done);
signal(SIGTERM,&done);
if ((pid = fork()) == 0)
	{
	scr_in = fdopen(pipe1[0],"r");
	close(pipe1[1]);
	scr_out = fdopen(pipe2[1],"w");
	close(pipe2[0]);
	signal(SIGIOT,&scr_iot);
	enter(&screen,NULL);
	scr_cmd("q");		/* send cmd to quit */
	}
else
	{
	kbd_in = fdopen(pipe2[0],"r");
	close(pipe2[1]);
	kbd_out = fdopen(pipe1[1],"w");
	close(pipe1[0]);
	signal(SIGIOT,&kbd_iot);
	enter(&keyboard,NULL);
	kill(pid,9);
	}
done(0);
}

done(n)
{
int status;
register int i;

while ((i = wait(&status)) != pid && i > 0)		/* wait for child */
	;
if (gotlock)
	rmlock(lockfile);
exit(n);
}

timeout()
{
if (gotlock)
	rmlock(line);
err("could not get %s - timed out",line);
}

attn()
{
++intrflg;
if (send_attn)
	fputs(send_attn,out_line);
else
	sendbrk(0);
signal(SIGINT,&attn);
}

kbd_cmd(buff) register char *buff;
{
while (isspace(*buff))
	++buff;
switch(*buff++)
	{
case '^':
	putc(*buff&037,out_line);
	fflush(out_line);
	break;
case 'q':
	signal(SIGIOT,SIG_IGN);	/* ignore anything else */
	send_cmd(pid,kbd_out,"%cq\n",cmd);
	leave(0);
	break;
case '!':
	system(buff);
	printf("!\n");
	break;
case 'b':
	if (*buff == 'l')
		setecho(NO);
	else
		sendbrk(atoi(buff));
	break;
case '<':
	indivert(buff);
	break;
case '>':
case 'p':
	send_cmd(pid,kbd_out,"%c%s\n",cmd,buff-1);
	flush();
	break;
default:
	return(0);
	}
return(1);
}

setecho(flag)
{
int v[3];

gtty(0,v);
if (echo == NA && (v[2]&ECHO) == 0)
	return;
if (flag == NO)
	v[2] &= ~ECHO;
else
	v[2] |= ECHO;
echo = flag;
stty(0,v);
}

warn(flag,fmt,d1,d2,d3,d4) char *fmt;
{
fprintf(stderr,fmt,d1,d2,d3,d4);
if (flag)
	{
	fprintf(stderr," - ");
	perror("");
	}
fprintf(stderr,"\n");
}

uerr(fmt,d1,d2,d3,d4) char *fmt;
{
warn(YES,fmt,d1,d2,d3,d4);
done(1);
}


err(fmt,d1,d2,d3,d4) char *fmt;
{
warn(NO,fmt,d1,d2,d3,d4);
done(1);
}



send_cmd(to_pid,to_file,fmt,d1,d2) char *fmt; FILE *to_file;
{
	fprintf(to_file,fmt,d1,d2);
	fflush(to_file);
	TRACEF(("to pid %d (%s): ",to_pid,to_pid == main_pid ? "keyboard" : "screen"));
	TRACEF((fmt,d1,d2));
	kill(to_pid,SIGIOT);		/* notify other process */
	sleep(1);		/* delay to prevent overrunning other end */
}

kbd_iot()
{
char kbd_buff[128];
register int l;

++intrflg;		/* remember we were interrupted */
signal(SIGIOT,&kbd_iot);
TRACEF(("kbd_iot\n"));
while (!fgets(kbd_buff,sizeof kbd_buff,kbd_in))
	;
l = strlen(kbd_buff);
if (l)
	kbd_buff[--l] = 0;
TRACEF(("got kbd cmd='%s' from pipe\n",kbd_buff));
if (kbd_buff[0] == cmd)
	kbd_cmd(kbd_buff+1);
}

scr_iot()
{
char scr_buff[128];
register int l;

++intrflg;		/* remember interrupt */
signal(SIGIOT,&scr_iot);
TRACEF(("scr_iot\n"));
while (!fgets(scr_buff,sizeof scr_buff,scr_in))
	;
l = strlen(scr_buff);
if (l)
	scr_buff[--l] = 0;
TRACEF(("got scr cmd='%s' from pipe\n",scr_buff));
if (scr_buff[0] == '~')
	scr_cmd(scr_buff+1);
}
