#

/*
 * plot output filter for the Calcomp 565 plotter.
 * invoked by the plot subroutines by means of:
 * a.out ... 107=!plotter
 */

#define	draw	2
#define	move	3

int debug 0;
int flag;
int xmax, ymax;
int rmflg;		/* remove file after use */
int sflg;		/* force spooling of output */
int bflg;		/* buffer output thru pipe */

main(argc,argv) char **argv;
{
register int c;
extern int fin[];
register int x,y;
char *argp;

--argc;
++argv;
while (argc > 0)
	{
	argp = *argv++;
	--argc;
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 's':
			++sflg;
			break;
		case 'b':
			++bflg;
			break;
		case 'r':
			++rmflg;
			break;
		case 'd':
			++debug;
			}
		}
	else
		{
		if (fopen(argp,&fin) < 0)
			err("can't open %s",argp);
		if (rmflg)
			unlink(argp);
		}
	}
plots();
while ((c = getc(&fin)) >= 0)
	{
	switch(c)
		{
	case 030:	/* erase screen */
		if (debug)
			printf("erase\n");
		go(move,xmax,0);
		xmax = ymax = 0;
		reorigin();
	default:
		while ((c = getc(&fin)) < 0377)
			;
		break;
	case 035:	/* draw x1 y1, move x2 y2 ... */
		flag = 0;
		while ((x = coord()) >= 0)
			{
			y = coord();
			if (x > xmax)
				xmax = x;
			if (y > ymax)
				ymax = y;
			if (debug)
				printf("(%d,%d) ",x,y);
			if (flag++)
				go(draw,x,y);
			else
				go(move,x,y);
			}
		if (debug)
			printf("\n");
		break;
		}
	psend();
	}
go(move,xmax+100,100);
psend();
}

coord()
{
register int c;
extern int fin[];

c = getc(&fin);
if (c < 0 || c == 0377)
	return(-1);
return((c << 6) + getc(&fin));
}

int xpos, ypos;		/* where it is */

go(how,x,y)
{
if (how == move)
	penup();
else
	pendn();
xymov(x-xpos,y-ypos);
xpos = x; ypos = y;
}

int pen;		/* how the pen is */
int plotbuff[518/2];

xymov(x,y)
{
#define	minusx	2
#define	plusx	1
#define	minusy	8
#define	plusy	4
#define	up	32
#define	down	16
/*
 * draw by (x,y) increments.
 */
int absx, absy, i;
int maj, min;
register int nomaj, nomin, start;

if ((absx = x) < 0)
	absx = -absx;
if ((absy = y) < 0)
	absy = -absy;
if (absx > absy)
	{
	maj = (x < 0) ? minusx : plusx;
	min = (y < 0) ? minusy : plusy;
	nomaj = absx;
	nomin = absy;
	}
else
	{
	min = (x < 0) ? minusx : plusx;
	maj = (y < 0) ? minusy : plusy;
	nomaj = absy;
	nomin = absx;
	}
min =+ maj;
start = nomaj>>1;
for (i=0; i<nomaj; ++i)
	{
	start =+ nomin;
	if (start < nomaj)
		ploti(maj);
	else
		{
		ploti(min);
		start =- nomaj;
		}
	}
}

penup()
{
if (pen != up)
	ploti(pen = up);
}

pendn()
{
if (pen != down)
	ploti(pen = down);
}

ploti(what)
{
putc(what,&plotbuff);
}

psend()
{
fflush(&plotbuff);
}

plots()
{
register int i;
if (sflg || bflg || fcreat("/dev/xy",&plotbuff) < 0)
	plotbuff[0] = pipeout( sflg ? "/bin/oxy" : "/bin/xy","xy",0);
for (i=0; i<20 ; ++i)
	{
	pendn();
	penup();
	}
xymov(0,-1200);		/* position at right margin */
reorigin();
}

reorigin()
{
xpos = ypos = 0;
}
