#include "rt11.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	R_LP	046600
#define	R_TA	076450		/* TA ... mapping of dec-tape */
#define	F	0100000		/* device is file structured */

struct devs
{
int d_device;		/* rad50 device name */
char *d_path;		/* unix path name equiv. */
int d_info;		/* device info */
} devs[]
{
R_RK,	"",	F|01,
R_SY,	"",	F|01,
R_DK,	"",	F|01,
R_DT,	"/dev/tap0",	F|01,
R_TA,	"/dev/tap0",	F|01,
0,	"",	F,
R_TT,	"/dev/tty",	0,
R_LP,	"/dev/lp",	0,
0,	0,	0
};

cvtfile(dev,name)
struct devblk *dev;
char *name;
{
register struct devs *d;

/*
 * convert the rt-11 file name (in rad50) in dev
 * to a unix path name. 
 */

for (d = devs; d->d_path; ++d)
	{
	if(d->d_device == dev->d_dev)
		{
		copy(name,d->d_path);
		if(d->d_info & F)
			{
			if(d->d_path[0])
				append(name,"/");
			cvtname(dev->d_name,endstr(name),0);
			}
		if(tflg)
			printf(" '%s'",name);
		return(1);
		}
	}
err("%s: invalid device",radstr(dev->d_dev));
}

dstatus(dev,devspc)
int *devspc;
int *dev;
{
register struct devs *d;
register int *p;
register int n;

p = devspc;
n = dev[0];

if(tflg)
	printf(" %s",radstr(n));
for (d = devs; d->d_path; ++d)
	{
	if(d->d_device == n)
		{
		*p++ = d->d_info;
		*p++ = 256;
		*p++ = 0;
		*p++ = 4800;
		return;
		}
	}
clear(p,4<<1);
seterr(0);
}

radstr(dev)
{
static char str[4];

rad50(dev,str);
return(str);
}

fetch(dev,addr)
int *dev;
char *addr;
{
register struct devs *d;
register int n;

n = dev[0];
if(tflg)
	printf(" '%s'",radstr(n));
for (d = devs; d->d_path; ++d)
	if(d->d_device == n)
		{
		u.r0 = addr;
		return;
		}
seterr(0);
}
