	.globl	_transfer
/*		Copyright 1976 by Bill Webb. 		*/
	.globl	ret,savesp
	.globl	_setsigs
	.globl	_u
	.globl	trap,fputrap,traptrap,emttrap,iottrap,inttrap
sleep	=	35.
iot	=	4
systrap	=	63.
rti	=	2
sigint	=	2
sigemt	=	7
sigiot	=	6
sigfpt	=	8.
sigsys	=	12.
sigbus	=	10.
sigseg	=	11.
_transfer:
/
/	transfer to user routine
/	restore regs, ps, pc, stack from _u
/
	mov	r5,-(sp)
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r1,-(sp)
	mov	sp,savesp
/
/	restore dos program's registers from _u
/
/	_u+18	= 6 registers + ps + pc + sp words 
	mov	$_u+18.,r0	/end of region
	mov	-(r0),sp	/restore the stack 
	mov	-(r0),-(sp)	/ps
	mov	-(r0),-(sp)	/pc
	mov	-(r0),r5
	mov	-(r0),r4
	mov	-(r0),r3
	mov	-(r0),r2
	mov	-(r0),r1
	mov	-(r0),r0
	rti			/return to dos program
/
/
/	return from user section
/	save registers etc 
/
trap:
	mov	(sp)+,ret	/save return address
	mov	r0,_u
	mov	$_u+2,r0
	mov	r1,(r0)+
	mov	r2,(r0)+
	mov	r3,(r0)+
	mov	r4,(r0)+
	mov	r5,(r0)+
	mov	(sp)+,(r0)+
	mov	(sp)+,(r0)+
	mov	sp,(r0)+
/
/	restore fakedos's stack 
/
	mov	savesp,sp
	clr	savesp		/remember we are back in unix
	jsr	pc,*ret		/return to trap routine
/
/signals have been reset, now return to fakedos
/
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	mov	(sp)+,r5
	rts	pc
_setsigs:
	sys	signal;sigemt;emttrap
	tst	2(sp)		/test if to set all signals
	beq	1f		/0 = no
	sys	signal;sigiot;iottrap
	sys	signal;sigbus;bustrap
	sys	signal;sigseg;segtrap
1:	rts	pc
	.globl	_setfpu
_setfpu:
	sys	signal;sigfpt;fputrap
	rts	pc

	.globl	_settrap
_settrap:
	clr	savesp		/first, just in case
	sys	systrap;savesp
	sys	signal;sigsys;traptrap
	rts	pc


fputrap:
	jsr	pc,trap
	sys	signal;sigfpt;fputrap
	mov	$2,r0		/return code
	rts	pc		/continue

traptrap:
	jsr	pc,trap
	sys	signal;sigsys;traptrap
	mov	$3,r0
	rts	pc
emttrap:
	jsr	pc,trap		/save dos registers etc
	sys	signal;sigemt;emttrap
	clr	r0	/clear return code
	rts	pc		/and continue

iottrap:
	jsr	pc,trap		/save dos registers etc
	sys	signal;sigiot;iottrap
	mov	$1,r0		/return code
	rts	pc

bustrap:
	jsr	pc,trap		/save dos registers etc
	sys	signal;sigbus;bustrap
	mov	$4,r0
	rts	pc		/and contine

segtrap:
	jsr	pc,trap
	sys	signal;sigseg;segtrap
	mov	$6,r0
	rts	pc


	.globl	_abort
_abort:
	sys	signal;sigiot;0		/iot is now an an error 
	iot
	rts	pc

/
/	set up attn trap 
/
	.globl	_setint
_setint:
	sys	signal;sigint;inttrap
	bit	$1,r0		/test if allowed before
	beq	1f
	sys	signal;sigint;1
1:	rts	pc

	.globl	_restart
inttrap:
	mov	$1,r0
	sys	sleep
	sys	signal;sigint;inttrap
	jsr	pc,_restart
	rti

.bss
savesp:	.=.+2
ret:	.=.+2
