#include "rtunix.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	r	0400 +		/* # of register parameters */

struct systab {
	char	s_args,s_regs;
	int	(*s_rtn)();
} _systab[] {
	1, &_badsys,
r	0, &_exit,
	0, &fork,
r	2, &read,
r	2, &write,
	2, &open,
r	0, &close,
	0, &wait,
	2, &creat,
 	2, &link,
	1, &unlink,
	2, &execv,
	1, &chdir,
	0, &time,
	3, &_badsys,
	2, &chmod,
	2, &chown,
	1, &brk,
	2, &stat,
r	2, &seek,
	0, &getpid,
	3, &_badsys,
	1, &_badsys,
r	0, &setuid,
	0, &getuid,
	0, &stime,
	3, &ptrace,
	0, &_badsys,
	1, &fstat,
	0, &_badsys,
	1, &smdate,
	1, &stty,
	1, &gtty,
	0, &_badsys,
r	0, &nice,
r	0, &sleep,
	0, &sync,
r	1, &kill,
	0, &getcsw,
	0, &_badsys,
	0, &_badsys,
r	0, &dup,
	0, &pipe,
	1, &times,
	4, &_badsys,
	0, &_badsys,
r	0, &setgid,
	0, &getgid,
	2, &signal,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	0, &_badsys,
	1, &_badsys
};

int _trpflag 0;			/* 0 unless inside unix */

_trap(r0,r1,pc,ps)
int *pc;
{
/*
 * a trap instruction has been found. 
 * the instruction should be executed by calling the
 * appropriate routine. 
 */

register int *p;
int n;
register struct systab *t;
register int *a;
int i;
int code;
extern errno;
static args[4];


ps =& ~1;			/* turn off c bit */
code = n = pc[-1] & 077;
#ifdef	debug
	_trace("sys call %d at %o",n,pc);
#endif
if(_trpflag++)
	{
	_trace("trap at %o # %d",pc,n);
	err("recursive trap");
	}
if(n == 0)
	{		/* .indir */
	p = *pc++;
	n = *p++ & 077;
	}
else
	p = pc;
t = &_systab[n];
a = args;
if(t->s_regs)
	{
	*a++ = r0;
	if(t->s_regs>1)
		*a++ = r1;
	}
for (i=0; i<t->s_args; ++i)
	*a++ = *p++;
if(code)		/* if wasn't .indir */
	pc = p;
while (a < args+4)
	*a++ = 0;
#ifdef	debug
	_trace("args: %o %o %o %o",args[0],args[1],args[2],args[3]);
#endif
r0 = (*t->s_rtn) (args[0],args[1],args[2],args[3]);
_trpflag = 0;
if(r0 == -1)
	{
	r0 = errno;
	++ps;
	}
#ifdef	debug
	_trace("return to %o (%o) with %o",pc,ps,r0);
#endif
}

_badsys()
{
err("bad sys call");
}
