/
/ copyright 1972 bell telephone laboratories inc.
/

/ rc -- complex arithmetic

.globl	addc_ss
.globl	subc_ss
.globl	mulc_ss
.globl	divc_ss
.globl	negc_s
.globl	addh_ss
.globl	subh_ss
.globl	mulh_ss
.globl	divh_ss
.globl	negh_s
.globl	eqc_ss
.globl	nec_ss
.globl	eqh_ss
.globl	neh_ss

.globl	expci_ss
.globl	exphi_ss

one = 040200
a = r2
b = r3
c = r4
d = r5

e = r0
f = r1

addh_ss:
	setd
	br	1f

addc_ss:
	setf
1:
	jsr	pc,garg
	addf	a,e
	addf	b,f
	br	sarg

subh_ss:
	setd
	br	1f

subc_ss:
	setf
1:
	jsr	pc,garg
	subf	a,e
	negf	e
	subf	b,f
	negf	f
	br	sarg

mulh_ss:
	setd
	br	1f

mulc_ss:
	setf
1:
	jsr	pc,garg
	mulf	a,e
	mulf	b,f
	subf	f,e
	mulf	d,a
	mulf	c,b
	movf	a,f
	addf	b,f

sarg:
	movf	f,-(sp)
	movf	e,-(sp)
	jmp	*(r4)+

divh_ss:
	setd
	br	1f

divc_ss:
	setf
1:
divide:
	jsr	pc,garg
	absf	e
	absf	f
	cmpf	e,f
	cfcc
	blt	1f

/ algorithm #1 |c| > |d|

	movf	d,e
	divf	c,e		/ r = d/c
	movf	d,f
	mulf	e,f
	addf	c,f		/ x = c+rd
	movf	f,c
	movf	a,f
	mulf	e,f
	negf	f
	addf	b,f
	mulf	b,e
	addf	a,e
	divf	c,e
	divf	c,f
	br	sarg

/ algorithm #2 |c| < |d|

1:
	movf	c,e
	divf	d,e		/ r = c/d
	movf	c,f
	mulf	e,f
	addf	d,f		/ x = d+rc
	movf	f,c
	movf	b,f
	mulf	e,f
	subf	a,f
	mulf	a,e
	addf	b,e
	divf	c,e
	divf	c,f
	br	sarg

negh_s:
	setd
	br	1f

negc_s:
	setf
1:
	movf	(sp)+,a
	negf	a
	negf	(sp)
	movf	a,-(sp)
	jmp	*(r4)+

/ setup the following registers
/ (a,bi) +o (c,di) -> (e+fi)
/ a,b,c,d are input
/ e,f are output and also contain
/ c,d on input

garg:
	mov	(sp)+,r0
	movf	(sp)+,e
	movf	e,c
	movf	(sp)+,f
	movf	f,d
	movf	(sp)+,a
	movf	(sp)+,b
	jmp	(r0)


eqh_ss:
	setd
	br	1f
eqc_ss:
	setf
1:
	mov	$1,r1
	br	2f

neh_ss:
	setd
	br	1f

nec_ss:
	setf
1:
	clr	r1
2:
	jsr	pc,garg
	cmpf	c,a
	cfcc
	bne	1f
	cmpf	d,b
	cfcc
	beq	2f
1:
	inc	r1
	bic	$2,r1
2:
	mov	r1,-(sp)
	jmp	*(r4)+

expcq_ss:
	tst	(sp)+
expci_ss:
	setf
	br	1f

exphq_ss:
	tst	(sp)+
exphi_ss:
	setd
1:
	clr	r0
	mov	(sp)+,r1
	bge	1f
	inc	r0
	neg	r1
1:
	movf	(sp)+,fr0
	movf	fr0,fr4
	movf	(sp)+,fr0
	movf	fr0,fr5
	movf	$one,fr0
	clrf	fr1
1:
	dec	r1
	bmi	1f
	movf	fr0,fr2
	movf	fr1,fr3
	mulf	fr4,fr0
	mulf	fr4,fr1
	mulf	fr5,fr2
	mulf	fr5,fr3
	subf	fr3,fr0
	addf	fr2,fr1
	br	1b
1:
	tst	r0
	beq	1f
	clrf	-(sp)
	movf	$one,fr2
	movf	fr2,-(sp)
	movf	fr1,-(sp)
	movf	fr0,-(sp)
	jmp	divide
1:
	movf	fr1,-(sp)
	movf	fr0,-(sp)
	jmp	*(r4)+
