#include <stdio.h>

/*
 * col [-t] [-d] 1-10,22-33,10-12 [file ...]
 * col [-t] [-d] <1-10>,<22-33>|<10-12> [file ...]
 */

#define	MAXRANGE	100
#define	LASTCOL	9999
#define	BLANK ' '

struct range
{
char *start;		/* pointer to start of string */
char *end;		/* pointer to next location of string */
char *text;		/* additional text */
} ranges[MAXRANGE], *lastrange = ranges;

#define	MAXLINE	1024
char line[MAXLINE];
char outline[MAXLINE];
char *outptr = outline;
char *endline;
char *tab = "|";
int tflg;
int lflg;
int fflg;
char *ptr;
int col1, col2;
FILE *f;
int dflg;
char *any(), *endstr(), *strsave(), *fgets();

main(argc,argv) char **argv;
{
register int i;
register char *argp;

if (argc < 2)
	err("usage: %s [-tx] [-d] [-b] 'col-ranges' [file ...]",argv[0]);
for (i=1; (* (argp = argv[i]) == '-'); ++i)
	{
	switch(argp[1])
		{
	case 't':
		++tflg;
		tab = argp+2;
		break;
	case 'l':
		++lflg;		/* leave leading blanks */
		break;
	case 'f':
		++fflg;		/* leave following blanks */
		break;
	case 'b':
		++lflg;		/* same as -f and -l */
		++fflg;
		break;
	case 'd':
		++dflg;
		break;
		}
	}
if (any(argp = argv[i++],"<>") && !tflg)
	tab = "";			/* don't automatically insert delimiters */
getranges(argp);
for (; i<argc; ++i)
	{
	argp = argv[i];
	if ((f = fopen(argp,"r")) == NULL)
		err("can't open %s",argp);
	process(f);
	fclose(f);
	}
if (f == NULL)
	process(stdin);
exit(0);
}

getranges(p) char *p;
{
ptr = p;
if (!any(ptr,"<>"))
	{
	while (getr())
		{
		putr();
		}
	}
else
	{
	for (outptr = outline; *ptr; )
		{
		if (*ptr == '<')
			{
			++ptr;
			getr();
			putr();
			if (*ptr != '>')
				err("bad syntax %s",p);
			++ptr;
			}
		else
			*outptr++ = *ptr++;
		}
	col1 = 1; col2 = 0;
	putr();
	}
}

getr()
{
/*
 * get the range pointed to by "ptr".
 */

if (*ptr == 0 || *ptr == '>')
	return(0);
if (cvtint(&ptr,&col1) != 1)
	err("bad number %s",ptr);
if (*ptr == '-')
	{
	++ptr;
	if (cvtint(&ptr,&col2) != 1)
		err("bad number %s",ptr);
	}
else
	col2 = col1;
if (*ptr == ',')
	++ptr;
return(1);
}

putr()
{
register struct range *r;

r = lastrange;
if (r >= ranges+MAXRANGE)
	err("too many column ranges");
r->start = line+col1-1;
r->end = line+col2;
if (outptr != outline)
	{
	*outptr++ = 0;
	r->text = strsave(outline);
	}
else
	r->text = "";
if (dflg)
	printf("cols %d-%d text='%s'\n",col1,col2,r->text);
++r;
lastrange = r;
outptr = outline;
}

process(file) FILE *file;
{
register char *p, *q;
register struct range *r;

while (fgets(line,MAXLINE,file))
	{
	endline = endstr(line);
	if (endline[-1] == '\n')
		--endline;
	for (r=ranges; r<lastrange; ++r)
		{
		if (p = r->text)
			while (*p)
				putchar(*p++);
		p = r->start;
		q = r->end;
		if (p < endline)
			{
			if (q > endline)
				q = endline;	/* q points to actual end of field */
			if (!lflg)
				while (*p == BLANK && p < q)
					++p;	/* trim leading blanks */
			if (!fflg)
				{
				while (*--q == BLANK && q > p)
					;	/* trim trailing blanks */
				++q;
				}
			while (p < q)
				putchar(*p++);
			}
		if (p = tab)
			while (*p)
				putchar(*p++);
		}
	putchar('\n');
	}
}

cvtint(ptr,num) char **ptr; int *num;
{
register int n;
register char *p;

if (**ptr == 'n')
	{
	++*ptr;
	*num = LASTCOL;
	return(1);
	}
for (p = *ptr, n = 0; isdigit(*p); )
	n = n * 10 + *p++ - '0';
*num = n;
n = p != *ptr;
*ptr = p;
return(n);
}
