#include <stdio.h>
#include <pwd.h>
#include <stat.h>

#define	HZ	60
struct stat statb;
struct times
{
int u_time, s_time;
long cu_time, cs_time;
} tbuf;


char *consult = "consulting";
char *project;
char finger[64];
char proj_dir[64];
char proj_file[64];
char lock_file[64];
char *comment;		/* comment to print */
int status;
FILE *pfile;
FILE *lock;
FILE *fing;
char *user;

main(argc,argv) char **argv;
{
/*
 * consult project user
 * keep accounting record of time spent on a particular
 * project.
 * if "user" is not specified then do it under the current
 * user-id
 */
register struct passwd *pw;
register int i;
extern int ldivr;
int min, sec;
long now, start, diff;
float cpu;
char ans[80];

time(&start);
if (argc < 2)
	err("usage: %s project [user] [comment]",argv[0]);
if ((pw = getpwuid(getuid())) == (struct passwd *) NULL)
	err("can't locate UID");
project = argv[1];
comment = argc > 3 ? argv[3] : "";
sprintf(proj_dir,"%s/%s",pw->pw_dir,consult);
if (stat(proj_dir,&statb) < 0)
	err("directory %s",proj_dir);
sprintf(proj_file,"%s/GENERAL",proj_dir);
if (stat(proj_file,&statb) < 0)
	sprintf(proj_file,"%s/%s",proj_dir,project);
sprintf(lock_file,"%s/lock",proj_dir);
if ((lock = fopen(lock_file,"r")) != NULL)
	{
	printf("Already active in:\n");
	while (fgets(ans,sizeof ans,lock))
		printf("	%s",ans);
	printf("continue? ");
	if (fgets(ans,sizeof ans,stdin) == NULL || ans[0] != 'y')
		err("cancelled");
	fclose(lock);
	}
if (stat(proj_file,&statb) < 0)
	{
	printf("No such project ... create it? ");
	if (fgets(ans,sizeof ans,stdin) == NULL || ans[0] != 'y')
		err("cancelled");
	}

if ((pfile = fopen(proj_file,"a")) == NULL)
	err("can't open project file %s",proj_file);
if ((lock = fopen(lock_file,"a")) == NULL)
	err("Can't open lock file");
fprintf(lock,"%s\n",project);
fclose(lock);
sprintf(finger,"%s/.project",pw->pw_dir);
if ((fing = fopen(finger,"w")) != (FILE *) NULL)
	{
	fprintf(fing,"%s - %s\n",project,comment);
	fclose(fing);
	}
user = (argc < 3 || *argv[2] == 0) ? pw->pw_name : (*argv[2] == '&' ? project : argv[2]);
printf("project=%s\n",project);
if (fork() == 0)
	{
	/* child process */
	if (strcmp(user,pw->pw_name))
		{		/* differnt UID */
		execl("/bin/su","su",user,0);
		err("can't exec /bin/su");
		}
	else
		{		/* same UID */
		execl("/bin/sh","-",0);
		err("can't exec /bin/sh");
		}
	}

for (i=1; i<=15; ++i)
	signal(i,1);		/* ignore all signals */
while (wait(&status) != -1)
	;
time(&now);
diff = now-start;
min = ldiv(diff,60);
sec = ldivr;
fseek(pfile,0l,2);	/* to end of file */
times(&tbuf);
cpu = (tbuf.cu_time + tbuf.cs_time)/(double ) HZ;
fprintf(pfile,"%s user=%s project=%s cpu=%.0f elt=%02d:%02d '%s' %s",pw->pw_name,user,project,cpu,min,sec,comment,ctime(&start));
fclose(pfile);
printf("elt=%d:%02d cpu=%.0f\n",min,sec,cpu);
if ((fing = fopen(finger,"w")) != (FILE *) NULL)
	{
	fprintf(fing,"general\n",project,comment);
	fclose(fing);
	}
unlink(lock_file);
exit(status != 0);
}
