int quit, hup, intr;
int status;
char *dev;
int mode;
int userid;
struct stat
{
char minor;
char major;
int inumber;
int flags;
char nlinks;
char uid;
char gid;
char size0;
int size1;
int addr[8];
int actime[2];
int modtime[2];
} stats;

struct { char lo, hi ;};

main(argc,argv) char **argv;
{
userid = getuid();
if (userid.hi)
	err("not super user");
if (argc < 2)
	err("usage: grab device");
dev = argv[1];
if (stat(dev,&stats) < 0)
	err("%s: not found",dev);
if ((stats.flags&060000) != 020000)
	err("%s: not a character device");
hup = signal(1,1);
intr = signal(2,1);
quit = signal(3,1);
if (chown(dev,userid.lo) < 0)
	err("can't chown");
mode = stats.flags & 07;	/* other mode */
if (mode == 0)
	err("permission denied");
if (chmod(dev,mode << 6) < 0)
	err("can't chmod");
printf("%s: grabbed; use 'bye' to release.\n",dev);
if (fork() == 0)
	{
	setuid(userid.lo);	/* back to normal user id */
	signal(1,hup);
	signal(2,intr);
	signal(3,quit);
	execl("/bin/sh","-",0);
	err("no /bin/sh");
	exit(1);
	}
while (wait(&status) != -1)
	;
chown(dev,stats.uid);
chmod(dev,stats.flags);
mdate(dev,stats.modtime);
printf("%s: released.\n",dev);
exit(0);
}
