#include <stdio.h>
#include <signal.h>
#include <pwd.h>

char buff[512];
char sep = ' ';
#define	MAXARGS	20
#define	MAXCMD	25
char *bp[MAXARGS];

char *cmds[MAXCMD] =
{ "cd", "ls", "rm", "du", "Mail", "mail", "pwd", NULL };

int nf;
struct pw *pw;

main(argc,argv) char **argv;
{
register int i = dup(1);
register char *p;

pw = getpwuid(getuid());
if (i != 2)
	close(i);		/* make sure we have a file des 2 */
signal(SIGINT,SIG_IGN);
signal(SIGQUIT,SIG_IGN);
if (argc > 1)
	err("Sorry, no lower level shells allowed");
setout();
if (!init(pw->pw_name))
	init("Commands");
printf("Restricted shell: the only commands available are:\n\t");
for (i=0; p=cmds[i]; ++i)
	if (*p != '-')
		printf(" %s",p);
printf("\n");
while (printf(". "),flush(),fgets(buff,sizeof buff,stdin))
	{
	i = strlen(buff);
	buff[i] = 0;
	if (any(buff,"<>"))
		{
		printf("Sorry, no I/O redirection\n");
		continue;
		}
	if (any(buff,"*[]?"))
		{
		printf("Sorry, no pattern matching\n");
		continue;
		}
	nf = gparse(buff,bp,MAXARGS,sep);
	if (nf > 0)
		{
		for (i=0; p = cmds[i]; ++i)
			{
			if (*p == '-')
				++p;
			if (equal(bp[0],p))
				break;
			}
		if (p)
			execute(i);
		else
			printf("%s not allowed\n",bp[0]);
		}
	}
exit(0);
}

execute(i)
{
char pgm[20];
bp[nf] = NULL;
if (i == 0)
	{
	if (nf <= 1)
		bp[1] = pw->pw_dir;
	if (chdir(bp[1])<0)
		printf("can't cd to %s\n",bp[1]);
	return;
	}
sprintf(pgm,"/usr/bin/%s",bp[0]);
if (fork() == 0)
	{
	signal(SIGINT,0);
	signal(SIGQUIT,0);
	execv(pgm+4,bp);	/* look into /bin */
	execv(pgm,bp);		/* look into /usr/bin */
	printf("%s not found\n",pgm);
	}
else
	wait(&i);
return(i);
}

init(name) register char *name;
{
register char *buff;
register int l;
int f;
register char *p;
int ncmd = 0;

sprintf(buff,"/etc/limit/%s",name);
if ((f = open(buff,0)) > 0)
	{
	buff = sbrk(512);
	l = read(f,buff,512-1);
	buff[l] = 0;
	for (p=buff; *p; ++p)
		if (*p == '\n')
			*p = ' ';	/* allow blanks or newlines */
	ncmd = gparse(buff,cmds,MAXCMD,' ');
	cmds[ncmd] = NULL;
	close(f);
	return(ncmd);
	}
return(0);
}

