#
#

#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define	IFCHR	020000
#define	IFBLK	060000

#define	HOW(x) ((x) ? "local" : "remote")

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb;

struct {
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
};


struct {
char name[8];
int n_type;
unsigned n_value;
} list[2];

char devname[16];	/* "/dev/ttyx" */
int lflg;
int sflg;		/* do it silently for uucp */
char byte;
long posn;
struct { char d_minor, d_major; };
char *basename();

main(argc,argv) char **argv;
{
register int c,n;
register char *p;
int minor, bit;
int fd;
char *tty;

lflg = (*basename(argv[0])) == 'l';	/* default is remote unless starts with "l" */
--argc; ++argv;
while (argc > 0 && *(p = *argv) == '-')
	{
	--argc;
	++argv;
	switch(p[1])
		{
	case 's':		/* silently */
		++sflg;
		break;
	case 'l':		/* local */
		lflg=1;
		break;
	case 'r':		/* remote */
		lflg=0;
		break;
	default:
		xerr("bad switch %s",p);
		}
	}
if (argc < 1 || strncmp("tty",tty = argv[0],3) != 0)
	xerr("usage: local|remote [-l|-r] ttyx");
sprintf(devname,"/dev/%s",tty);
if (stat(devname,&statb) < 0)
	xerr("%s not found",devname);
if ((statb.s_flags&IFMT) != IFCHR)
	xerr("%s not a character device",devname);

minor = statb.s_addr[0].d_minor;
copy(list[0].name,"_dzorcar");	/* put in name */
nlist("/unix",list);
fd = open("/dev/kmem",2);
if (fd < 0)
	xerr("can't open /dev/kmem");
if (list[0].n_value == 0)
	xerr("can't find _dzorcar");
posn = list[0].n_value + minor/8;
bit = 1<<(minor%8);
lseek(fd,posn,0);
if (read(fd,&byte,1) < 0)
	xerr("kmem read error");
if (!sflg)
	printf("%s was %s, now %s\n",tty,HOW(byte&bit),HOW(lflg));
if (lflg)
	byte |= bit;
else
	byte &= ~bit;
lseek(fd,posn,0);
if (write(fd,&byte,1) < 0)
	xerr("kmem write error");		/* write it back */
close(fd);
exit(0);
}

char *basename(name) register char *name;
{
register char *p = name;
while (*name)
	if (*name++ == '/')
		p = name;
return(p);
}

xerr(fmt,d1,d2,d3,d4) char *fmt;
{
if (sflg)
	exit(1);
err(fmt,d1,d2,d3,d4);
}
