#

#define	CHARRATE	(132.0/0.8)
#define	LINERATE	0.08	/* line feed speed */
#define	CRRATE	0.15	/* carriage return overhead */

int fin;
int lines, chars;
int min, secs;
float time;		/* time to print it */

main(argc,argv) char **argv;
{
register char *argp;

--argc;
++argv;
if (argc > 0)
	{
	while (--argc >= 0)
		{
		if (fopen(argp = *argv++,&fin) < 0)
			err("can't open %s",argp);
		printf("%s: ",argp);
		pages();
		}
	}
else
	pages();
exit(0);
}

pages()
{
register int c;
register int line;
register int page;

line = page = 0;
time = 0;
lines = chars = 0;

while (c = getchar())
	{
	switch(c)
		{
	case '\t':
		chars = (chars+8) & ~ 07;	/* up to next column */
		break;
	case '\n':
	case '\r':
		if(chars)
			time =+ chars/CHARRATE + CRRATE;
		chars = 0;
		if (c == '\r')
			break;
		time =+ LINERATE;
		++lines;
		if (++line < 60)
			break;
	case 014:
		++page;
		line = 0;
	default:
		++chars;
		}
	}
if (line)
	++page;
printf("%d pages",page);
min = time/60.0;
secs = time-min*60.0+0.5;
if (min)
	printf(" %d min",min);
if (secs)
	printf(" %d secs",secs);
putchar('\n');
}
