#define	BUFFSIZE	16384
#define	NOREW	-1

#define	WTM	0
#define	FSF	1
#define	BSF	2
#define	FSR	3
#define	BSR	4
#define	REW	5
#define	OFF	6

#define	WTM_1	7
#define	EOT	8

char *com[]{
	"wtm=",
	"fsf=",
	"bsf=",
	"fsr=",
	"bsr=",
	"rew",
	"off",
	"wtm",
	"eot",
	0 };
char *mesg "usage: tcon fsf=n fsr=n bsf=n bsr=n rew wtm=n off wtm eot\n";
char *tname;

int fil;
main(argc,argv) int argc;
char **argv;
{
	int err;
	int arg[3],ic,i,l;
	register int c;
	int lookup();
	tname= "/dev/rmt0";
	ic = 2;
	if(argc <= 1)printf(mesg);
	else{
		c = argv[1][0];
		ic = 1;
		if (c >= '0' && c <= '7')
		{
			tname[8] = c;
			++ic;
		}
		fil= open(tname,2);
		if(fil <= 0)perror(tname);
		else
			while (ic < argc) {
				if((l = lookup(argv[ic])) < 0) 
					{
					printf(mesg);
					ic = argc;
					}
				else{
					switch(l)
						{
					case WTM_1:
						tcon(WTM,3);
						tcon(BSF,4);
						break;
					case EOT:
						eot();
						break;
					default:
						if (tcon(l,atoi(&argv[ic][4])) < 0)
							ic=argc;
						}
				}
				ic++;
			}
		tcon(NOREW,0);
		close(fil);
	}
exit(0);
}
int lookup(str) char *str;
{
	int i,j; 
	char c;
	for(i=0; com[i] != 0; i++) {
		for(j = 0; (c = com[i][j]) == str[j] && c != '\0' && c != '=';j++);
		if(c == str[j])return(i);
	}
	return(-1);
}

char *tmerrs[]
{ 
	"ready", "rewinding", "write-lock", "settling", "7-track",
	"bot", "on-line", "no-memory", "bad-tape", "length-error",
	"end-of-tape", "grant-late", "parity-error", "CRC-error",
	"EOF-detected", "illegal-command" };

tapestatus()
{
	int arg[3];
	register int i;

	gtty(fil,arg);
	if (arg[1])
		printf("residual=%d\n");
	if (arg[0] == 0)
		return;
	printf(" tmerr=%o ",arg[0]);
	for (i=0; i<16; ++i)
		if (arg[0] & (1<<i))
			printf(" %s",tmerrs[i]);
	if (arg[2])
		printf(" soft errors=%d",arg[2]);
	printf("\n");
}

tcon(fn,count)
{
	int arg[3],err;

	arg[0] = fn;
	arg[1] = count;
	arg[2] = 0;
	if((err = stty(fil,arg)) < 0)
	{
		tapestatus();
		perror(tname);
	}
	return(err);
}

eot()
{
/*
 * find the end of tape.
 */
char *buff;
register int l;

buff = sbrk(BUFFSIZE);
if (buff == -1)
	err("can't allocate positioning buffer");
while ((l = read(fil,buff,BUFFSIZE)) > 0)
	{
	printf("l = %d\n",l);
	tcon(FSF,1);
	}
printf("l = %d\n",l);
tcon(BSR,1);		/* ready to write again */
}
