      subroutine cmread(in,icom,length)
c
c     this subroutine reads the declaration statements and creates
c     the core location and type table from the source cards
c
c     in      is the logical input unit containing the common block
c     icom    is the common number (1=supcom, 2=blank)
c     length  is where the length of the common block is returned
c
      logical*1 ibuff(600)
      logical eqcmp
      logical*1 rpar(1),comma(1)
      logical*1 nams(10,7),idel(4)
      logical*1 icombr(2)
      logical*1 name(8)
      common / comcom / int(9),incfac,lencom,name
      common /sizcom/ iwdsiz(8)
      dimension lwds(2,100)
c
c     nbpi = number of bytes per integer
c     nbpr = number of bytes per real
c
      common /nbcm/ nbpi, nbpr
      logical*1 blanks(1),blank
      equivalence (blanks(1),blank)
      data blank/' '/
      data rpar,comma/')', ','/
      data idel / ' ','(',')',',' /
      data nams/
     1 'i','n','t','e','g','e','r',  3*' ',
     2 'i','n','t','e','g','e','r','*','2',  ' ',
     3  'r','e','a','l',  6*' ',
     4  'l','o','g','i','c','a','l'  ,3*' ',
     5  'l','o','g','i','c','a','l','*','1',' ',
     6  'c','o','m','m','o','n',  4*' ',
     7  'd','i','m','e','n','s','i','o','n',  ' '/
      data icombr / ',','(' /
c
c     initialize calls
c
c     initialize values in common
      int(2) = 0
      int(9)=icom
      incfac = 0
      lencom = 0
      len = 0
      istop = 0
c
    1 continue
      call rdstmt(ibuff,last,len,istop,in)
      if(last.eq.0) go to 99
c
c     get length of first keyword (integer, common etc)
c
   14 call scset(idel,4)
      call nscan(ibuff,last,lwds,100,nwd)
      nc = lwds(2,1) - lwds(1,1) + 1
      is = lwds(1,1)
      if (nc .gt. 10) nc = 10
c
c     find name from table of name types
c
      do 10 i = 1, 7
      if(eqcmp(nc,ibuff(is),nams(1,i))) go to 11
   10 continue
      go to 98
   11 ityp = i
   13 if (ityp .ge. 8) go to 89
      call fandc(ibuff,last,blanks,1,is,ifin,icf,iret)
      go to (71,98),iret
c
c     search for  , or  (
c
   71 istrt = ifin + 1
      call fandc(ibuff,last,icombr,2,istrt,ifin,icf,iret)
      go to (72,26),iret
   72 go to (31,41), icf
c
c     this variable not subscripted,  call conrot
   31 if (last .le. istrt) go to 1
      call conrot(ibuff(istrt), ifin-istrt+1,ityp)
      go to 71
c
c     this variable is subscripted, find out parenthesis and then next c
   41 call fandc(ibuff,last,rpar,1,ifin,ifin1,icf,iret)
      go to (42,97),iret
   42 call fandc(ibuff,last,comma,1,ifin1, ifin2,icf,iret)
      go to (43,26),iret
   43 call conrot(ibuff(istrt),ifin2 - istrt + 1, ityp)
      ifin = ifin2
      go to 71
c
c     this section is for the last variable on a card
   26 call conrot(ibuff(istrt), last - istrt + 1, ityp)
c
c     move previous buffer in and reset last
      go to 1
c
c     this section for treating equivalence and data statements
   89 last = 0
      go to 1
c
c
c     error return for no closeing parenthesis
   97 write(6,5)
    5 format(' no closing parenthesis in common statements')
      go to 90
c
   98 write(6,15)
   15 format(' undetermined type in common file.')
c
   90 write(6,91)
   91 format(' record causing error was:')
      write(6,92) (ibuff(i),i=1,last)
   92 format(1x,80a1)
c
c     normal return
c
   99 continue
      length = lencom
      return
      end
      subroutine rdstmt(ibuff,last,len,istop,in)
      logical*1 ibuff(600), newbuf(80)
      logical*1 blank, icc
      logical eqc
      data blank,icc /' ', 'c'/
c
c
c        read in one fortran statement into ibuff
c        on initial entry istop=0 and len=0
c        when last=0 on return all stmts have been found
c
c     done when istop is set to 1
c
      last = 0
      if(len.gt.0) go to 102
    1 if(istop.eq.1) go to 99
      call reed(newbuf,len,0,id,in,iret)
      if(iret.ne.1) go to 109
  102 continue
c
c     check to see if this a comment, if so skip
      if(eqc(newbuf(1),icc)) go to 1
c
c     if last is 0 this is new statement
    6 if (last .ne. 0) go to 7
      call mavec(len,newbuf,ibuff,ir)
      last = len
      len = 0
      go to 1
c
c     check to see if this is a continuation, if so don't find type
    7 if(eqc(newbuf(6),blank)) go to 99
c
c     for continuation just tack newbuff on to ibuff
   12 l = last + len -6
      if(l.gt.600) go to 200
      call mavec(len-6,newbuf(7),ibuff(last+1),iretx)
      last = l
      len = 0
      go to 1
c
c     too long an input record
c
  200 write(6,210)
  210 format('common statement > 600 characters, excess ignored.')
      go to 1
c
c     set istop=1:  we have encountered a end of file, finish this buffe
c     set len to 0 so next read (if any) gets and eof indication
c
  109 istop = 1
      len = 0
   99 return
      end
      subroutine init
c
c     init for main simcon segments
c
c **********************************************************************
      logical*1 names,vname
      common / supcom / nplot, iplotq(10), pltmax(10), names(8,10),
     1 nline, defmax, iyear, logunt, lengtl, mhcb, ichcb, nkep,
     2 ifar, idump, igplt, ilplt, igetv(10), iybeg, iyend,
     3 lsupcm, nyskip,vmaxs(10), vname(8,10), idum1, idum2, idum3, idum4
c **********************************************************************
      integer entsiz,pcklen
      common /kcc/ entsiz,nents
      common /sizcom/ iwdsiz(8)
      common /nbcm/ nbpi, nbpr
      logical*1 buff(1)
c
c
c     files used
c
c     file  use
c
c     16 buffer for view commands
c     13 idump file
c     19 supcom source - initer initialization file
c     2 user's common block source
c     5 command input
c     6 command output
c     1 batch command input
c
      call config
c
c     set up table of variable sizes
c
      iwdsiz(1) = nbpi
      iwdsiz(2) = 2
      iwdsiz(3) = nbpr
      iwdsiz(4) = nbpi
      iwdsiz(5) = 1
      call syinit
      nents=1-entsiz
      ichcb = 0
c
c     read in simcon's common block description from file
c
      call initer(19)
      call sysfn(2)
c
c     read in user common block description from unit 2
c     via the cmread routine, then free unit 2.
c
      call cmread(2,2,lengtl)
      call sysfn(1)
c
c     zero user's common block
c
      call varmv(3,1,1,lengtl,0.0)
c
      return
      end
      subroutine initer(in)
c **********************************************************************
      logical*1 names,vname
      common / supcom / nplot, iplotq(10), pltmax(10), names(8,10),
     1 nline, defmax, iyear, logunt, lengtl, mhcb, ichcb, nkep,
     2 ifar, idump, igplt, ilplt, igetv(10), iybeg, iyend,
     3 lsupcm, nyskip,vmaxs(10), vname(8,10), idum1, idum2, idum3, idum4
c **********************************************************************
c
c     initer:
c     performs initialization of simcon's common block and
c     hash table.
c
c     variable information block
c
c     word  contents
c
c     1 type 1=integer, 3=real, 4=logical*1
c     2 location in common starts at 1 (in bytes)
c     3 length (in bytes)
c     4 number of subscripts
c     5-8 maximum subscripts
c     9 common block 1=supcom 2=.$$$$.
c
      integer idat(9),subs(4)
      logical*1 name(8)
      integer lens(4)
      integer types(4)
      integer type
      equivalence (idat(1),itype),(idat(2),iloc),(idat(3),len),
     1  (idat(4),nsubs),(idat(5),subs(1)),(icom,idat(9))
c
c     call cmread to read in a fake version of supcom with the external
c     names (usually prefixed by a "#") and the labelled common removed.
c
      call cmread(in,1,iloc)
c
c     at this point 'iloc' has the total length of simcon's
c     common block in bytes. setc is used to zero all
c     of the common block to start. variables not defaulting to
c     zero are individually set.
c
   99 continue
      call setc(iloc,nplot,0)
      lsupcm=iloc
c     initialize variables in common
      ntimes=100
      nkep=100
      nline=60
      defmax=100
      logunt=6
      ilplt=1
      iybeg=1
      iyend=100
      nyskip=1
      iathcb=-1
      igplt = 1
      igrtyp=1
c     idump = 1
      ipolcy=1
      mhcb=9997
      return
      end
      subroutine conrot(istr,il,itypp)
c
c     this routine takes a name and dimensions from common
c     and converts it to the calls for the table setting routines
c
c     it then calls the table creation routine and enters table values
c
c     istr    is the name of variable
c     il      is the length of the name in istr.
c     itype   is the type of specification statement.
c
      logical*1 ii, nn, istr(72), name(8)
      logical*1 ints(6)
      dimension itab(2,4)
      common /comcom/ int(9), incfac, lencom, name
      common /sizcom/ iwdsiz(8)
c
      logical eqc
      logical*1 lb
      data lb/'#'/
      data ints/ 'i', 'j', 'k', 'l', 'm', 'n'/
      data ii / 'i' /
      data nn / 'n' /
c
c
c     set up type
c
      itt = itypp
      int(1) = itt
c
c     call subdet to find subscript values
c
      call subdet(istr,il,itab,name,iret1)
      go to (101,91),iret1
c
c     loop over itab to fill in number of subscripts and maxima
c
  101 int(4) = 0
      do 100 i = 1, 4
      int(4+i) = 1
      if (itab(2,i) .le. 1) go to 100
      int(4) = int(4) + 1
      int(i+4) = itab(2,i)
  100 continue
c
c     if int(1) less than 6 then type is specified on declaration card
      if (int(1) .lt. 6) go to 21
c
c     this section for find type of undefined types
c     if name starts with '#' test second letter for default type.
c
      int(1)=3
      i=1
      if(eqc(name(1),'#')) i=2
      call fandc(name(i),1,ints,6,1,ifff,icf,iret2)
      if(iret2.eq.1) int(1)=1
c
c     set lengths, move in name, etc.
   21 iiwdsz = iwdsiz(int(1))
c
c     calculate total size of variable (or array) by multiplying
c     each subscript maximum by the element size.
c
   81 int(3) = int(5)*int(6)*int(7)*int(8)*iiwdsz
c
c     determine location in common and call table entry routine
      if (itt .ne. 6) go to 121
c      int(2) = ((int(2) + iiwdsz - 1) / iiwdsz) * iiwdsz
  121 call taset(itt)
      if (itt .ne. 6) go to 88
      int(2) = int(2) + int(3)
   88 return
   91 return
      end
      subroutine taset(itt)
c
c     this subroutine takes calls from conrot and calls the table
c     setting routines for input program
c     if itt is 6 then this is common block and see if there was old
c     entry.  if itt is not 6 then make entry without checking
c
      logical*1 name(8)
      dimension intdum(9), ihld(9)
      common /comcom/ int(9), incfac, lencom, name
      common /sizcom/ iwdsiz(8)
c
c **********************************************************************
      logical*1 names,vname
      common / supcom / nplot, iplotq(10), pltmax(10), names(8,10),
     1 nline, defmax, iyear, logunt, lengtl, mhcb, ichcb, nkep,
     2 ifar, idump, igplt, ilplt, igetv(10), iybeg, iyend,
     3 lsupcm, nyskip,vmaxs(10), vname(8,10), idum1, idum2, idum3, idum4
c **********************************************************************
c
c
      logical*1 blk(1)
      data blk/' '/
c
c     copy int to ihld
c
      do 10 i = 1, 9
      ihld(i) = int(i)
   10 continue
c
      ihld(2) = int(2) + incfac
c
c     see if this is common (itt = 6).  if so look up, otherwise make en
      if (itt .ne. 6) go to 101
c
c     get old values since this is common, if no old value go to 201
      call ihsh(2,name,intdum,ir2)
      if(ir2.eq.2) go to 201
c
c     already defined, merge information
c
      ihld(1) = intdum(1)
c     go through both entries and merge information
      do 20 i = 3, 9
      if(ihld(i) .lt. intdum(i)) ihld(i) = intdum(i)
   20 continue
c
c     reset length here based upon iwdsiz
c
      ihld(3) = iwdsiz(ihld(1)) * ihld(5) * ihld(6) * ihld(7) * ihld(8)
c
c     replace existing entry with merged entry
c
      call ihsh(5,name,ihld,ir2)
c
c     increase incfac
      incfac = incfac + ihld(3) - int(3)
      ilasst = ihld(2) + ihld(3)
      go to 99
c
c     add increment factor to int(2), then subtract it after call
c
  201 int(2) = int(2) + incfac
      call ihsh(1,name,int,ir2)
      ilasst = int(2) + int(3)
      int(2) = int(2) - incfac
      go to 99
c
c     enter string with no changes
c
  101 call ihsh(1,name,int,ir2)
      ilasst = int(2) + int(3)
   99 lencom = ilasst
      return
      end
