      subroutine lplt6(p,pmax,name,it,itb)
c
c     this routine produces a print plot from a file on
c     the disk.  p is a array containing the x and y values
c     and pmax contains the x maximum and y maximum.
c     if itb = it  it means this is an initialization
c     to actually get the plot printed on unit 7 you
c     must    call ppchar(i,j,' ',3)  only the 3 is important
c
      logical*1 name(8,2), obuff(24)
      character*24 cbuff
      equivalence (obuff,cbuff)
      dimension p(2), pmax(2)
      common /lpcom/ x,y
      logical*1 cx,ib,ii,is
      data cx,ib,ii,is/ 'x', ' ', 'i', '*'/
c
      if (itb .ne. it) go to 11
      call ppchar(1,1,ib,2)
c     put up the x and y axis
      do 10 ix = 10, 100
      call ppchar(ix,5,cx,1)
   10 continue
      do 20 iy = 5, 50
      call ppchar(10,iy,ii,1)
   20 continue
c
c     write out the variable names
      do 30 i = 1, 8
      call ppchar(i+54,3,name(i,1),1)
      call ppchar(7,40-i,name(i,2),1)
   30 continue
c
c     write out the variable maxima
c     encode(24,15,obuff) pmax(1), pmax(2)
      write(cbuff,15) pmax(1), pmax(2)
   15 format(2g12.5)
      do 40 i = 1, 12
      call ppchar(i+87,3,obuff(i),1)
      call ppchar(i+1,50,obuff(i+12),1)
   40 continue
c
c     set up starting points
      x = p(1)
      y = p(2)
      iyold = 0
      go to 99
c
c     come here to plot individual points
c     calculate slope and intercept of line to know y location
   11 ixbb = x/pmax(1) * 89 + 10
      ixee = p(1)/pmax(1) * 89 + 10
      ixb = min0(ixbb,ixee)
      ixe = max0(ixbb,ixee)
      slope = (p(2)-y)/(p(1)-x+.000001)
      b = y - slope * x
c
      do 110 ix = ixb, ixe
      xx = (ix-10.)/89. * pmax(1)
      yiy = slope * xx + b
      iy = yiy/pmax(2) * 45. + 5.
      if (iyold .eq. 0) iyold = iy
      iyb = min0(iyold,iy)
      iye = max0(iyold,iy)
      do 120 iyv = iyb, iye
      call ppchar(ix,iyv,is,1)
  120 continue
      iyold = iy
  110 continue
      x = p(1)
      y = p(2)
   99 return
      end
      subroutine lplt52(y,ymax,itime,iyb,npar,id1,id2,iwgra,ifn)
c **********************************************************************
c
      logical*1 names,vname
      common / supcom / nplot, iplotq(10), pltmax(10), names(8,10),
     1 nline, defmax, iyear, logunt, lengtl, mhcb, ichcb, nkep,
     2 ifar, idump, igplt, ilplt, igetv(10), iybeg, iyend,
     3 lsupcm, nyskip,vmaxs(10), vname(8,10), idum1, idum2, idum3, idum4
c **********************************************************************
      dimension store(100,6), y(5), ymax(5)
      data nmax/6/
c
c     this routine does a cal-comp plot instead of printer plot
c     it will only handle three variables for 100 time periods
c
      is = (itime-iybeg)/nyskip + 1
      if (is .gt. 100) is = 100
      if (npar .gt. nmax) npar = nmax
c      save values
      do 10 i = 1, npar
      store(is,i) = y(i)
   10 continue
      if (itime .lt. (iyend - nyskip + 1)) go to 99
      call p1130
      call scalf(8./is,8.,0.,0.)
      call fgrid(0,0.,0.,1.,is)
      call fgrid(1,0.,0.,.1,10)
      posn=1.0+npar*.1
      do 20 iv = 1, npar
      call fchar(0.,posn,.25,.25,0.)
      posn=posn-0.1
      go to (61,71), iwgra
   61 write(7,5) (names(i,iv),i=1,8), ymax(iv)
    5 format(8a1,g12.5,1x)
      go to 81
   71 write(7,55) (vname(i,iv),i=1,2), ymax(iv)
55    format(2a4,g12.5,1x)
   81 call pflag
	call pendn
      call point(iv)
      call penup
      do 20 it = 1, is
      if (store(it,iv) .gt. ymax(iv)) go to 20
      call fplot(0,it*1.,store(it,iv)/ymax(iv))
      call pendn
      call point(iv)
   20 continue
      call psend
      call pltcls
   99 return
      end
      subroutine ppchar(ixxx,iyyy,is,ient)
      logical*1 is, buff(100)
      integer out
      logical*1 blk
      data blk/' '/
      out=3
c
c     this routine manipulates the disk image for print plots
c     if ient = 1 it puts character is in the disk image at ix, iy
c     if ient = 2 it blanks out the disk image
c     if ient = 3 it prints out the disk image
c
      ix = ixxx
      iy = iyyy
      go to (1,2,3), ient
    1 if (iy .lt. 1) iy = 1
      if (iy .gt. 55) iy = 55
      if (ix .lt. 1) ix = 1
      if (ix .gt. 100) ix = 100
      read(19'iy) buff
      call mavec(1,is,buff(ix),id)
      write(19'iy) buff
      go to 99
c
c     this section to define file and blank out the disk image
c      define file 19(55,50,u,n19)
	call dfile(19,55,50,n19)
    2 continue
      call setc(100,buff,lbk)
      do 20 iy = 1, 55
      write(19'iy) buff
   20 continue
      go to 99
c
c     this section prints out the disk image and ends file 19
    3 continue
	call setfil(out,'+lpr ')
      do 30 iy = 1, 55
      iyy = 56 - iy
      read(19'iyy) buff
      write(out,5) buff
    5 format(' ',100a1)
   30 continue
      end file 19
      write(out,40)
   40 format('1')
      end file out
   99 return
      end
      subroutine viewx(inbuff,len,ifn)
c
c     main routine for view, print, etc. commands
c     that process the common dump file on unit 13.
c     the variable's locations are determined and then the common
c     block file is scanned for each variable. for commands requiring a
c     maxmum value (normally graphics output) the file is scanned twice,
c     once for the maximum, then for the actually output. exception is
c     when a "max=" value is actually specified on the command.
c
c      ifn    function
c     1       graphics (plotter) output
c     2       print command output
c     3       printer plot output
c
      logical*1 inbuff(4), name(8)
      dimension itab(2,4), idata(9), p(10)
      common / help / is1, if1, is2, if2, is3, if3, is4, if4
      common /sizcom/ iwdsiz(8)
      equivalence (itab(1,1),is1)
      equivalence (loccom,idata(2)),(nsub,idata(4))
      equivalence (ityp,idata(1))
c **********************************************************************
      logical*1 names,vname
      common / supcom / nplot, iplotq(10), pltmax(10), names(8,10),
     1 nline, defmax, iyear, logunt, lengtl, mhcb, ichcb, nkep,
     2 ifar, idump, igplt, ilplt, igetv(10), iybeg, iyend,
     3 lsupcm, nyskip,vmaxs(10), vname(8,10), idum1, idum2, idum3, idum4
c **********************************************************************
c
      logical*1 maxeq(5), blk
      logical*1 vs(4)
      data vs/' ','v','s',' '/
      data maxeq, blk/' ','m','a','x','=',  ' '/
c
c     for any view command processing idump must be on, so check it
c
      if(idump.eq.0) go to 98
c     get the variables common locations moved
c
c     if this is a vs command set up ivs indicator
      ivs = 0
c
c     initialize logical unit for view print output
c
      logu=6
c
c     scan for "vs" keyword, and if found set vs flag. then
c     erase "vs" from the command line and proceed.
c
      call fandst(inbuff,len,vs,4,1,if,irtnn)
      if (irtnn .ne. 1) go to 201
      ivs = 1
      call setc(2,inbuff(if+1),blk)
  201 continue
c
c     determine the maxima (either specified or from data values)
c
      maxset = 0
      valmx = -1.0e20
      call valfnd(inbuff,len,maxeq,5,valmx,irt)
      if(irt.eq.1) maxset = 1
      do 110 i = 1, 10
      vmaxs(i) = valmx
  110 continue
      call fandst(inbuff,len,maxeq,5,1,if,irt)
      if (irt .eq. 1) len = if - 1
      iv = 0
c
c     loop through the line picking up the various variables
c     present.
c
      do 100 i=1,10
      call stgt(inbuff,len,name,inl,idata,itab,iv,irt)
      go to (31,41,199),irt
   31 call mavec(8,name,vname(1,iv),irt)
c     calculate incriment
      lenw = iwdsiz(ityp)
      id2 = idata(5)
      id3 = id2 * idata(6)
      id4 = id3 * idata(7)
      incrim = is1+((is2-1)*id2)+((is3-1)*id3)+((is4-1)*id4)
      incrim = (incrim * lenw ) - (lenw - 1)
      igetv(iv) = loccom + incrim
      if (ityp .eq. 1) igetv(iv) = -igetv(iv)
      nv = iv
  100 continue
c
c     come here after all variables are gotten to do the plotting
c
   41 ient = 1
      if (maxset .eq. 1 .or. ifn.eq.2) ient = 2
      iyy = iyear - iybeg+ 1
   61 continue
c
c     loop over all years in simulation gathering variables required
c     and disposing of them via various plot routines
c
      iymax = (iyend-iybeg)/nyskip+1
      if(iymax.le.100) go to 15
      write(6,16) iymax
   16 format(' too many dump periods (',i5,' ), only 100 used.')
      iymax = 100
   15 continue
      iyy = iybeg
      do 10 iy = 1,iymax
      call vwget(p,nv,igetv,lengtl,iy,iymax,iret)
      if(iret.ne.1) go to 199
      go to (20,30),ient
c
c     first pass, get the maximums
c
   20 continue
      do 25 i=1,nv
      if(p(i).gt.vmaxs(i)) vmaxs(i) = p(i)
   25 continue
      go to 10
c
c     second pass, do the actual work
c
   30 continue
      if (ivs .eq. 0) call lplt5(p,vmaxs,iyy,iybeg,nv,nline,logu,2,ifn)
      if (ivs .eq. 1) call lplt6(p,vmaxs,vname,iybeg,iyy,ifn)
   10 iyy = iyy + nyskip
c
c     if ient = 1 then we just found the maxima, go back and plot them
c
      ient = ient + 1
      if(ient.eq.2) go to 61
c
c     if printer plotting flush out rest of the buffer
c
   99 if (ivs .eq. 1) call ppchar(1,1,blk,3)
  199 continue
      return
   98 write(6,97)
   97 format(' #idump must be on for use of the view command.')
      return
      end
      subroutine vwget(p,nv,igetv,lengtl,iy,iymax,iret)
c
c     routine to get variables from common block dump file
c     at record "iy". information about variable is in "igetv"
c     there are nv variables to be gotten.
c
      real p(10)
      integer igetv(10)
c
c     if first time period save user common block elsewhere
c
      if(iy.ne.1) go to 1
      call ucomio(2,lengtl,-1,iret)
      if(iret.ne.1) go to 99
    1 continue
      call ucomio(1,lengtl,iy,iret)
      if(iret.ne.1) go to 99
      do 10 i=1,nv
      call varget(igetv(i),p(i))
   10 continue
      if(iy.eq.iymax) call ucomio(1,lengtl,-1,iret)
      return
   99 write(6,98) iy
   98 format(' error in common block dump file i/o at ',i5)
      return
      end
