#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include "treedef.h"

static int ntotal = 0;		/* total in all grps */

char *hd[] = "n ", "min ", "max ", "ranksum", "mean ", "var ",
	       "sd  ", "se  ", "  ----95% ci----", "";

/* print the data. do an inorder traversal of the data tree. print the
group stats assoc with each data node */

pr_grpstat(root)
DTNODE *root;
{
	extern int echo;
	register int i=(-1);
	if (echo)
		printf("\n\n\n");
	printf("\n**GROUP STATS (variance from n-1 df)**\n");
	printf("%6s", " ");
	while ( *hd[i++] )
		printf("%8s ", hd[i]);
	printf("\n");
	grpstat(root);
	printf("TOTAL==>%6d\n",ntotal);
}

grpstat(root)
DTNODE *root;
{
	float mean, var, sd, se, low_95, high_95;
	extern int ntotal;

	if(root != NULL){
		grpstat(root->ltd);
		ntotal += root->na;

/* print key, n, min, max, sd, se ranksum */
	if (root->na < 2)
		printf("\n>>> %s ==>NO STATS, SAMPLE SIZE < 2!\n",root->dkey);
	else {
		statcalc(root, &mean, &var, &sd, &se, &low_95, &high_95);
		printf("\n>>> %s ==>\n%14d %8.2f %8.2f %8.2f ",root->dkey, root->na, root->min, root->max, root->ranksum);
		printf("%8.3f %8.3f %8.3f %8.3f %8.3f %8.3f\n", mean,var,sd,se,low_95,high_95);
	}
	grpstat(root->rtd);
	}
}
