#include <stdio.h>
#include <ctype.h>

#define	MAXLEN	512
char *datafile = "data";
char *progfile = ".enter";
char *nospace="nospace";

#ifdef DEBUG
#define	TRACEF(x) if(tflg){fputs("\n+\t",stdout);printf x;}
#else
#define TRACEF(x) /* nothing */
#endif

#define false 0
#define	CMD	'~'	/* for commands */
#define	PROMPT	0
#define	FMT	1
#define REPEAT	1
#define SUBOFS	1
#define LENGTH	2
#define	DEFAULT	3
#define OPENBRACE	'{'
#define CLOSEBRACE	'}'

struct pattern
{
struct pattern *next;
char *prompt;
char *fmt;			/* printf type format for this item */
char *line;			/* pointer to data place */
int length;			/* max length of the line */
char *def;			/* default value */
char issubfld;			/* true if a subfld node */
char includ;			/* true if subfld node & to be written */
struct pattern *subfld;		/* if ! NULL, then there is a subfield */
}	*first,
	*lastnode,	/* patnode ptr in last element of patnodes */
	*getnode(),	/* returns ptr to a alloced patt node */
	**patnodes;	/* vector to point to elements of linked list */

FILE *prog, *data;
char line[MAXLEN];
int endfirst=1;			/* if true then a NULL 1st line means EOT */
int reuseflg;
int tflg;
int vflg;
int cflg;
int Fflg, Rflg, Oflg, oflg;
int linecnt;			/* keeps count of the script file line number */
int rec_cnt;			/* keeps count of the user's output records */
char delim[] = {":"};
char *OFS = "";			/* default output field separator */
char *ORS = "\n";		/* output record separator */
char *subofs="";			/* OFS to print after subflds */
#define	MAXPTRS	10
char *ptrs[MAXPTRS];
int ntimes = 32767;
char *nodebotch = "nodecnt botch";
int nnodes;			/* number of usr nodes as alloced from prog */
#define BUMPNODE(n) (n<nnodes)?(n++):(err(nodebotch))
int lineno;			/* number of current prompt */
int curnode;			/* current prompt node as in array patnodes */
int pending;
char *save(), *strsave(), *any(), copy(), *malloc(), *calloc();

		/* declarations for the qalloc (quick alloc) buffer */
int BSIZ=1024;	/* must be >= max data line length */
char *allocbuf;
char *bufptr;
char *qalloc();
char *whichbuf[2];
char *bufbase;
int bufswitch;
#define CLR_ALLOCBUF(x) bufbase=bufptr=whichbuf[bufswitch++ % 2]
#define BUF_INIT(x)	if(!(allocbuf=malloc(BSIZ * 2))) err(nospace);\
			whichbuf[0]=allocbuf;\
			whichbuf[1]=allocbuf + BSIZ
			

		/* end qalloc declarations */

		/* argument data for $0 $1 $2 ... */
#define MAXDOLLAR 10
int dollarcnt;
char *dollar[MAXDOLLAR];

main(argc,argv) int argc; char **argv;
{
register int i;
char *argp;

BUF_INIT();

for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		++argp;
		while (*argp)
			switch(*argp++)
				{
			case 'r':
				reuseflg++;
				break;
			case 'S':		/* realloc the the allocbuf */
				BSIZ = cvtint(&argp);
				free(allocbuf);
				if(!(allocbuf=malloc(BSIZ)))
					err(nospace);
				break;
			case 'e':
				endfirst = 0;
				break;
			case 'h':
				printf("%s\n",argv[++i]);
				break;
			case 'v':
				++vflg;		/* no echo */
				break;
			case 'R':
				ORS = save(argp);
				++Rflg;
				while (*argp)
					++argp;
				break;
			case 'o':
				++oflg;
				subofs = save(argp);
				while (*argp)
					++argp;
				break;
			case 'O':		/* output FS */
				++Oflg;
				OFS = save(argp);
				while (*argp)
					++argp;
				break;
			case 'F':
				++Fflg;
				delim[0] = *argp++;
				break;
			case 'f':
				progfile = argv[++i];
				break;
			case 'N':
				lineno++;
				break;
			case 'n':
				ntimes = cvtint(&argp);
				break;
			case 'C':
				rec_cnt = cvtint(&argp);
				break;
			case 't':		/* debug trace */
				++tflg;
				break;
			case 'c':
				++cflg;		/* create data file */
				break;
			default:
				printf("invalid option %s\n",argp-1);
				break;
				}
		}
	else
		{
		datafile = argp;
		for (; i<argc; ++i)
			{
			if(dollarcnt >= MAXDOLLAR)
				err("Too many $$ args");
			if(!(dollar[dollarcnt++] = save(argv[i])))
				{
				err(nospace);
				TRACEF(("dollar[%d] = %s", dollarcnt-1, dollar[dollarcnt-1]));
				}
			}
		}
	}
if (!tflg)
	setout();

if ((prog = fopen(progfile,"r")) == NULL)
	err("cannot open program file '%s'",progfile);

getprog();
fclose(prog);
if ((data = fopen(datafile,cflg ? "w" : "a")) == NULL)
	err("cannot open data file '%s'",datafile);
if (first == NULL)
	err("no program specifed");
if (vflg)
	printf("The information will be written to the file '%s'\n\n",datafile);
while (ntimes--)
	{
	CLR_ALLOCBUF();		/* set the allocbuf ptr back to zero */
	++rec_cnt;		/* incr the record counter */
	getdata();
	}
}


getprog()
{
register struct pattern *newpat=NULL, *prev=NULL, *prevsub=NULL;
struct pattern *tmp, *endpattern;
int braceflg=0, n, repcnt;
char *mismatch="%s : brace mismatch";

nextline:
while (getln(line, sizeof line, prog) != EOF)
	{
	TRACEF(("progline='%s'",line));
	substitute(line, allocbuf, dollar, dollarcnt);
	TRACEF(("$$sub, line now='%s'", line));

	if(*line == 0 || *line == '\n')	/* line empty after $ substitute */
		goto nextline;

	++linecnt;
	switch(line[0])
		{
		case '-' :	dashline(line);
				goto nextline;
			
		case OPENBRACE:	
				if(braceflg++)
					err(mismatch,progfile);
				if(!first)
					err("%s: %d Can't have a subfield w/o major field",progfile,linecnt);
				n = parse(line,ptrs,MAXPTRS,delim);
				repcnt = 0;
				if(n == 2)
					repcnt = atoi(ptrs[REPEAT]);
				if(!repcnt)
					repcnt = 1;

				TRACEF(("line %d=%c",linecnt,OPENBRACE));
				goto nextline;

		case CLOSEBRACE:
				if(!braceflg)
					err(mismatch,progfile);
				braceflg = 0;

	/* internally generate subfld nodes repcnt times */
			for(endpattern = prevsub; --repcnt;)
				{
				for(tmp=prev->subfld;;tmp = tmp->next)
					{
					newpat = getnode();
					newpat->length = tmp->length;
					newpat->prompt = tmp->prompt;
					newpat->fmt = tmp->fmt;
					newpat->def = tmp->def;
					newpat->issubfld++;
					prevsub->next = newpat;
					prevsub = newpat;
					if (tmp == endpattern)
						break;
					}
				}
				goto nextline;
			}

	newpat = getnode();

	promptline(line, newpat);

	if(braceflg)			/* process the sub fields */
		{
		newpat->issubfld++;	/* mark this node as a subfld */
		if(!prev->subfld) {
			TRACEF(("\tPREV WAS SUBFLD PROMPT=%s", prev->prompt));
			prev->subfld = newpat;
		}
		else
			prevsub->next = newpat;
		prevsub = newpat;
		}
			
	else				/* process the major fields */
		{
		if(!first)
			first = newpat;
		else
			prev->next = newpat;
		prev = newpat;
		}
	}

	if(braceflg)
		err("%s : Missing subfield brace",progfile);

		/* alloc pattnode vector, add one for null last element */
		/* null last element is used as a sentinel */
	patnodes=(struct pattern **) calloc(nnodes+1, sizeof(struct pattern *));
	if(!patnodes)
		err(nospace);

			/* load the patnodes vector with the linked list ptrs */
	for(n=0, prev=first; prev; prev=prev->next)
		{
		patnodes[BUMPNODE(n)] = prev;
		if(prev->subfld)
			for(tmp=prev->subfld; tmp; tmp=tmp->next)
				patnodes[BUMPNODE(n)] = tmp;
		}
		
	TRACEF(("number of usr nodes=%d",nnodes));
}

		/* alloc a new node and bump up the node counter (nnodes)
		 * return ptr to the new node.
		 */
struct pattern *getnode()
{
register struct pattern *newpat;

	if(!(newpat = (struct pattern *) calloc(1,sizeof (struct pattern))))
		err(nospace);
	++nnodes;
	return(newpat);
}

promptline(line, s)
char line[];
register struct pattern *s;
{
	register int len;
	int n;

	n = parse(line,ptrs,MAXPTRS,delim);
	if (n <= 1)
		err("%s: %d invalid format %s missing - %s", progfile,linecnt,delim,line);
	if ((len = atoi(ptrs[LENGTH])) == 0)
		len = MAXLEN;
	if (len > MAXLEN)
		err("%s: %d - pattern line length '%d' > %d",
			progfile,linecnt,len,MAXLEN);
	s->length = len;
	s->prompt = save(ptrs[PROMPT]);
	s->fmt = save(ptrs[FMT]);
	s->def = save(ptrs[DEFAULT]);
	TRACEF(("prompt=%s length=%d line=%0o fmt=%s def=%s",s->prompt,s->length,s->line,s->fmt,s->def));
}

		/* process the user's switches from the script file */
dashline(line)
char line[];
{
char *argp=line+2;

	switch(line[1])
		{
		case 'r':
			reuseflg++;
			break;
		case 'S':
			BSIZ = cvtint(&argp);
			free(allocbuf);
			if(!(allocbuf=malloc(BSIZ)))
				err(nospace);
			break;
		case 'e':
			endfirst=0;
			break;
		case 'c':
			++cflg;		/* create data file */
			break;
		case 'N':
			lineno++;
			break;
		case 'n':
			ntimes = cvtint(&argp);
			break;
		case 'v':
			++vflg;		/* echo verbosely */
			break;
		case 'C':
			rec_cnt = cvtint(&argp);
			break;
		case 'R':
			if (!Rflg)
				ORS = save(line+2);
			break;
		case 'o':		/* subflield subofs */
			if(!oflg)
				subofs = save(line+2);
			break;
		case 'O':		/* output FS */
			if (!Oflg)
				OFS = save(line+2);
			break;
		case 'F':
			if (!Fflg)
				delim[0] = line[2];
			break;
		case 'd':
			datafile = save(line+2);
			break;
		case 'h':
			printf("%s\n",line+2);
			break;
		default:
			printf("invalid option %s\n",line);
			break;
		}
}

getdata()
{
register struct pattern *s, *prev=NULL, **p;
int flg;


	/* get data from user */
for(p=patnodes, curnode = 0; *p; ++curnode, ++p)
	{
	if ((*p)->subfld)
		printf("%s\n", (*p)->prompt);
	else if (promptusr(*p) == EOF)
		{
		if((*p)->issubfld == false)	/* eof on major node=quit */
			exit(0);
		while((*p)->issubfld && (*p))
			{
			(*p)->line = NULL;
			(*p++)->includ = false;
			++curnode;
			}
		TRACEF(("ignored subflds up to %s",((*p))?((*p)->prompt):("END OF LIST")));
		--p;	/* decr pointer, for loop bumps it back up */
		--curnode;
		putc('\n', stdout);
		continue;
		}
	(*p)->includ++;
	} /* for */

				/* write usr replies to datafile */
TRACEF(("OFS=%s \t subofs=%s",OFS,subofs));
p = patnodes;
for (curnode=0, s = *p; s; ++curnode, prev = s, s = *++p)
	{
	if(s->subfld || !s->includ)
		{
		if (*OFS && prev->subfld)
			{
			TRACEF(("all subflds are null, printing OFS=%s",OFS));
			fprintf(data,"%s",OFS);
			}
		continue;
		}
	if(prev)
		{
		TRACEF(("\n"));
		TRACEF(("\tprev-line=%s\tcurr-line=%s",prev->line,s->line));
		TRACEF(("\tprev-prompt=%s\tcurr-prompt=%s",prev->prompt,s->prompt));
		TRACEF(("\tprev-issubfld=%d\tcurr-issubfld=%d\tcurr-includ=%d",prev->issubfld,s->issubfld,s->includ));
		if(*subofs && prev->issubfld && s->issubfld && s->includ)
			{
			TRACEF(("printing subofs=%s",subofs));
			fprintf(data,"%s",subofs);
			}
		else if (*OFS)
			{
			TRACEF(("printing OFS=%s",OFS));
			fprintf(data,"%s",OFS);
			}
		}
	if(s->issubfld)
		{
		if(s->includ == false)		/* do not print this subfld */
			{
			TRACEF(("ignoring subfld:prompt=%s",patnodes[curnode]->prompt));
			continue;
			}

		else				/* print the subfld */
			{
			TRACEF(("print field=%s",s->line));
			fprintf(data, s->fmt, s->line);
			}
		}
	else	/* not a subfld */
		{
		TRACEF(("print field=%s",s->line));
		fprintf(data,s->fmt,s->line);
		}
	}	/* end of writing for loop */

fprintf(data,"%s",ORS);
putc('\n',stdout);
fflush(data);
}

promptusr(s)
register struct pattern *s;
{
register int l;
register char *def = s->def;
int n;

retry:
	if(lineno)
		printf("%3d) ", curnode+1);
	fputs(s->prompt,stdout);
	if(reuseflg && ((def = s->line) || (def = s->def)) && *def )
		printf("{%s} ", def);
	fflush(stdout);

	if ((l=getln(line,sizeof line, stdin)) == EOF)
		{
		printf("^D\n");
		return(EOF);
		}

	if (l == 0 && reuseflg)
		{
		s->line = qalloc(def);
		return(1);
		}

	else if (l == 0)
		{
		if (s == first && endfirst)
			exit(0);
		copy(line,def);
		}
	if (line[0] == CMD && isdigit(line[1]) && any(&line[2],"c"))
		{
		if(pending)
			{
			printf("First change:\n");
			goto retry;
			}

		n = atoi(&line[1]) - 1;	/* subtr one to make C subscript */

		if(n < 0 || n >= curnode)
			{
			printf("Err:'%d' is out of range\n", n+1);
			goto retry;
			}	
		if(patnodes[n]->subfld)
			{
			printf("Not allowed to change %s\n",patnodes->prompt);
			goto retry;
			}

			/* do not allow usr to jump into middle of
			 * null lined subflds
			 */
		l = n - 1;	/* examine n-1th node */
		if(patnodes[l]->issubfld && !patnodes[l]->line)
			{
			printf("Err:can't change subfield, previous prompt (=%s) is NULL\n",patnodes[l]->prompt);
			goto retry;
			}

		++pending;		/* flag:change is about to occur */
		printf("Was:%s%s\n", patnodes[n]->prompt, patnodes[n]->line);
		l = curnode;		/* save curr node */
		curnode = n;		/* reset curr node to usr specified # */
		promptusr(patnodes[n]); /* prompt for change */
		patnodes[n]->includ++;
		curnode = l;		/* restore curr node */
		pending = false;	/* shut off pending flag */
		goto retry;		/* retry old current line */
		}
	else if (line[0] == CMD && line[1] == 'r')
		{
		if(!s->line)
			{
			printf("Can't reuse, no previous line\n");
			goto retry;
			}
		else
			{
			printf("reusing:%s%s\n",s->prompt,s->line);
			s->line = qalloc(s->line);
			}
		return;
		}
	else if (line[0] == CMD)
		{
		docmd(line+1);
		goto retry;
		}
	if (l > s->length)
		{
		printf("only %d characters are allowed--try again\n",s->length);
		goto retry;
		}
	if(allwhite(line)) *line = '\0';
			/* put usr line in quick allocator */
	s->line = qalloc(line);
	return(1);
}

allwhite(s)
register char *s;
{
register char c;
while(c = *s++)
	if (!isspace(c))
		return(false);
return(1);
}
	

parse(line,ptrs,nptrs,delim) char *line, *ptrs[], *delim; int nptrs;
{
register char *p, *q;
register int n;
int i;

for (n = 0, p = line; *p; )
	{
	ptrs[n++] = p;
	if (n >= nptrs)
		err("too many delimeters");
	if ( q = any(p,delim) )
		{
		*q++ = 0;
		p = q;
		}
	else
		{
		p = endstr(p);
		break;
		}
	}
for (i=n; i<nptrs; )
	ptrs[i++] = p;
return(n);
}


docmd(line) char *line;
{
int n;
char *badcmd="invalid command: %s\n";

if (isdigit(*line) || *line == '.')
	{
	if(*line == '.')
		{
		n = curnode + 1;
		++line;
		}
	else
		n = cvtint(&line);

	--n;
	if(n > curnode || n < 0)
		{
		printf("prompt %d out of range\n",n+1);
		return;
		}

	switch(*line)
		{
		case 'p':
			if(patnodes[n]->subfld)
				printf("%s is a title for minor fields\n",patnodes[n]->prompt);
			else if(patnodes[n]->line)
				printf("%3d) %s%s\n",n+1,patnodes[n]->prompt,patnodes[n]->line);
			break;
		default:
			printf(badcmd, line);
			break;
		}
	return;
	}


switch(line[0])
	{
case '!':
	system(line+1);
	break;
case 'q':
	exit(0);
	break;
case 'l':
	sprintf(line,"/usr/bin/lines -last %s",datafile);
	system(line);
	break;
case 'v':
	if(curnode==0)
		{
		sprintf(line,"vi %s",datafile);
		system(line);
		}
	else
		printf("~v only works at 1st prompt\n");
	break;
case 'e':
	sprintf(line,"edit %s",datafile);
	system(line);
	break;
case 'h':
	system("help enter");
	break;
case 'N':
	printf("RECORD #%d\n", rec_cnt);
	break;
default:
	printf(badcmd,line);
	}
}


		/* purpose: take a usr response and put it away
		 * 	in a big alloc buffer.
		 * input:usr line.
		 * returns:char * to start addr of usr's line in
		 * alloc buf.
		 */
char *qalloc(s)
register char *s;
{
register char *bp=bufptr;
register char *endbuf=bufbase+BSIZ;
char *startbuf=bp;

while(*bp++ = *s++)
	if (bp >= endbuf)
		err("qalloc:buf overflow");
bufptr = bp;
return(startbuf);
}
