	/* purpose: report the minimum, maximum, average lengths of lines
	 * in a file. also report the number of lines.
	 * the report includes the newline character.
	 * usage: length [file..]
	 * where file can be "-" for stdin
	 */

#define BSIZ	512
char buf[BSIZ];
#define READ	0
#define STDIN	0

int n;
long int maxline, minline, linecnt, charcnt, len, totchars;
char *filename = "-";

main(argc, argv)
int argc;
char *argv[];
{
	register int i, openflg = 0;
	int fd = 0;

	for(i=1; i < argc; i++)
	{
		filename = argv[i];
		if(filename[0] == '-' && filename[1] == '\0')
			length(STDIN);
		else {
			if((fd = open(argv[i], READ)) < 0)
				err("cannot open %s", argv[i]);
			length(fd);
			close(fd);
		}
		++openflg;
	}
	if (openflg == 0)
		length(STDIN);
	exit(0);
}

length(fd)
int fd;
{
	register char *p, *endbuf;
	char *base;
	double lines, tot;
		
	totchars = len = linecnt = 0;
	while((n = read(fd, buf, BSIZ))) {
		totchars += n;
		for(endbuf = &buf[n],base=p=buf; p < endbuf; ) {
			if(*p++ == '\n') {

				charcnt = p - base + len; /* len of line */
				len = 0;

				if (linecnt == (long) 0)  /* very 1st line */
					minline = maxline = charcnt;

				else {			  /* subsequent lines */
					if(charcnt > maxline)
						maxline = charcnt;
					if(charcnt < minline)
						minline = charcnt;
				}

				base = p;  /* save pointer to start of a line */
				++linecnt;
			}
		}
		len += p - base;	/* save len of line from prev buffer */
	}

		/* if there are no lines in the file set lines = 1
		 * so divide in printf does not bomb */
	lines = (linecnt == (long) 0) ? ( 1 ) : (linecnt);
	tot = totchars;
	printf("%s: %ld %ld %1.1f %ld\n",
		filename, minline, maxline, tot / lines, linecnt);
}
