	parameter (lablsz = 32)
	parameter (degrad = 0.0174532925)
	parameter (up = 0)
	parameter (down = 1)
	parameter (wasup = -1)
	real xscale, yscale, x, y
	real xsize, ysize, theta
	real g(8)
	integer ptype, penpos
	integer*4 line
	character*2 key
	character*100 args, buf
	character*32 xlab, ylab
	character*1 xleq(lablsz), yleq(lablsz), amper, blank
	common line
	equivalence (xlab,xleq), (ylab,yleq)
	data amper/'&'/, blank/' '/

	line = 0
	ptype = -5
	penpos = up

100	read(5, 200, end=2000) key, args
200	format(a, 1x, a)
	line = line + 1

	
	if ( key .eq. 'go' )then
		read (args, *, err=1800 ) x, y
		call fplot (0, x, y)
	else if ( key .eq. 'pu' ) then
		call penup
		penpos = up
	else if ( key .eq. 'pd' ) then
		call pendn
		penpos = down
	else if ( key .eq. 'dp' ) then
		if ( ptype .lt. 0) call err ('sp not defined\0')
		if (penpos .eq. up) then
			call pendn
			penpos = wasup
		endif
		call point(ptype)
		if ( penpos .eq. wasup) then
			call penup
			penpos = up
		endif
	else if ( key .eq. 'wr' ) then
		read(args,*,err=1800) x, y, xsize, ysize, theta, buf
		call fchar ( x, y, xsize, ysize, theta * degrad)
		write(7,300)  buf
300		format(a)
		call pflag
	else if ( key .eq. 'pr' ) then
		write(6,300) args
	else if ( key .eq. 'in' ) then
		call p1130
	else if ( key .eq. 'sc' ) then
		read (args, *, err=1800 ) xscale, yscale, x0, y0
		call scalf(xscale, yscale, x0, y0)
	else if ( key .eq. 'se' ) then
		call psend
	else if ( key .eq. 'sp' ) then
		read(args, 200) buf
		if (buf .eq. '+') then
			ptype = 0
		else if (buf .eq. 'x' ) then
			ptype = 1
		else if (buf .eq. 'rt' ) then
			ptype = 2
		else if (buf .eq. 'dt' ) then
			ptype = 3
		else if (buf .eq. 'lt' ) then
			ptype = 4
		else if (buf .eq. 'ut' ) then
			ptype = 5
		else
			call err('bad ptype\0')
			stop
		endif

	else if ( key .eq. 'g2' ) then
		read(args, *, err=1800) g, xlab, ylab
		do 350 k = lablsz-2, 1, -1
			if ( xleq(k) .ne. blank .or. k .eq. 1) then
				xleq(k+1) = amper
				xleq(k+2) = amper
				goto 355
			endif
350		continue
355		do 360 k = lablsz-2, 1, -1
			if (yleq(k) .ne. blank .or. k .eq. 1) then
				yleq(k+1) = amper
				yleq(k+2) = amper
				goto 365
			endif
360		continue

365		call ggr(g(1),g(2),g(3),g(4),g(5),g(6),g(7),g(8),xlab,ylab)

	else if ( key .eq. 'g1' ) then
		read(args, *, err=1800) buf, x, y, ticspc, n
		if ( buf .eq. '+x' ) then
			i = 0
		else if ( buf .eq. '-x') then
			i = 2
		else if ( buf .eq. '+y') then
			i = 1
		else if ( buf .eq. '-y') then
			i = 3
		else
			call err('bad axis\0')
		endif
		call fgrid(i, x, y, ticspc, n)

c blank and comment lines
	else if ( key .eq. '##' .or. key .eq. '  ' ) then
		goto 100
	else if ( key .eq. 'of' ) then
		read(args, 300) buf
		call pltini(buf)
	else if ( key .eq. 'cf' ) then
		call pltcls
	else if ( key .eq. 'tx') then
		call pltini('!tx4010\0')
	else
		call err('unknown command\0')	
	endif
	goto 100


1800	call err('bad number\0')
2000	stop
	end

	subroutine err(msg)
	character*1 msg(1), null
	character*14 prog
	integer getarg
	integer*4 line
	common line
	data null/'\0'/

	call setfil(8, '/dev/tty\0')
	len = getarg (0, prog, 14)

	do 100 j = 1, 999
		if ( msg(j) .eq. null) goto 150
100	continue
150	write(8, 200) len, prog, line, (msg(i), i= 1, j)
200	format(a?, ':line ', i1, '-', 100a1)
	stop
	end
