	parameter (slope=6)
	parameter (yintrc=12)
	real ans(16)
	integer n
	character*60 line
	data n/0/
	data line/'	 ------------------------------------------------'/

c init regress
	call ireg

c read data
100	read(5,*,end=200,err=1200) x, y
		n = n + 1
		call preg(x, y)
	goto 100

c compute answer
200	call freg(ans)

c write report
	write(6,*) ' '
	write(6,*) '== Anova table for regression ==>'
	write(6,*) line
	write(6,*) '	 source    df       sumsq      meansq       Fstat'
	write(6,*) ' '

c print variation source due to regression
	itmp=1
	nm2 = n - 2
	unexms = ans(15) / nm2
	fs = ans(14) / unexms
	write(6,300) itmp, ans(14), ans(14), fs
300	format('regression ', i10, f12.3, f12.3, f12.3)

c print variation source due to error/unexplained
	write(6,400) nm2, ans(15), unexms
400	format('unexplained', i10, f12.3, f12.3 )

c print total
	nm1 = n - 1
	write(6,500) nm1, ans(9)
500	format('total      ', i10, f12.3)
	write(6,*) line
	write(6,600) ans(16)
600	format('	Prob. that regression accounts ',
     + 		'for obs. variation = ', g1.4)

	write(6,*) ' '
	write(6,*) '== Regression Equation ==>'
	write(6,*) line
	write(6,700) ans(slope), ans(yintrc)
700	format('	Y = ', g1.4, ' * X + ', g1.4)
	write(6,*) line

c calc se of regress coeff
	se = sqrt(unexms / ans(5))
c get the t table value
	tval = probf(0.05, 1, nm2)
	xtmp = sqrt(tval) * se
	xlow = ans(slope) - xtmp
	xhigh = ans(slope) + xtmp
d	write(6,*) xtmp, xlow, xhigh, tval
c report slope stats
	write(6,*) ' '
	write(6,*) '== Regression Parameters ==>'
	write(6,*) line
	write(6,*) 'Parameter    value          se              95%ci' 
	write(6,*) ' '
	write(6,800) ans(slope), se, xlow, xhigh
800	format('  slope', f12.4, f12.4, f15.4, '  ', f1.4)
	write(6,*) line

	write (6,*) ' '
	stop

c bad data
1200	n = n + 1
	call setfil(8,'/dev/tty\0')
	write(8,1400) 
1400	format('bad data near xy-pair', i1)
	stop
	end
